/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTPermission;
import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import sun.awt.DisplayChangedListener;
import sun.awt.SunDisplayChanger;
import sun.awt.X11ComponentPeer;
import sun.awt.X11GraphicsConfig;
import sun.awt.X11GraphicsEnvironment;
import sun.java2d.loops.SurfaceType;
import sun.java2d.opengl.GLXGraphicsConfig;
import sun.java2d.xr.XRGraphicsConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X11GraphicsDevice
extends GraphicsDevice
implements DisplayChangedListener {
    int screen;
    HashMap x11ProxyKeyMap = new HashMap();
    private static AWTPermission fullScreenExclusivePermission;
    private static Boolean xrandrExtSupported;
    private final Object configLock = new Object();
    private SunDisplayChanger topLevels = new SunDisplayChanger();
    private DisplayMode origDisplayMode;
    private boolean shutdownHookRegistered;
    GraphicsConfiguration[] configs;
    GraphicsConfiguration defaultConfig;
    HashSet doubleBufferVisuals;

    public X11GraphicsDevice(int screennum) {
        this.screen = screennum;
    }

    private static native void initIDs();

    public int getScreen() {
        return this.screen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProxyKeyFor(SurfaceType st) {
        HashMap hashMap = this.x11ProxyKeyMap;
        synchronized (hashMap) {
            Object o = this.x11ProxyKeyMap.get(st);
            if (o == null) {
                o = new Object();
                this.x11ProxyKeyMap.put(st, o);
            }
            return o;
        }
    }

    public native long getDisplay();

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getIDstring() {
        return ":0." + this.screen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphicsConfiguration[] getConfigurations() {
        if (this.configs == null) {
            Object object = this.configLock;
            synchronized (object) {
                this.makeConfigurations();
            }
        }
        return this.configs;
    }

    private void makeConfigurations() {
        if (this.configs == null) {
            int i = 1;
            int num = this.getNumConfigs(this.screen);
            GraphicsConfiguration[] ret = new GraphicsConfiguration[num];
            ret[0] = this.defaultConfig == null ? this.getDefaultConfiguration() : this.defaultConfig;
            boolean glxSupported = X11GraphicsEnvironment.isGLXAvailable();
            boolean xrenderSupported = X11GraphicsEnvironment.isXRenderAvailable();
            boolean dbeSupported = X11GraphicsDevice.isDBESupported();
            if (dbeSupported && this.doubleBufferVisuals == null) {
                this.doubleBufferVisuals = new HashSet();
                this.getDoubleBufferVisuals(this.screen);
            }
            while (i < num) {
                int visNum = this.getConfigVisualId(i, this.screen);
                int depth = this.getConfigDepth(i, this.screen);
                if (glxSupported) {
                    ret[i] = GLXGraphicsConfig.getConfig(this, visNum);
                }
                if (ret[i] == null) {
                    boolean doubleBuffer = dbeSupported && this.doubleBufferVisuals.contains(visNum);
                    ret[i] = xrenderSupported ? XRGraphicsConfig.getConfig(this, visNum, depth, this.getConfigColormap(i, this.screen), doubleBuffer) : X11GraphicsConfig.getConfig(this, visNum, depth, this.getConfigColormap(i, this.screen), doubleBuffer);
                }
                ++i;
            }
            this.configs = ret;
        }
    }

    public native int getNumConfigs(int var1);

    public native int getConfigVisualId(int var1, int var2);

    public native int getConfigDepth(int var1, int var2);

    public native int getConfigColormap(int var1, int var2);

    public static native boolean isDBESupported();

    private void addDoubleBufferVisual(int visNum) {
        this.doubleBufferVisuals.add(new Integer(visNum));
    }

    private native void getDoubleBufferVisuals(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphicsConfiguration getDefaultConfiguration() {
        if (this.defaultConfig == null) {
            Object object = this.configLock;
            synchronized (object) {
                this.makeDefaultConfiguration();
            }
        }
        return this.defaultConfig;
    }

    private void makeDefaultConfiguration() {
        if (this.defaultConfig == null) {
            int visNum = this.getConfigVisualId(0, this.screen);
            if (X11GraphicsEnvironment.isGLXAvailable()) {
                this.defaultConfig = GLXGraphicsConfig.getConfig(this, visNum);
                if (X11GraphicsEnvironment.isGLXVerbose()) {
                    if (this.defaultConfig != null) {
                        System.out.print("OpenGL pipeline enabled");
                    } else {
                        System.out.print("Could not enable OpenGL pipeline");
                    }
                    System.out.println(" for default config on screen " + this.screen);
                }
            }
            if (this.defaultConfig == null) {
                int depth = this.getConfigDepth(0, this.screen);
                boolean doubleBuffer = false;
                if (X11GraphicsDevice.isDBESupported() && this.doubleBufferVisuals == null) {
                    this.doubleBufferVisuals = new HashSet();
                    this.getDoubleBufferVisuals(this.screen);
                    doubleBuffer = this.doubleBufferVisuals.contains(new Integer(visNum));
                }
                if (X11GraphicsEnvironment.isXRenderAvailable()) {
                    System.out.println("XRender pipeline enabled");
                    this.defaultConfig = XRGraphicsConfig.getConfig(this, visNum, depth, this.getConfigColormap(0, this.screen), doubleBuffer);
                } else {
                    this.defaultConfig = X11GraphicsConfig.getConfig(this, visNum, depth, this.getConfigColormap(0, this.screen), doubleBuffer);
                }
            }
        }
    }

    private static native void enterFullScreenExclusive(long var0);

    private static native void exitFullScreenExclusive(long var0);

    private static native boolean initXrandrExtension();

    private static native DisplayMode getCurrentDisplayMode(int var0);

    private static native void enumDisplayModes(int var0, ArrayList<DisplayMode> var1);

    private static native void configDisplayMode(int var0, int var1, int var2, int var3);

    private static native void resetNativeData(int var0);

    private static synchronized boolean isXrandrExtensionSupported() {
        if (xrandrExtSupported == null) {
            xrandrExtSupported = X11GraphicsDevice.initXrandrExtension();
        }
        return xrandrExtSupported;
    }

    @Override
    public boolean isFullScreenSupported() {
        SecurityManager security;
        boolean fsAvailable;
        boolean bl = fsAvailable = this.screen == 0 && X11GraphicsDevice.isXrandrExtensionSupported();
        if (fsAvailable && (security = System.getSecurityManager()) != null) {
            if (fullScreenExclusivePermission == null) {
                fullScreenExclusivePermission = new AWTPermission("fullScreenExclusive");
            }
            try {
                security.checkPermission(fullScreenExclusivePermission);
            }
            catch (SecurityException e) {
                return false;
            }
        }
        return fsAvailable;
    }

    @Override
    public boolean isDisplayChangeSupported() {
        return this.isFullScreenSupported() && this.getFullScreenWindow() != null;
    }

    private static void enterFullScreenExclusive(Window w) {
        X11ComponentPeer peer = (X11ComponentPeer)((Object)w.getPeer());
        if (peer != null) {
            X11GraphicsDevice.enterFullScreenExclusive(peer.getContentWindow());
        }
    }

    private static void exitFullScreenExclusive(Window w) {
        X11ComponentPeer peer = (X11ComponentPeer)((Object)w.getPeer());
        if (peer != null) {
            X11GraphicsDevice.exitFullScreenExclusive(peer.getContentWindow());
        }
    }

    @Override
    public synchronized void setFullScreenWindow(Window w) {
        Window old = this.getFullScreenWindow();
        if (w == old) {
            return;
        }
        boolean fsSupported = this.isFullScreenSupported();
        if (fsSupported && old != null) {
            X11GraphicsDevice.exitFullScreenExclusive(old);
            this.setDisplayMode(this.origDisplayMode);
        }
        super.setFullScreenWindow(w);
        if (fsSupported && w != null) {
            if (this.origDisplayMode == null) {
                this.origDisplayMode = this.getDisplayMode();
            }
            X11GraphicsDevice.enterFullScreenExclusive(w);
        }
    }

    private DisplayMode getDefaultDisplayMode() {
        GraphicsConfiguration gc = this.getDefaultConfiguration();
        Rectangle r = gc.getBounds();
        return new DisplayMode(r.width, r.height, -1, 0);
    }

    @Override
    public synchronized DisplayMode getDisplayMode() {
        if (this.isFullScreenSupported()) {
            return X11GraphicsDevice.getCurrentDisplayMode(this.screen);
        }
        if (this.origDisplayMode == null) {
            this.origDisplayMode = this.getDefaultDisplayMode();
        }
        return this.origDisplayMode;
    }

    @Override
    public synchronized DisplayMode[] getDisplayModes() {
        if (!this.isFullScreenSupported()) {
            return super.getDisplayModes();
        }
        ArrayList<DisplayMode> modes = new ArrayList<DisplayMode>();
        X11GraphicsDevice.enumDisplayModes(this.screen, modes);
        DisplayMode[] retArray = new DisplayMode[modes.size()];
        return modes.toArray(retArray);
    }

    @Override
    public synchronized void setDisplayMode(DisplayMode dm) {
        if (!this.isDisplayChangeSupported()) {
            super.setDisplayMode(dm);
            return;
        }
        Window w = this.getFullScreenWindow();
        if (w == null) {
            throw new IllegalStateException("Must be in fullscreen mode in order to set display mode");
        }
        if (dm == null || (dm = this.getMatchingDisplayMode(dm)) == null) {
            throw new IllegalArgumentException("Invalid display mode");
        }
        if (!this.shutdownHookRegistered) {
            this.shutdownHookRegistered = true;
            Runnable r = new Runnable(){

                public void run() {
                    Window old = X11GraphicsDevice.this.getFullScreenWindow();
                    if (old != null) {
                        X11GraphicsDevice.exitFullScreenExclusive(old);
                        X11GraphicsDevice.this.setDisplayMode(X11GraphicsDevice.this.origDisplayMode);
                    }
                }
            };
            Thread t = new Thread(r, "Display-Change-Shutdown-Thread-" + this.screen);
            Runtime.getRuntime().addShutdownHook(t);
        }
        X11GraphicsDevice.configDisplayMode(this.screen, dm.getWidth(), dm.getHeight(), dm.getRefreshRate());
        w.setBounds(0, 0, dm.getWidth(), dm.getHeight());
        ((X11GraphicsEnvironment)GraphicsEnvironment.getLocalGraphicsEnvironment()).displayChanged();
    }

    private synchronized DisplayMode getMatchingDisplayMode(DisplayMode dm) {
        DisplayMode[] modes;
        if (!this.isDisplayChangeSupported()) {
            return null;
        }
        for (DisplayMode mode : modes = this.getDisplayModes()) {
            if (!dm.equals(mode) && (dm.getRefreshRate() != 0 || dm.getWidth() != mode.getWidth() || dm.getHeight() != mode.getHeight() || dm.getBitDepth() != mode.getBitDepth())) continue;
            return mode;
        }
        return null;
    }

    @Override
    public synchronized void displayChanged() {
        this.defaultConfig = null;
        this.configs = null;
        this.doubleBufferVisuals = null;
        X11GraphicsDevice.resetNativeData(this.screen);
        this.topLevels.notifyListeners();
    }

    @Override
    public void paletteChanged() {
    }

    public void addDisplayChangedListener(DisplayChangedListener client) {
        this.topLevels.add(client);
    }

    public void removeDisplayChangedListener(DisplayChangedListener client) {
        this.topLevels.remove(client);
    }

    public String toString() {
        return "X11GraphicsDevice[screen=" + this.screen + "]";
    }

    static {
        if (!GraphicsEnvironment.isHeadless()) {
            X11GraphicsDevice.initIDs();
        }
    }
}

