/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Font;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.peer.MenuPeer;
import java.lang.reflect.Field;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.SunToolkit;
import sun.awt.X11.XBaseMenuWindow;
import sun.awt.X11.XMenuItemPeer;
import sun.awt.X11.XMenuWindow;

public class XMenuPeer
extends XMenuItemPeer
implements MenuPeer {
    private static Logger log = Logger.getLogger("sun.awt.X11.XMenuPeer");
    XMenuWindow menuWindow;
    private static final Field f_items = SunToolkit.getField(Menu.class, "items");

    XMenuPeer(Menu target) {
        super(target);
    }

    void setContainer(XBaseMenuWindow container) {
        super.setContainer(container);
        this.menuWindow = new XMenuWindow(this);
    }

    public void dispose() {
        if (this.menuWindow != null) {
            this.menuWindow.dispose();
        }
        super.dispose();
    }

    public void setFont(Font font) {
        this.resetTextMetrics();
        XMenuWindow menuWindow = this.getMenuWindow();
        if (menuWindow != null) {
            menuWindow.setItemsFont(font);
        }
        this.repaintIfShowing();
    }

    public void addSeparator() {
        if (log.isLoggable(Level.FINER)) {
            log.finer("addSeparator is not implemented");
        }
    }

    public void addItem(MenuItem item) {
        XMenuWindow menuWindow = this.getMenuWindow();
        if (menuWindow != null) {
            menuWindow.addItem(item);
        } else if (log.isLoggable(Level.FINE)) {
            log.fine("Attempt to use XMenuWindowPeer without window");
        }
    }

    public void delItem(int index) {
        XMenuWindow menuWindow = this.getMenuWindow();
        if (menuWindow != null) {
            menuWindow.delItem(index);
        } else if (log.isLoggable(Level.FINE)) {
            log.fine("Attempt to use XMenuWindowPeer without window");
        }
    }

    Vector getTargetItems() {
        try {
            return (Vector)f_items.get(this.getTarget());
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
            return null;
        }
    }

    boolean isSeparator() {
        return false;
    }

    String getShortcutText() {
        return null;
    }

    XMenuWindow getMenuWindow() {
        return this.menuWindow;
    }
}

