/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.peer.CanvasPeer;
import sun.awt.ComponentAccessor;
import sun.awt.SunToolkit;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11GraphicsConfig;
import sun.awt.X11GraphicsDevice;

class XCanvasPeer
extends XComponentPeer
implements CanvasPeer {
    private boolean eraseBackgroundDisabled;

    XCanvasPeer() {
    }

    XCanvasPeer(XCreateWindowParams params) {
        super(params);
    }

    XCanvasPeer(Component target) {
        super(target);
    }

    void preInit(XCreateWindowParams params) {
        super.preInit(params);
        if (SunToolkit.getSunAwtNoerasebackground()) {
            this.disableBackgroundErase();
        }
    }

    void resetTargetGC(Component target) {
        ComponentAccessor.resetGC(target);
    }

    public void displayChanged(int screenNum) {
        this.resetLocalGC(screenNum);
        this.resetTargetGC(this.target);
    }

    void resetLocalGC(int screenNum) {
        if (this.graphicsConfig != null) {
            int visual = this.graphicsConfig.getVisual();
            X11GraphicsDevice newDev = (X11GraphicsDevice)GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()[screenNum];
            for (int i = 0; i < newDev.getNumConfigs(screenNum); ++i) {
                if (visual != newDev.getConfigVisualId(i, screenNum)) continue;
                this.graphicsConfig = (X11GraphicsConfig)newDev.getConfigurations()[i];
                break;
            }
            if (this.graphicsConfig == null) {
                this.graphicsConfig = (X11GraphicsConfig)GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()[screenNum].getDefaultConfiguration();
            }
        }
    }

    protected boolean shouldFocusOnClick() {
        return true;
    }

    public void disableBackgroundErase() {
        this.eraseBackgroundDisabled = true;
    }

    protected boolean doEraseBackground() {
        return !this.eraseBackgroundDisabled;
    }

    public void setBackground(Color c) {
        boolean doRepaint = false;
        if (this.getPeerBackground() == null || !this.getPeerBackground().equals(c)) {
            doRepaint = true;
        }
        super.setBackground(c);
        if (doRepaint) {
            this.target.repaint();
        }
    }
}

