/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicMenuItemUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthPopupMenuUI;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;
import sun.swing.plaf.synth.SynthIcon;
import sun.swing.plaf.synth.SynthUI;

class SynthMenuItemUI
extends BasicMenuItemUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;
    private SynthStyle accStyle;
    private String acceleratorDelimiter;
    static Rectangle iconRect = new Rectangle();
    static Rectangle textRect = new Rectangle();
    static Rectangle acceleratorRect = new Rectangle();
    static Rectangle checkIconRect = new Rectangle();
    static Rectangle arrowIconRect = new Rectangle();
    static Rectangle viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
    static Rectangle r = new Rectangle();

    SynthMenuItemUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        return new SynthMenuItemUI();
    }

    static Dimension getPreferredMenuItemSize(SynthContext context, SynthContext accContext, JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap, String acceleratorDelimiter) {
        JMenuItem b = (JMenuItem)c;
        Icon icon = b.getIcon();
        String text = b.getText();
        KeyStroke accelerator = b.getAccelerator();
        String acceleratorText = "";
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = acceleratorText + acceleratorDelimiter;
            }
            acceleratorText = (keyCode = accelerator.getKeyCode()) != 0 ? acceleratorText + KeyEvent.getKeyText(keyCode) : acceleratorText + accelerator.getKeyChar();
        }
        Font font = context.getStyle().getFont(context);
        FontMetrics fm = b.getFontMetrics(font);
        FontMetrics fmAccel = b.getFontMetrics(accContext.getStyle().getFont(accContext));
        SynthMenuItemUI.resetRects();
        SynthMenuItemUI.layoutMenuItem(context, fm, accContext, text, fmAccel, acceleratorText, icon, checkIcon, arrowIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, text == null ? 0 : defaultTextIconGap, defaultTextIconGap);
        r.setBounds(textRect);
        int totalIconWidth = 0;
        int maxIconHeight = 0;
        if (icon != null) {
            totalIconWidth += SynthMenuItemUI.iconRect.width;
            if (SynthMenuItemUI.textRect.width > 0) {
                totalIconWidth += defaultTextIconGap;
            }
            maxIconHeight = Math.max(SynthMenuItemUI.iconRect.height, maxIconHeight);
        }
        if (checkIcon != null) {
            totalIconWidth += SynthMenuItemUI.checkIconRect.width;
            if (SynthMenuItemUI.textRect.width > 0 || icon != null) {
                totalIconWidth += defaultTextIconGap;
            }
            maxIconHeight = Math.max(SynthMenuItemUI.checkIconRect.height, maxIconHeight);
        }
        int arrowWidth = 0;
        if (arrowIcon != null) {
            arrowWidth += defaultTextIconGap;
            arrowWidth += SynthMenuItemUI.arrowIconRect.width;
            maxIconHeight = Math.max(SynthMenuItemUI.arrowIconRect.height, maxIconHeight);
        }
        int accelSpacing = 0;
        if (SynthMenuItemUI.acceleratorRect.width > 0) {
            accelSpacing += 4 * defaultTextIconGap;
        }
        SynthMenuItemUI.r.height = Math.max(SynthMenuItemUI.r.height, maxIconHeight);
        Container parent = b.getParent();
        if (parent instanceof JPopupMenu) {
            SynthPopupMenuUI popupUI = (SynthPopupMenuUI)SynthLookAndFeel.getUIOfType(((JPopupMenu)parent).getUI(), SynthPopupMenuUI.class);
            if (popupUI != null) {
                SynthMenuItemUI.r.width = popupUI.adjustTextWidth(SynthMenuItemUI.r.width);
                SynthMenuItemUI.r.width += popupUI.adjustIconWidth(totalIconWidth);
                SynthMenuItemUI.r.width += popupUI.adjustAccelSpacingWidth(accelSpacing);
                int totalAccelOrArrow = SynthMenuItemUI.acceleratorRect.width + arrowWidth;
                SynthMenuItemUI.r.width += popupUI.adjustAcceleratorWidth(totalAccelOrArrow);
            }
        } else if (!(parent == null || b instanceof JMenu && ((JMenu)b).isTopLevelMenu())) {
            SynthMenuItemUI.r.width += totalIconWidth + accelSpacing + SynthMenuItemUI.acceleratorRect.width + arrowWidth;
        }
        Insets insets = b.getInsets();
        if (insets != null) {
            SynthMenuItemUI.r.width += insets.left + insets.right;
            SynthMenuItemUI.r.height += insets.top + insets.bottom;
        }
        if (SynthMenuItemUI.r.width % 2 == 0) {
            ++SynthMenuItemUI.r.width;
        }
        if (SynthMenuItemUI.r.height % 2 == 0) {
            ++SynthMenuItemUI.r.height;
        }
        return r.getSize();
    }

    static void paint(SynthContext context, SynthContext accContext, Graphics g, Icon checkIcon, Icon arrowIcon, String acceleratorDelimiter, int defaultTextIconGap) {
        JComponent c = context.getComponent();
        JMenuItem b = (JMenuItem)c;
        ButtonModel model = b.getModel();
        Insets i = b.getInsets();
        SynthMenuItemUI.resetRects();
        viewRect.setBounds(0, 0, b.getWidth(), b.getHeight());
        SynthMenuItemUI.viewRect.x += i.left;
        SynthMenuItemUI.viewRect.y += i.top;
        SynthMenuItemUI.viewRect.width -= i.right + SynthMenuItemUI.viewRect.x;
        SynthMenuItemUI.viewRect.height -= i.bottom + SynthMenuItemUI.viewRect.y;
        SynthStyle style = context.getStyle();
        Font f = style.getFont(context);
        g.setFont(f);
        FontMetrics fm = SwingUtilities2.getFontMetrics(c, g, f);
        FontMetrics accFM = SwingUtilities2.getFontMetrics(c, g, accContext.getStyle().getFont(accContext));
        KeyStroke accelerator = b.getAccelerator();
        String acceleratorText = "";
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = acceleratorText + acceleratorDelimiter;
            }
            acceleratorText = (keyCode = accelerator.getKeyCode()) != 0 ? acceleratorText + KeyEvent.getKeyText(keyCode) : acceleratorText + accelerator.getKeyChar();
        }
        String text = SynthMenuItemUI.layoutMenuItem(context, fm, accContext, b.getText(), accFM, acceleratorText, b.getIcon(), checkIcon, arrowIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, b.getText() == null ? 0 : defaultTextIconGap, defaultTextIconGap);
        if (checkIcon != null) {
            SynthIcon.paintIcon(checkIcon, context, g, SynthMenuItemUI.checkIconRect.x, SynthMenuItemUI.checkIconRect.y, SynthMenuItemUI.checkIconRect.width, SynthMenuItemUI.checkIconRect.height);
        }
        if (b.getIcon() != null) {
            Icon icon;
            if (!model.isEnabled()) {
                icon = b.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                icon = b.getPressedIcon();
                if (icon == null) {
                    icon = b.getIcon();
                }
            } else {
                icon = b.getIcon();
            }
            if (icon != null) {
                SynthIcon.paintIcon(icon, context, g, SynthMenuItemUI.iconRect.x, SynthMenuItemUI.iconRect.y, SynthMenuItemUI.iconRect.width, SynthMenuItemUI.iconRect.height);
            }
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                g.setColor(style.getColor(context, ColorType.TEXT_FOREGROUND));
                g.setFont(style.getFont(context));
                style.getGraphicsUtils(context).paintText(context, g, text, SynthMenuItemUI.textRect.x, SynthMenuItemUI.textRect.y, b.getDisplayedMnemonicIndex());
            }
        }
        if (acceleratorText != null && !acceleratorText.equals("")) {
            int accOffset = 0;
            Container parent = b.getParent();
            if (parent != null && parent instanceof JPopupMenu) {
                int max;
                String prop;
                boolean align;
                SynthPopupMenuUI popupUI = (SynthPopupMenuUI)((JPopupMenu)parent).getUI();
                SynthMenuItemUI miUI = (SynthMenuItemUI)SynthLookAndFeel.getUIOfType(b.getUI(), SynthMenuItemUI.class);
                if (popupUI != null && miUI != null && (align = style.getBoolean(context, prop = miUI.getPropertyPrefix() + ".alignAcceleratorText", true)) && (max = popupUI.getMaxAcceleratorWidth()) > 0) {
                    accOffset = max - SynthMenuItemUI.acceleratorRect.width;
                    if (!SynthLookAndFeel.isLeftToRight(c)) {
                        accOffset = -accOffset;
                    }
                }
            }
            SynthStyle accStyle = accContext.getStyle();
            g.setColor(accStyle.getColor(accContext, ColorType.TEXT_FOREGROUND));
            g.setFont(accStyle.getFont(accContext));
            accStyle.getGraphicsUtils(accContext).paintText(accContext, g, acceleratorText, SynthMenuItemUI.acceleratorRect.x - accOffset, SynthMenuItemUI.acceleratorRect.y, -1);
        }
        if (arrowIcon != null) {
            SynthIcon.paintIcon(arrowIcon, context, g, SynthMenuItemUI.arrowIconRect.x, SynthMenuItemUI.arrowIconRect.y, SynthMenuItemUI.arrowIconRect.width, SynthMenuItemUI.arrowIconRect.height);
        }
    }

    private static String layoutMenuItem(SynthContext context, FontMetrics fm, SynthContext accContext, String text, FontMetrics fmAccel, String acceleratorText, Icon icon, Icon checkIcon, Icon arrowIcon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewRect, Rectangle iconRect, Rectangle textRect, Rectangle acceleratorRect, Rectangle checkIconRect, Rectangle arrowIconRect, int textIconGap, int menuItemGap) {
        int thisTextOffset;
        SynthPopupMenuUI popupUI = null;
        JComponent b = context.getComponent();
        Container parent = b.getParent();
        if (parent instanceof JPopupMenu) {
            popupUI = (SynthPopupMenuUI)SynthLookAndFeel.getUIOfType(((JPopupMenu)parent).getUI(), SynthPopupMenuUI.class);
        }
        context.getStyle().getGraphicsUtils(context).layoutText(context, fm, text, icon, horizontalAlignment, verticalAlignment, horizontalTextPosition, verticalTextPosition, viewRect, iconRect, textRect, textIconGap);
        if (acceleratorText == null || acceleratorText.equals("")) {
            acceleratorRect.height = 0;
            acceleratorRect.width = 0;
            acceleratorText = "";
        } else {
            SynthStyle style = accContext.getStyle();
            acceleratorRect.width = style.getGraphicsUtils(accContext).computeStringWidth(accContext, fmAccel.getFont(), fmAccel, acceleratorText);
            acceleratorRect.height = fmAccel.getHeight();
        }
        if (checkIcon != null) {
            checkIconRect.width = SynthIcon.getIconWidth(checkIcon, context);
            checkIconRect.height = SynthIcon.getIconHeight(checkIcon, context);
        } else {
            checkIconRect.height = 0;
            checkIconRect.width = 0;
        }
        if (arrowIcon != null) {
            arrowIconRect.width = SynthIcon.getIconWidth(arrowIcon, context);
            arrowIconRect.height = SynthIcon.getIconHeight(arrowIcon, context);
        } else {
            arrowIconRect.height = 0;
            arrowIconRect.width = 0;
        }
        Rectangle labelRect = iconRect.union(textRect);
        if (SynthLookAndFeel.isLeftToRight(context.getComponent())) {
            iconRect.x = viewRect.x;
            if (checkIcon != null) {
                checkIconRect.x = viewRect.x;
                iconRect.x += menuItemGap + checkIconRect.width;
                textRect.x += menuItemGap + checkIconRect.width;
            }
            arrowIconRect.x = viewRect.x + viewRect.width - arrowIconRect.width;
            acceleratorRect.x = viewRect.x + viewRect.width - acceleratorRect.width;
            if (popupUI != null) {
                thisTextOffset = popupUI.adjustTextOffset(textRect.x - viewRect.x);
                textRect.x = thisTextOffset + viewRect.x;
                if (icon != null) {
                    int thisIconOffset = popupUI.adjustIconOffset(iconRect.x - viewRect.x);
                    iconRect.x = thisIconOffset + viewRect.x;
                }
            }
        } else {
            acceleratorRect.x = viewRect.x;
            arrowIconRect.x = viewRect.x;
            iconRect.x = viewRect.x + viewRect.width - iconRect.width;
            if (checkIcon != null) {
                checkIconRect.x = viewRect.x + viewRect.width - checkIconRect.width;
                textRect.x -= menuItemGap + checkIconRect.width;
                iconRect.x -= menuItemGap + checkIconRect.width;
            }
            if (popupUI != null) {
                thisTextOffset = viewRect.x + viewRect.width - textRect.x - textRect.width;
                thisTextOffset = popupUI.adjustTextOffset(thisTextOffset);
                textRect.x = viewRect.x + viewRect.width - thisTextOffset - textRect.width;
                if (icon != null) {
                    int thisIconOffset = viewRect.x + viewRect.width - iconRect.x - iconRect.width;
                    thisIconOffset = popupUI.adjustIconOffset(thisIconOffset);
                    iconRect.x = viewRect.x + viewRect.width - thisIconOffset - iconRect.width;
                }
            }
        }
        int midY = labelRect.y + labelRect.height / 2;
        iconRect.y = midY - iconRect.height / 2;
        acceleratorRect.y = midY - acceleratorRect.height / 2;
        arrowIconRect.y = midY - arrowIconRect.height / 2;
        checkIconRect.y = midY - checkIconRect.height / 2;
        return text;
    }

    private static void resetRects() {
        iconRect.setBounds(0, 0, 0, 0);
        textRect.setBounds(0, 0, 0, 0);
        acceleratorRect.setBounds(0, 0, 0, 0);
        checkIconRect.setBounds(0, 0, 0, 0);
        arrowIconRect.setBounds(0, 0, 0, 0);
        viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        r.setBounds(0, 0, 0, 0);
    }

    protected void installDefaults() {
        this.updateStyle(this.menuItem);
    }

    protected void installListeners() {
        super.installListeners();
        this.menuItem.addPropertyChangeListener(this);
    }

    private void updateStyle(JMenuItem mi) {
        SynthContext context = this.getContext((JComponent)mi, 1);
        SynthStyle oldStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(context, this);
        if (oldStyle != this.style) {
            String prefix = this.getPropertyPrefix();
            Object value = this.style.get(context, prefix + ".textIconGap");
            if (value != null) {
                LookAndFeel.installProperty(mi, "iconTextGap", value);
            }
            this.defaultTextIconGap = mi.getIconTextGap();
            if (this.menuItem.getMargin() == null || this.menuItem.getMargin() instanceof UIResource) {
                Insets insets = (Insets)this.style.get(context, prefix + ".margin");
                if (insets == null) {
                    insets = SynthLookAndFeel.EMPTY_UIRESOURCE_INSETS;
                }
                this.menuItem.setMargin(insets);
            }
            this.acceleratorDelimiter = this.style.getString(context, prefix + ".acceleratorDelimiter", "+");
            this.arrowIcon = this.style.getIcon(context, prefix + ".arrowIcon");
            this.checkIcon = this.style.getIcon(context, prefix + ".checkIcon");
            if (oldStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        context.dispose();
        SynthContext accContext = this.getContext(mi, Region.MENU_ITEM_ACCELERATOR, 1);
        this.accStyle = SynthLookAndFeel.updateStyle(accContext, this);
        accContext.dispose();
    }

    protected void uninstallDefaults() {
        SynthContext context = this.getContext((JComponent)this.menuItem, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
        SynthContext accContext = this.getContext(this.menuItem, Region.MENU_ITEM_ACCELERATOR, 1);
        this.accStyle.uninstallDefaults(accContext);
        accContext.dispose();
        this.accStyle = null;
        super.uninstallDefaults();
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.menuItem.removePropertyChangeListener(this);
    }

    public SynthContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(SynthContext.class, c, SynthLookAndFeel.getRegion(c), this.style, state);
    }

    public SynthContext getContext(JComponent c, Region region) {
        return this.getContext(c, region, this.getComponentState(c, region));
    }

    private SynthContext getContext(JComponent c, Region region, int state) {
        return SynthContext.getContext(SynthContext.class, c, region, this.accStyle, state);
    }

    private Region getRegion(JComponent c) {
        return SynthLookAndFeel.getRegion(c);
    }

    private int getComponentState(JComponent c) {
        int state = !c.isEnabled() ? 8 : (this.menuItem.isArmed() ? 2 : SynthLookAndFeel.getComponentState(c));
        if (this.menuItem.isSelected()) {
            state |= 0x200;
        }
        return state;
    }

    private int getComponentState(JComponent c, Region region) {
        return this.getComponentState(c);
    }

    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        SynthContext context = this.getContext(c);
        SynthContext accContext = this.getContext(c, Region.MENU_ITEM_ACCELERATOR);
        Dimension value = SynthMenuItemUI.getPreferredMenuItemSize(context, accContext, c, checkIcon, arrowIcon, defaultTextIconGap, this.acceleratorDelimiter);
        context.dispose();
        accContext.dispose();
        return value;
    }

    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        SynthLookAndFeel.update(context, g);
        this.paintBackground(context, g, c);
        this.paint(context, g);
        context.dispose();
    }

    public void paint(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SynthContext context, Graphics g) {
        SynthContext accContext = this.getContext((JComponent)this.menuItem, Region.MENU_ITEM_ACCELERATOR);
        String prefix = this.getPropertyPrefix();
        Icon checkIcon = this.style.getIcon(context, prefix + ".checkIcon");
        Icon arrowIcon = this.style.getIcon(context, prefix + ".arrowIcon");
        SynthMenuItemUI.paint(context, accContext, g, checkIcon, arrowIcon, this.acceleratorDelimiter, this.defaultTextIconGap);
        accContext.dispose();
    }

    void paintBackground(SynthContext context, Graphics g, JComponent c) {
        context.getPainter().paintMenuItemBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
    }

    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintMenuItemBorder(context, g, x, y, w, h);
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (SynthLookAndFeel.shouldUpdateStyle(e)) {
            this.updateStyle((JMenuItem)e.getSource());
        }
    }
}

