/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthTextFieldUI;
import javax.swing.text.JTextComponent;
import sun.swing.plaf.synth.SynthUI;

class SynthEditorPaneUI
extends BasicEditorPaneUI
implements SynthUI {
    private SynthStyle style;
    private Boolean localTrue = new Boolean(true);
    private Boolean localFalse = new Boolean(false);

    SynthEditorPaneUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        return new SynthEditorPaneUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        JTextComponent c = this.getComponent();
        Object clientProperty = c.getClientProperty("JEditorPane.honorDisplayProperties");
        if (clientProperty == null || clientProperty == this.localFalse) {
            c.putClientProperty("JEditorPane.honorDisplayProperties", this.localTrue);
        }
        this.updateStyle(this.getComponent());
    }

    protected void uninstallDefaults() {
        SynthContext context = this.getContext(this.getComponent(), 1);
        JTextComponent c = this.getComponent();
        c.putClientProperty("caretAspectRatio", null);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
        Object clientProperty = c.getClientProperty("JEditorPane.honorDisplayProperties");
        if (clientProperty == this.localTrue) {
            this.getComponent().putClientProperty("JEditorPane.honorDisplayProperties", Boolean.FALSE);
        }
        super.uninstallDefaults();
    }

    protected void propertyChange(PropertyChangeEvent evt) {
        if (SynthLookAndFeel.shouldUpdateStyle(evt)) {
            this.updateStyle((JTextComponent)evt.getSource());
        }
        super.propertyChange(evt);
    }

    private void updateStyle(JTextComponent comp) {
        SynthContext context = this.getContext(comp, 1);
        SynthStyle oldStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(context, this);
        if (this.style != oldStyle) {
            SynthTextFieldUI.updateStyle(comp, context, this.getPropertyPrefix());
            if (oldStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        context.dispose();
    }

    public SynthContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    private SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(SynthContext.class, c, SynthLookAndFeel.getRegion(c), this.style, state);
    }

    private int getComponentState(JComponent c) {
        return SynthLookAndFeel.getComponentState(c);
    }

    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        SynthLookAndFeel.update(context, g);
        this.paintBackground(context, g, c);
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SynthContext context, Graphics g) {
        super.paint(g, this.getComponent());
    }

    protected void paintBackground(Graphics g) {
    }

    void paintBackground(SynthContext context, Graphics g, JComponent c) {
        context.getPainter().paintEditorPaneBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
    }

    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintEditorPaneBorder(context, g, x, y, w, h);
    }
}

