/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.metal.MetalUtils;
import sun.swing.SwingUtilities2;

public class MetalButtonUI
extends BasicButtonUI {
    private static final MetalButtonUI metalButtonUI = new MetalButtonUI();
    protected Color focusColor;
    protected Color selectColor;
    protected Color disabledTextColor;

    public static ComponentUI createUI(JComponent c) {
        return metalButtonUI;
    }

    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
    }

    public void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return super.createButtonListener(b);
    }

    protected Color getSelectColor() {
        this.selectColor = UIManager.getColor(this.getPropertyPrefix() + "select");
        return this.selectColor;
    }

    protected Color getDisabledTextColor() {
        this.disabledTextColor = UIManager.getColor(this.getPropertyPrefix() + "disabledText");
        return this.disabledTextColor;
    }

    protected Color getFocusColor() {
        this.focusColor = UIManager.getColor(this.getPropertyPrefix() + "focus");
        return this.focusColor;
    }

    public void update(Graphics g, JComponent c) {
        AbstractButton button = (AbstractButton)c;
        if (c.getBackground() instanceof UIResource && button.isContentAreaFilled() && c.isEnabled()) {
            ButtonModel model = button.getModel();
            if (!MetalUtils.isToolBarButton(c)) {
                if (!model.isArmed() && !model.isPressed() && MetalUtils.drawGradient(c, g, "Button.gradient", 0, 0, c.getWidth(), c.getHeight(), true)) {
                    this.paint(g, c);
                    return;
                }
            } else if (model.isRollover() && MetalUtils.drawGradient(c, g, "Button.gradient", 0, 0, c.getWidth(), c.getHeight(), true)) {
                this.paint(g, c);
                return;
            }
        }
        super.update(g, c);
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        if (b.isContentAreaFilled()) {
            Dimension size = b.getSize();
            g.setColor(this.getSelectColor());
            g.fillRect(0, 0, size.width, size.height);
        }
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        boolean isIcon;
        Rectangle focusRect = new Rectangle();
        String text = b.getText();
        boolean bl = isIcon = b.getIcon() != null;
        if (text != null && !text.equals("")) {
            if (!isIcon) {
                focusRect.setBounds(textRect);
            } else {
                focusRect.setBounds(iconRect.union(textRect));
            }
        } else if (isIcon) {
            focusRect.setBounds(iconRect);
        }
        g.setColor(this.getFocusColor());
        g.drawRect(focusRect.x - 1, focusRect.y - 1, focusRect.width + 1, focusRect.height + 1);
    }

    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = SwingUtilities2.getFontMetrics(c, g);
        int mnemIndex = b.getDisplayedMnemonicIndex();
        if (model.isEnabled()) {
            g.setColor(b.getForeground());
        } else {
            g.setColor(this.getDisabledTextColor());
        }
        SwingUtilities2.drawStringUnderlineCharAt(c, g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
    }
}

