/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Manifest
implements Cloneable {
    private Attributes attr = new Attributes();
    private Map entries = new HashMap();

    public Manifest() {
    }

    public Manifest(InputStream is) throws IOException {
        this.read(is);
    }

    public Manifest(Manifest man) {
        this.attr.putAll((Map<?, ?>)man.getMainAttributes());
        this.entries.putAll(man.getEntries());
    }

    public Attributes getMainAttributes() {
        return this.attr;
    }

    public Map<String, Attributes> getEntries() {
        return this.entries;
    }

    public Attributes getAttributes(String name) {
        return this.getEntries().get(name);
    }

    public void clear() {
        this.attr.clear();
        this.entries.clear();
    }

    public void write(OutputStream out) throws IOException {
        DataOutputStream dos = new DataOutputStream(out);
        this.attr.writeMain(dos);
        for (Map.Entry e : this.entries.entrySet()) {
            StringBuffer buffer = new StringBuffer("Name: ");
            String value = (String)e.getKey();
            if (value != null) {
                byte[] vb = value.getBytes("UTF8");
                value = new String(vb, 0, 0, vb.length);
            }
            buffer.append(value);
            buffer.append("\r\n");
            Manifest.make72Safe(buffer);
            dos.writeBytes(buffer.toString());
            ((Attributes)e.getValue()).write(dos);
        }
        dos.flush();
    }

    static void make72Safe(StringBuffer line) {
        int length = line.length();
        if (length > 72) {
            int index = 70;
            while (index < length - 2) {
                line.insert(index, "\r\n ");
                index += 72;
                length += 3;
            }
        }
    }

    public void read(InputStream is) throws IOException {
        int len;
        FastInputStream fis = new FastInputStream(is);
        byte[] lbuf = new byte[512];
        this.attr.read(fis, lbuf);
        int ecount = 0;
        int acount = 0;
        int asize = 2;
        String name = null;
        boolean skipEmptyLines = true;
        byte[] lastline = null;
        while ((len = fis.readLine(lbuf)) != -1) {
            Attributes attr;
            if (lbuf[--len] != 10) {
                throw new IOException("manifest line too long");
            }
            if (len > 0 && lbuf[len - 1] == 13) {
                --len;
            }
            if (len == 0 && skipEmptyLines) continue;
            skipEmptyLines = false;
            if (name == null) {
                name = this.parseName(lbuf, len);
                if (name == null) {
                    throw new IOException("invalid manifest format");
                }
                if (fis.peek() == 32) {
                    lastline = new byte[len - 6];
                    System.arraycopy(lbuf, 6, lastline, 0, len - 6);
                    continue;
                }
            } else {
                byte[] buf = new byte[lastline.length + len - 1];
                System.arraycopy(lastline, 0, buf, 0, lastline.length);
                System.arraycopy(lbuf, 1, buf, lastline.length, len - 1);
                if (fis.peek() == 32) {
                    lastline = buf;
                    continue;
                }
                name = new String(buf, 0, buf.length, "UTF8");
                lastline = null;
            }
            if ((attr = this.getAttributes(name)) == null) {
                attr = new Attributes(asize);
                this.entries.put(name, attr);
            }
            attr.read(fis, lbuf);
            asize = Math.max(2, (acount += attr.size()) / ++ecount);
            name = null;
            skipEmptyLines = true;
        }
    }

    private String parseName(byte[] lbuf, int len) {
        if (this.toLower(lbuf[0]) == 110 && this.toLower(lbuf[1]) == 97 && this.toLower(lbuf[2]) == 109 && this.toLower(lbuf[3]) == 101 && lbuf[4] == 58 && lbuf[5] == 32) {
            try {
                return new String(lbuf, 6, len - 6, "UTF8");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private int toLower(int c) {
        return c >= 65 && c <= 90 ? 97 + (c - 65) : c;
    }

    public boolean equals(Object o) {
        if (o instanceof Manifest) {
            Manifest m = (Manifest)o;
            return this.attr.equals(m.getMainAttributes()) && ((Object)this.entries).equals(m.getEntries());
        }
        return false;
    }

    public int hashCode() {
        return this.attr.hashCode() + ((Object)this.entries).hashCode();
    }

    public Object clone() {
        return new Manifest(this);
    }

    static class FastInputStream
    extends FilterInputStream {
        private byte[] buf;
        private int count = 0;
        private int pos = 0;

        FastInputStream(InputStream in) {
            this(in, 8192);
        }

        FastInputStream(InputStream in, int size) {
            super(in);
            this.buf = new byte[size];
        }

        public int read() throws IOException {
            if (this.pos >= this.count) {
                this.fill();
                if (this.pos >= this.count) {
                    return -1;
                }
            }
            return this.buf[this.pos++] & 0xFF;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int avail = this.count - this.pos;
            if (avail <= 0) {
                if (len >= this.buf.length) {
                    return this.in.read(b, off, len);
                }
                this.fill();
                avail = this.count - this.pos;
                if (avail <= 0) {
                    return -1;
                }
            }
            if (len > avail) {
                len = avail;
            }
            System.arraycopy(this.buf, this.pos, b, off, len);
            this.pos += len;
            return len;
        }

        public int readLine(byte[] b, int off, int len) throws IOException {
            int total;
            int n;
            byte[] tbuf = this.buf;
            for (total = 0; total < len; total += n) {
                int avail = this.count - this.pos;
                if (avail <= 0) {
                    this.fill();
                    avail = this.count - this.pos;
                    if (avail <= 0) {
                        return -1;
                    }
                }
                if ((n = len - total) > avail) {
                    n = avail;
                }
                int tpos = this.pos;
                int maxpos = tpos + n;
                while (tpos < maxpos && tbuf[tpos++] != 10) {
                }
                n = tpos - this.pos;
                System.arraycopy(tbuf, this.pos, b, off, n);
                off += n;
                this.pos = tpos;
                if (tbuf[tpos - 1] != 10) continue;
                break;
            }
            return total;
        }

        public byte peek() throws IOException {
            if (this.pos == this.count) {
                this.fill();
            }
            return this.buf[this.pos];
        }

        public int readLine(byte[] b) throws IOException {
            return this.readLine(b, 0, b.length);
        }

        public long skip(long n) throws IOException {
            if (n <= 0L) {
                return 0L;
            }
            long avail = this.count - this.pos;
            if (avail <= 0L) {
                return this.in.skip(n);
            }
            if (n > avail) {
                n = avail;
            }
            this.pos = (int)((long)this.pos + n);
            return n;
        }

        public int available() throws IOException {
            return this.count - this.pos + this.in.available();
        }

        public void close() throws IOException {
            if (this.in != null) {
                this.in.close();
                this.in = null;
                this.buf = null;
            }
        }

        private void fill() throws IOException {
            this.pos = 0;
            this.count = 0;
            int n = this.in.read(this.buf, 0, this.buf.length);
            if (n > 0) {
                this.count = n;
            }
        }
    }
}

