/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels;

import java.io.IOException;
import java.nio.channels.FileChannel;

public abstract class FileLock {
    private final FileChannel channel;
    private final long position;
    private final long size;
    private final boolean shared;

    protected FileLock(FileChannel channel, long position, long size, boolean shared) {
        if (position < 0L) {
            throw new IllegalArgumentException("Negative position");
        }
        if (size < 0L) {
            throw new IllegalArgumentException("Negative size");
        }
        if (position + size < 0L) {
            throw new IllegalArgumentException("Negative position + size");
        }
        this.channel = channel;
        this.position = position;
        this.size = size;
        this.shared = shared;
    }

    public final FileChannel channel() {
        return this.channel;
    }

    public final long position() {
        return this.position;
    }

    public final long size() {
        return this.size;
    }

    public final boolean isShared() {
        return this.shared;
    }

    public final boolean overlaps(long position, long size) {
        if (position + size <= this.position) {
            return false;
        }
        return this.position + this.size > position;
    }

    public abstract boolean isValid();

    public abstract void release() throws IOException;

    public final String toString() {
        return this.getClass().getName() + "[" + this.position + ":" + this.size + " " + (this.shared ? "shared" : "exclusive") + " " + (this.isValid() ? "valid" : "invalid") + "]";
    }
}

