/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.HeapFloatBufferR;

class HeapFloatBuffer
extends FloatBuffer {
    HeapFloatBuffer(int cap, int lim) {
        super(-1, 0, lim, cap, new float[cap], 0);
    }

    HeapFloatBuffer(float[] buf, int off, int len) {
        super(-1, off, off + len, buf.length, buf, 0);
    }

    protected HeapFloatBuffer(float[] buf, int mark, int pos, int lim, int cap, int off) {
        super(mark, pos, lim, cap, buf, off);
    }

    public FloatBuffer slice() {
        return new HeapFloatBuffer(this.hb, -1, 0, this.remaining(), this.remaining(), this.position() + this.offset);
    }

    public FloatBuffer duplicate() {
        return new HeapFloatBuffer(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    public FloatBuffer asReadOnlyBuffer() {
        return new HeapFloatBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    protected int ix(int i) {
        return i + this.offset;
    }

    public float get() {
        return this.hb[this.ix(this.nextGetIndex())];
    }

    public float get(int i) {
        return this.hb[this.ix(this.checkIndex(i))];
    }

    public FloatBuffer get(float[] dst, int offset, int length) {
        HeapFloatBuffer.checkBounds(offset, length, dst.length);
        if (length > this.remaining()) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.hb, this.ix(this.position()), dst, offset, length);
        this.position(this.position() + length);
        return this;
    }

    public boolean isDirect() {
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    public FloatBuffer put(float x) {
        this.hb[this.ix((int)this.nextPutIndex())] = x;
        return this;
    }

    public FloatBuffer put(int i, float x) {
        this.hb[this.ix((int)this.checkIndex((int)i))] = x;
        return this;
    }

    public FloatBuffer put(float[] src, int offset, int length) {
        HeapFloatBuffer.checkBounds(offset, length, src.length);
        if (length > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy(src, offset, this.hb, this.ix(this.position()), length);
        this.position(this.position() + length);
        return this;
    }

    public FloatBuffer put(FloatBuffer src) {
        if (src instanceof HeapFloatBuffer) {
            if (src == this) {
                throw new IllegalArgumentException();
            }
            HeapFloatBuffer sb = (HeapFloatBuffer)src;
            int n = sb.remaining();
            if (n > this.remaining()) {
                throw new BufferOverflowException();
            }
            System.arraycopy(sb.hb, sb.ix(sb.position()), this.hb, this.ix(this.position()), n);
            sb.position(sb.position() + n);
            this.position(this.position() + n);
        } else if (src.isDirect()) {
            int n = src.remaining();
            if (n > this.remaining()) {
                throw new BufferOverflowException();
            }
            src.get(this.hb, this.ix(this.position()), n);
            this.position(this.position() + n);
        } else {
            super.put(src);
        }
        return this;
    }

    public FloatBuffer compact() {
        System.arraycopy(this.hb, this.ix(this.position()), this.hb, this.ix(0), this.remaining());
        this.position(this.remaining());
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

