/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.Encoder;
import java.beans.Expression;
import java.beans.Introspector;
import java.beans.NameGenerator;
import java.beans.ReflectionUtils;
import java.beans.Statement;
import java.beans.XMLDecoder;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Vector;

public class XMLEncoder
extends Encoder {
    private static String encoding = "UTF-8";
    private OutputStream out;
    private Object owner;
    private int indentation = 0;
    private boolean internal = false;
    private Map valueToExpression;
    private Map targetToStatementList;
    private boolean preambleWritten = false;
    private NameGenerator nameGenerator;

    public XMLEncoder(OutputStream out) {
        this.out = out;
        this.valueToExpression = new IdentityHashMap();
        this.targetToStatementList = new IdentityHashMap();
        this.nameGenerator = new NameGenerator();
    }

    public void setOwner(Object owner) {
        this.owner = owner;
        this.writeExpression(new Expression(this, "getOwner", new Object[0]));
    }

    public Object getOwner() {
        return this.owner;
    }

    public void writeObject(Object o) {
        if (this.internal) {
            super.writeObject(o);
        } else {
            this.writeStatement(new Statement(this, "writeObject", new Object[]{o}));
        }
    }

    private Vector statementList(Object target) {
        Vector list = (Vector)this.targetToStatementList.get(target);
        if (list != null) {
            return list;
        }
        list = new Vector();
        this.targetToStatementList.put(target, list);
        return list;
    }

    private void mark(Object o, boolean isArgument) {
        if (o == null || o == this) {
            return;
        }
        ValueData d = this.getValueData(o);
        Expression exp = d.exp;
        if (o.getClass() == String.class && exp == null) {
            return;
        }
        if (isArgument) {
            ++d.refs;
        }
        if (d.marked) {
            return;
        }
        d.marked = true;
        Object target = exp.getTarget();
        if (!(target instanceof Class)) {
            this.statementList(target).add(exp);
            ++d.refs;
        }
        this.mark(exp);
    }

    private void mark(Statement stm) {
        Object[] args = stm.getArguments();
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            this.mark(arg, true);
        }
        this.mark(stm.getTarget(), false);
    }

    public void writeStatement(Statement oldStm) {
        boolean internal = this.internal;
        this.internal = true;
        try {
            super.writeStatement(oldStm);
            this.mark(oldStm);
            this.statementList(oldStm.getTarget()).add(oldStm);
        }
        catch (Exception e) {
            this.getExceptionListener().exceptionThrown(new Exception("XMLEncoder: discarding statement " + oldStm, e));
        }
        this.internal = internal;
    }

    public void writeExpression(Expression oldExp) {
        boolean internal = this.internal;
        this.internal = true;
        Object oldValue = this.getValue(oldExp);
        if (this.get(oldValue) == null || oldValue instanceof String && !internal) {
            this.getValueData((Object)oldValue).exp = oldExp;
            super.writeExpression(oldExp);
        }
        this.internal = internal;
    }

    public void flush() {
        if (!this.preambleWritten) {
            this.writeln("<?xml version=" + this.quote("1.0") + " encoding=" + this.quote(encoding) + "?>");
            this.writeln("<java version=" + this.quote(System.getProperty("java.version")) + " class=" + this.quote(XMLDecoder.class.getName()) + ">");
            this.preambleWritten = true;
        }
        ++this.indentation;
        Vector roots = this.statementList(this);
        for (int i = 0; i < roots.size(); ++i) {
            Statement s = (Statement)roots.get(i);
            if ("writeObject".equals(s.getMethodName())) {
                this.outputValue(s.getArguments()[0], this, true);
                continue;
            }
            this.outputStatement(s, this, false);
        }
        --this.indentation;
        try {
            this.out.flush();
        }
        catch (IOException e) {
            this.getExceptionListener().exceptionThrown(e);
        }
        this.clear();
    }

    void clear() {
        super.clear();
        this.nameGenerator.clear();
        this.valueToExpression.clear();
        this.targetToStatementList.clear();
    }

    public void close() {
        this.flush();
        this.writeln("</java>");
        try {
            this.out.close();
        }
        catch (IOException e) {
            this.getExceptionListener().exceptionThrown(e);
        }
    }

    private String quote(String s) {
        return "\"" + s + "\"";
    }

    private ValueData getValueData(Object o) {
        ValueData d = (ValueData)this.valueToExpression.get(o);
        if (d == null) {
            d = new ValueData();
            this.valueToExpression.put(o, d);
        }
        return d;
    }

    private static boolean isValidCharCode(int code) {
        return 32 <= code && code <= 55295 || 10 == code || 9 == code || 13 == code || 57344 <= code && code <= 65533 || 65536 <= code && code <= 0x10FFFF;
    }

    private void writeln(String exp) {
        try {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.indentation; ++i) {
                sb.append(' ');
            }
            sb.append(exp);
            sb.append('\n');
            this.out.write(sb.toString().getBytes(encoding));
        }
        catch (IOException e) {
            this.getExceptionListener().exceptionThrown(e);
        }
    }

    private void outputValue(Object value, Object outer, boolean isArgument) {
        if (value == null) {
            this.writeln("<null/>");
            return;
        }
        if (value instanceof Class) {
            this.writeln("<class>" + ((Class)value).getName() + "</class>");
            return;
        }
        ValueData d = this.getValueData(value);
        if (d.exp != null) {
            Object target = d.exp.getTarget();
            String methodName = d.exp.getMethodName();
            if (target == null || methodName == null) {
                throw new NullPointerException((target == null ? "target" : "methodName") + " should not be null");
            }
            if (target instanceof Field && methodName.equals("get")) {
                Field f = (Field)target;
                this.writeln("<object class=" + this.quote(f.getDeclaringClass().getName()) + " field=" + this.quote(f.getName()) + "/>");
                return;
            }
            Class primitiveType = ReflectionUtils.primitiveTypeFor(value.getClass());
            if (primitiveType != null && target == value.getClass() && methodName.equals("new")) {
                String primitiveTypeName = primitiveType.getName();
                if (primitiveType == Character.TYPE) {
                    char code = ((Character)value).charValue();
                    if (!XMLEncoder.isValidCharCode(code)) {
                        this.writeln(XMLEncoder.createString(code));
                        return;
                    }
                    value = XMLEncoder.quoteCharCode(code);
                    if (value == null) {
                        value = Character.valueOf(code);
                    }
                }
                this.writeln("<" + primitiveTypeName + ">" + value + "</" + primitiveTypeName + ">");
                return;
            }
        } else if (value instanceof String) {
            this.writeln(this.createString((String)value));
            return;
        }
        if (d.name != null) {
            this.writeln("<object idref=" + this.quote(d.name) + "/>");
            return;
        }
        this.outputStatement(d.exp, outer, isArgument);
    }

    private static String quoteCharCode(int code) {
        switch (code) {
            case 38: {
                return "&amp;";
            }
            case 60: {
                return "&lt;";
            }
            case 62: {
                return "&gt;";
            }
            case 34: {
                return "&quot;";
            }
            case 39: {
                return "&apos;";
            }
            case 13: {
                return "&#13;";
            }
        }
        return null;
    }

    private static String createString(int code) {
        return "<char code=\"#" + Integer.toString(code, 16) + "\"/>";
    }

    private String createString(String string) {
        CharsetEncoder encoder = Charset.forName(encoding).newEncoder();
        StringBuilder sb = new StringBuilder();
        sb.append("<string>");
        int index = 0;
        while (index < string.length()) {
            int point = string.codePointAt(index);
            int count = Character.charCount(point);
            if (XMLEncoder.isValidCharCode(point) && encoder.canEncode(string.substring(index, index + count))) {
                String value = XMLEncoder.quoteCharCode(point);
                if (value != null) {
                    sb.append(value);
                } else {
                    sb.appendCodePoint(point);
                }
                index += count;
                continue;
            }
            sb.append(XMLEncoder.createString(string.charAt(index)));
            ++index;
        }
        sb.append("</string>");
        return sb.toString();
    }

    private void outputStatement(Statement exp, Object outer, boolean isArgument) {
        int i;
        Object target = exp.getTarget();
        String methodName = exp.getMethodName();
        if (target == null || methodName == null) {
            throw new NullPointerException((target == null ? "target" : "methodName") + " should not be null");
        }
        Object[] args = exp.getArguments();
        boolean expression = exp.getClass() == Expression.class;
        Object value = expression ? this.getValue((Expression)exp) : null;
        String tag = expression && isArgument ? "object" : "void";
        String attributes = "";
        ValueData d = this.getValueData(value);
        if (expression && d.refs > 1) {
            String instanceName;
            d.name = instanceName = this.nameGenerator.instanceName(value);
            attributes = attributes + " id=" + this.quote(instanceName);
        }
        if (target != outer) {
            if (target == Array.class && methodName.equals("newInstance")) {
                tag = "array";
                attributes = attributes + " class=" + this.quote(((Class)args[0]).getName());
                attributes = attributes + " length=" + this.quote(args[1].toString());
                args = new Object[]{};
            } else if (target.getClass() == Class.class) {
                attributes = attributes + " class=" + this.quote(((Class)target).getName());
            } else {
                d.refs = 2;
                ++this.getValueData((Object)target).refs;
                this.outputValue(target, outer, false);
                if (isArgument) {
                    this.outputValue(value, outer, false);
                }
                return;
            }
        }
        if (!expression && methodName.equals("set") && args.length == 2 && args[0] instanceof Integer || expression && methodName.equals("get") && args.length == 1 && args[0] instanceof Integer) {
            Object[] objectArray;
            attributes = attributes + " index=" + this.quote(args[0].toString());
            if (args.length == 1) {
                objectArray = new Object[]{};
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = args[1];
            }
            args = objectArray;
        } else if (!expression && methodName.startsWith("set") && args.length == 1 || expression && methodName.startsWith("get") && args.length == 0) {
            attributes = attributes + " property=" + this.quote(Introspector.decapitalize(methodName.substring(3)));
        } else if (!methodName.equals("new") && !methodName.equals("newInstance")) {
            attributes = attributes + " method=" + this.quote(methodName);
        }
        Vector statements = this.statementList(value);
        if (args.length == 0 && statements.size() == 0) {
            this.writeln("<" + tag + attributes + "/>");
            return;
        }
        this.writeln("<" + tag + attributes + ">");
        ++this.indentation;
        for (i = 0; i < args.length; ++i) {
            this.outputValue(args[i], null, true);
        }
        for (i = 0; i < statements.size(); ++i) {
            Statement s = (Statement)statements.get(i);
            this.outputStatement(s, value, false);
        }
        --this.indentation;
        this.writeln("</" + tag + ">");
    }

    private class ValueData {
        public int refs = 0;
        public boolean marked = false;
        public String name = null;
        public Expression exp = null;

        private ValueData() {
        }
    }
}

