/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp;

import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpValue;

public class SnmpCounter64
extends SnmpValue {
    private static final long serialVersionUID = 8784850650494679937L;
    static final String name = "Counter64";
    private long value = 0L;

    public SnmpCounter64(long v) throws IllegalArgumentException {
        if (v < 0L || v > Long.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.value = v;
    }

    public SnmpCounter64(Long v) throws IllegalArgumentException {
        this((long)v);
    }

    public long longValue() {
        return this.value;
    }

    public Long toLong() {
        return new Long(this.value);
    }

    public int intValue() {
        return (int)this.value;
    }

    public Integer toInteger() {
        return new Integer((int)this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public SnmpOid toOid() {
        return new SnmpOid(this.value);
    }

    public static SnmpOid toOid(long[] index, int start) throws SnmpStatusException {
        try {
            return new SnmpOid(index[start]);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SnmpStatusException(2);
        }
    }

    public static int nextOid(long[] index, int start) throws SnmpStatusException {
        if (start >= index.length) {
            throw new SnmpStatusException(2);
        }
        return start + 1;
    }

    public static void appendToOid(SnmpOid source, SnmpOid dest) {
        if (source.getLength() != 1) {
            throw new IllegalArgumentException();
        }
        dest.append(source);
    }

    public final synchronized SnmpValue duplicate() {
        return (SnmpValue)this.clone();
    }

    public final synchronized Object clone() {
        SnmpCounter64 newclone = null;
        try {
            newclone = (SnmpCounter64)super.clone();
            newclone.value = this.value;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        return newclone;
    }

    public final String getTypeName() {
        return name;
    }
}

