/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import sun.nio.cs.ext.CompoundTextSupport;

public class COMPOUND_TEXT_Encoder
extends CharsetEncoder {
    private static final Map encodingToEncoderMap = Collections.synchronizedMap(new HashMap(21, 1.0f));
    private static final CharsetEncoder latin1Encoder;
    private static final CharsetEncoder defaultEncoder;
    private static final boolean defaultEncodingSupported;
    private CharsetEncoder encoder;
    private char[] charBuf = new char[1];
    private CharBuffer charbuf = CharBuffer.wrap(this.charBuf);
    private ByteArrayOutputStream nonStandardCharsetBuffer;
    private byte[] byteBuf;
    private ByteBuffer bytebuf;
    private int numNonStandardChars;
    private int nonStandardEncodingLen;
    private CharBuffer fcb = CharBuffer.allocate(0);

    public COMPOUND_TEXT_Encoder(Charset cs) {
        super(cs, CompoundTextSupport.MAX_CONTROL_SEQUENCE_LEN + 2, CompoundTextSupport.MAX_CONTROL_SEQUENCE_LEN + 2);
        try {
            this.encoder = Charset.forName("ISO8859_1").newEncoder();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.initEncoder(this.encoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CoderResult encodeLoop(CharBuffer src, ByteBuffer des) {
        CoderResult cr = CoderResult.UNDERFLOW;
        char[] input = src.array();
        int inOff = src.arrayOffset() + src.position();
        int inEnd = src.arrayOffset() + src.limit();
        try {
            while (inOff < inEnd && cr.isUnderflow()) {
                CoderResult coderResult;
                CharsetEncoder enc;
                this.charBuf[0] = input[inOff];
                if (this.charBuf[0] <= '\b' || this.charBuf[0] >= '\u000b' && this.charBuf[0] <= '\u001f' || this.charBuf[0] >= '\u0080' && this.charBuf[0] <= '\u009f') {
                    this.charBuf[0] = 63;
                }
                if ((enc = this.getEncoder(this.charBuf[0])) == null) {
                    if (this.unmappableCharacterAction() == CodingErrorAction.REPORT) {
                        this.charBuf[0] = 63;
                        enc = latin1Encoder;
                    } else {
                        coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                }
                if (enc != this.encoder) {
                    if (this.nonStandardCharsetBuffer != null) {
                        cr = this.flushNonStandardCharsetBuffer(des);
                    } else {
                        this.flushEncoder(this.encoder, des);
                    }
                    if (!cr.isUnderflow()) {
                        coderResult = cr;
                        return coderResult;
                    }
                    byte[] escSequence = CompoundTextSupport.getEscapeSequence(enc.charset().name());
                    if (escSequence == null) {
                        throw new InternalError("Unknown encoding: " + enc.charset().name());
                    }
                    if (escSequence[1] == 37 && escSequence[2] == 47) {
                        this.initNonStandardCharsetBuffer(enc, escSequence);
                    } else if (des.remaining() >= escSequence.length) {
                        des.put(escSequence, 0, escSequence.length);
                    } else {
                        CoderResult coderResult2 = CoderResult.OVERFLOW;
                        return coderResult2;
                    }
                    this.encoder = enc;
                    continue;
                }
                this.charbuf.rewind();
                if (this.nonStandardCharsetBuffer == null) {
                    cr = this.encoder.encode(this.charbuf, des, false);
                } else {
                    this.bytebuf.clear();
                    cr = this.encoder.encode(this.charbuf, this.bytebuf, false);
                    this.bytebuf.flip();
                    this.nonStandardCharsetBuffer.write(this.byteBuf, 0, this.bytebuf.limit());
                    ++this.numNonStandardChars;
                }
                ++inOff;
            }
            CoderResult coderResult = cr;
            return coderResult;
        }
        finally {
            src.position(inOff - src.arrayOffset());
        }
    }

    protected CoderResult implFlush(ByteBuffer out) {
        CoderResult cr = this.nonStandardCharsetBuffer != null ? this.flushNonStandardCharsetBuffer(out) : this.flushEncoder(this.encoder, out);
        this.reset();
        return cr;
    }

    private void initNonStandardCharsetBuffer(CharsetEncoder c, byte[] escSequence) {
        this.nonStandardCharsetBuffer = new ByteArrayOutputStream();
        this.byteBuf = new byte[(int)c.maxBytesPerChar()];
        this.bytebuf = ByteBuffer.wrap(this.byteBuf);
        this.nonStandardCharsetBuffer.write(escSequence, 0, escSequence.length);
        this.nonStandardCharsetBuffer.write(0);
        this.nonStandardCharsetBuffer.write(0);
        byte[] encoding = CompoundTextSupport.getEncoding(c.charset().name());
        if (encoding == null) {
            throw new InternalError("Unknown encoding: " + this.encoder.charset().name());
        }
        this.nonStandardCharsetBuffer.write(encoding, 0, encoding.length);
        this.nonStandardCharsetBuffer.write(2);
        this.nonStandardEncodingLen = encoding.length + 1;
    }

    private CoderResult flushNonStandardCharsetBuffer(ByteBuffer out) {
        int toWrite;
        if (this.numNonStandardChars > 0) {
            byte[] flushBuf = new byte[(int)this.encoder.maxBytesPerChar() * this.numNonStandardChars];
            ByteBuffer bb = ByteBuffer.wrap(flushBuf);
            this.flushEncoder(this.encoder, bb);
            bb.flip();
            this.nonStandardCharsetBuffer.write(flushBuf, 0, bb.limit());
            this.numNonStandardChars = 0;
        }
        int numBytes = this.nonStandardCharsetBuffer.size();
        int nonStandardBytesOff = 6 + this.nonStandardEncodingLen;
        if (out.remaining() < numBytes - nonStandardBytesOff + nonStandardBytesOff * ((numBytes - nonStandardBytesOff) / 16383 + 1)) {
            return CoderResult.OVERFLOW;
        }
        byte[] nonStandardBytes = this.nonStandardCharsetBuffer.toByteArray();
        do {
            out.put((byte)27);
            out.put((byte)37);
            out.put((byte)47);
            out.put(nonStandardBytes[3]);
            toWrite = Math.min(numBytes - nonStandardBytesOff, 16383 - this.nonStandardEncodingLen);
            out.put((byte)((toWrite + this.nonStandardEncodingLen) / 128 | 0x80));
            out.put((byte)((toWrite + this.nonStandardEncodingLen) % 128 | 0x80));
            out.put(nonStandardBytes, 6, this.nonStandardEncodingLen);
            out.put(nonStandardBytes, nonStandardBytesOff, toWrite);
        } while ((nonStandardBytesOff += toWrite) < numBytes);
        this.nonStandardCharsetBuffer = null;
        this.byteBuf = null;
        this.nonStandardEncodingLen = 0;
        return CoderResult.UNDERFLOW;
    }

    protected void implReset() {
        this.nonStandardEncodingLen = 0;
        this.numNonStandardChars = 0;
        this.nonStandardCharsetBuffer = null;
        this.byteBuf = null;
        try {
            this.encoder = Charset.forName("ISO8859_1").newEncoder();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.initEncoder(this.encoder);
    }

    public boolean canEncode(char ch) {
        return this.getEncoder(ch) != null;
    }

    protected void implOnMalformedInput(CodingErrorAction newAction) {
        this.encoder.onUnmappableCharacter(newAction);
    }

    protected void implOnUnmappableCharacter(CodingErrorAction newAction) {
        this.encoder.onUnmappableCharacter(newAction);
    }

    protected void implReplaceWith(byte[] newReplacement) {
        if (this.encoder != null) {
            this.encoder.replaceWith(newReplacement);
        }
    }

    private CharsetEncoder getEncoder(char ch) {
        if (this.encoder.canEncode(ch)) {
            return this.encoder;
        }
        if (defaultEncodingSupported && defaultEncoder.canEncode(ch)) {
            CharsetEncoder retval = null;
            try {
                retval = defaultEncoder.charset().newEncoder();
            }
            catch (UnsupportedOperationException cannotHappen) {
                // empty catch block
            }
            this.initEncoder(retval);
            return retval;
        }
        if (latin1Encoder.canEncode(ch)) {
            CharsetEncoder retval = null;
            try {
                retval = latin1Encoder.charset().newEncoder();
            }
            catch (UnsupportedOperationException cannotHappen) {
                // empty catch block
            }
            this.initEncoder(retval);
            return retval;
        }
        for (String encoding : CompoundTextSupport.getEncodings()) {
            CharsetEncoder enc = (CharsetEncoder)encodingToEncoderMap.get(encoding);
            if (enc == null) {
                enc = CompoundTextSupport.getEncoder(encoding);
                if (enc == null) {
                    throw new InternalError("Unsupported encoding: " + encoding);
                }
                encodingToEncoderMap.put(encoding, enc);
            }
            if (!enc.canEncode(ch)) continue;
            CharsetEncoder retval = CompoundTextSupport.getEncoder(encoding);
            this.initEncoder(retval);
            return retval;
        }
        return null;
    }

    private void initEncoder(CharsetEncoder enc) {
        try {
            enc.onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith(this.replacement());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private CoderResult flushEncoder(CharsetEncoder enc, ByteBuffer bb) {
        enc.encode(this.fcb, bb, true);
        return enc.flush(bb);
    }

    static {
        CharsetEncoder encoder = Charset.defaultCharset().newEncoder();
        String encoding = encoder.charset().name();
        if ("ISO8859_1".equals(encoding)) {
            latin1Encoder = encoder;
            defaultEncoder = encoder;
            defaultEncodingSupported = true;
        } else {
            try {
                latin1Encoder = Charset.forName("ISO8859_1").newEncoder();
            }
            catch (IllegalArgumentException e) {
                throw new ExceptionInInitializerError("ISO8859_1 unsupported");
            }
            defaultEncoder = encoder;
            defaultEncodingSupported = CompoundTextSupport.getEncodings().contains(defaultEncoder.charset().name());
        }
    }
}

