/*
 * Decompiled with CFR 0.152.
 */
package org.classpath.icedtea.pulseaudio;

import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.Port;
import org.classpath.icedtea.pulseaudio.EventLoop;
import org.classpath.icedtea.pulseaudio.Operation;
import org.classpath.icedtea.pulseaudio.PulseAudioLine;
import org.classpath.icedtea.pulseaudio.PulseAudioPlaybackLine;
import org.classpath.icedtea.pulseaudio.PulseAudioVolumeControl;
import org.classpath.icedtea.pulseaudio.SecurityWrapper;

abstract class PulseAudioPort
extends PulseAudioLine
implements Port,
PulseAudioPlaybackLine {
    private String name;
    private byte[] contextPointer;
    private int channels;
    private EventLoop eventLoop;
    private float cachedVolume;
    private PulseAudioVolumeControl volumeControl;

    PulseAudioPort(String portName) {
        this.name = portName;
        this.eventLoop = EventLoop.getEventLoop();
        this.contextPointer = this.eventLoop.getContextPointer();
        this.updateVolumeInfo();
        this.volumeControl = new PulseAudioVolumeControl(this, this.eventLoop);
        this.controls.add(this.volumeControl);
        this.open();
    }

    @Override
    public abstract byte[] native_set_volume(float var1);

    @Override
    public abstract byte[] native_update_volume();

    @Override
    public float getCachedVolume() {
        return this.cachedVolume;
    }

    @Override
    public void setCachedVolume(float value) {
        this.cachedVolume = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVolumeInfo() {
        Operation op;
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            op = new Operation(this.native_update_volume());
        }
        op.waitForCompletion();
        op.releaseReference();
    }

    void update_channels_and_volume(int channels, float volume) {
        this.channels = channels;
        this.cachedVolume = volume;
    }

    @Override
    public void close() {
        this.native_set_volume(0.0f);
        this.isOpen = false;
        this.fireLineEvent(new LineEvent(this, LineEvent.Type.CLOSE, -1L));
    }

    @Override
    public abstract Line.Info getLineInfo();

    @Override
    public void open() {
        if (this.isOpen) {
            return;
        }
        this.native_set_volume(this.cachedVolume);
        this.isOpen = true;
        this.fireLineEvent(new LineEvent(this, LineEvent.Type.OPEN, -1L));
    }

    public String getName() {
        return this.name;
    }

    static {
        SecurityWrapper.loadNativeLibrary();
    }
}

