/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jar;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import sun.misc.JarIndex;
import sun.tools.jar.CRC32OutputStream;
import sun.tools.jar.CommandLine;
import sun.tools.jar.JarException;

public class Main {
    String program;
    PrintStream out;
    PrintStream err;
    String fname;
    String mname;
    String ename;
    String zname = "";
    String[] files;
    String rootjar = null;
    Hashtable filesTable = new Hashtable();
    Vector paths = new Vector();
    Vector v;
    CRC32 crc32 = new CRC32();
    boolean cflag;
    boolean uflag;
    boolean xflag;
    boolean tflag;
    boolean vflag;
    boolean flag0;
    boolean Mflag;
    boolean iflag;
    static final String MANIFEST = "META-INF/MANIFEST.MF";
    static final String MANIFEST_DIR = "META-INF/";
    static final String VERSION = "1.0";
    static final char SEPARATOR = File.separatorChar;
    static final String INDEX = "META-INF/INDEX.LIST";
    private static ResourceBundle rsrc;
    private static final boolean useExtractionTime;
    private boolean ok;
    private Hashtable jarTable = new Hashtable();

    private String getMsg(String key) {
        try {
            return rsrc.getString(key);
        }
        catch (MissingResourceException e) {
            throw new Error("Error in message file");
        }
    }

    private String formatMsg(String key, String arg) {
        String msg = this.getMsg(key);
        String[] args = new String[]{arg};
        return MessageFormat.format(msg, args);
    }

    private String formatMsg2(String key, String arg, String arg1) {
        String msg = this.getMsg(key);
        String[] args = new String[]{arg, arg1};
        return MessageFormat.format(msg, args);
    }

    public Main(PrintStream out, PrintStream err, String program) {
        this.out = out;
        this.err = err;
        this.program = program;
    }

    public synchronized boolean run(String[] args) {
        this.ok = true;
        if (!this.parseArgs(args)) {
            return false;
        }
        try {
            if ((this.cflag || this.uflag) && this.fname != null) {
                this.zname = this.fname.replace(File.separatorChar, '/');
                if (this.zname.startsWith("./")) {
                    this.zname = this.zname.substring(2);
                }
            }
            if (this.cflag) {
                FileOutputStream out;
                Manifest manifest = null;
                FileInputStream in = null;
                if (!this.Mflag) {
                    if (this.mname != null) {
                        in = new FileInputStream(this.mname);
                        manifest = new Manifest(new BufferedInputStream(in));
                    } else {
                        manifest = new Manifest();
                    }
                    this.addVersion(manifest);
                    this.addCreatedBy(manifest);
                    if (this.isAmbigousMainClass(manifest)) {
                        if (in != null) {
                            ((InputStream)in).close();
                        }
                        return false;
                    }
                    if (this.ename != null) {
                        this.addMainClass(manifest, this.ename);
                    }
                }
                if (this.fname != null) {
                    out = new FileOutputStream(this.fname);
                } else {
                    out = new FileOutputStream(FileDescriptor.out);
                    if (this.vflag) {
                        this.vflag = false;
                    }
                }
                this.create(new BufferedOutputStream(out), this.expand(this.files), manifest);
                if (in != null) {
                    ((InputStream)in).close();
                }
                ((OutputStream)out).close();
            } else if (this.uflag) {
                FileOutputStream out;
                FileInputStream in;
                File inputFile = null;
                File tmpFile = null;
                if (this.fname != null) {
                    inputFile = new File(this.fname);
                    String path = inputFile.getParent();
                    tmpFile = File.createTempFile("tmp", null, new File(path == null ? "." : path));
                    in = new FileInputStream(inputFile);
                    out = new FileOutputStream(tmpFile);
                } else {
                    in = new FileInputStream(FileDescriptor.in);
                    out = new FileOutputStream(FileDescriptor.out);
                    this.vflag = false;
                }
                FileInputStream manifest = !this.Mflag && this.mname != null ? new FileInputStream(this.mname) : null;
                this.expand(this.files);
                boolean updateOk = this.update(in, new BufferedOutputStream(out), manifest);
                if (this.ok) {
                    this.ok = updateOk;
                }
                in.close();
                out.close();
                if (manifest != null) {
                    ((InputStream)manifest).close();
                }
                if (this.fname != null) {
                    inputFile.delete();
                    if (!tmpFile.renameTo(inputFile)) {
                        tmpFile.delete();
                        throw new IOException(this.getMsg("error.write.file"));
                    }
                    tmpFile.delete();
                }
            } else if (this.xflag || this.tflag) {
                FileInputStream in = this.fname != null ? new FileInputStream(this.fname) : new FileInputStream(FileDescriptor.in);
                if (this.xflag) {
                    this.extract(new BufferedInputStream(in), this.files);
                } else {
                    this.list(new BufferedInputStream(in), this.files);
                }
                ((InputStream)in).close();
            } else if (this.iflag) {
                this.genIndex(this.rootjar, this.files);
            }
        }
        catch (IOException e) {
            this.fatalError(e);
            this.ok = false;
        }
        catch (Error ee) {
            ee.printStackTrace();
            this.ok = false;
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.ok = false;
        }
        this.out.flush();
        this.err.flush();
        return this.ok;
    }

    boolean parseArgs(String[] args) {
        try {
            args = CommandLine.parse(args);
        }
        catch (FileNotFoundException e) {
            this.fatalError(this.formatMsg("error.cant.open", e.getMessage()));
            return false;
        }
        catch (IOException e) {
            this.fatalError(e);
            return false;
        }
        int count = 1;
        try {
            String flags = args[0];
            if (flags.startsWith("-")) {
                flags = flags.substring(1);
            }
            block20: for (int i = 0; i < flags.length(); ++i) {
                switch (flags.charAt(i)) {
                    case 'c': {
                        if (this.xflag || this.tflag || this.uflag) {
                            this.usageError();
                            return false;
                        }
                        this.cflag = true;
                        continue block20;
                    }
                    case 'u': {
                        if (this.cflag || this.xflag || this.tflag) {
                            this.usageError();
                            return false;
                        }
                        this.uflag = true;
                        continue block20;
                    }
                    case 'x': {
                        if (this.cflag || this.uflag || this.tflag) {
                            this.usageError();
                            return false;
                        }
                        this.xflag = true;
                        continue block20;
                    }
                    case 't': {
                        if (this.cflag || this.uflag || this.xflag) {
                            this.usageError();
                            return false;
                        }
                        this.tflag = true;
                        continue block20;
                    }
                    case 'M': {
                        this.Mflag = true;
                        continue block20;
                    }
                    case 'v': {
                        this.vflag = true;
                        continue block20;
                    }
                    case 'f': {
                        this.fname = args[count++];
                        continue block20;
                    }
                    case 'm': {
                        this.mname = args[count++];
                        continue block20;
                    }
                    case '0': {
                        this.flag0 = true;
                        continue block20;
                    }
                    case 'i': {
                        this.rootjar = args[count++];
                        this.iflag = true;
                        continue block20;
                    }
                    case 'e': {
                        this.ename = args[count++];
                        continue block20;
                    }
                    default: {
                        this.error(this.formatMsg("error.illegal.option", String.valueOf(flags.charAt(i))));
                        this.usageError();
                        return false;
                    }
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.usageError();
            return false;
        }
        if (!(this.cflag || this.tflag || this.xflag || this.uflag || this.iflag)) {
            this.error(this.getMsg("error.bad.option"));
            this.usageError();
            return false;
        }
        int n = args.length - count;
        if (n > 0) {
            int k = 0;
            String[] nameBuf = new String[n];
            try {
                for (int i = count; i < args.length; ++i) {
                    if (args[i].equals("-C")) {
                        String dir;
                        dir = (dir = args[++i]).endsWith(File.separator) ? dir : dir + File.separator;
                        dir = dir.replace(File.separatorChar, '/');
                        while (dir.indexOf("//") > -1) {
                            dir = dir.replace("//", "/");
                        }
                        this.paths.addElement(dir.replace(File.separatorChar, '/'));
                        nameBuf[k++] = dir + args[++i];
                        continue;
                    }
                    nameBuf[k++] = args[i];
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.usageError();
                return false;
            }
            this.files = new String[k];
            System.arraycopy(nameBuf, 0, this.files, 0, k);
        } else {
            if (this.cflag && this.mname == null) {
                this.error(this.getMsg("error.bad.cflag"));
                this.usageError();
                return false;
            }
            if (this.uflag) {
                if (this.mname != null || this.ename != null) {
                    return true;
                }
                this.error(this.getMsg("error.bad.uflag"));
                this.usageError();
                return false;
            }
        }
        return true;
    }

    String[] expand(String[] files) {
        this.v = new Vector();
        this.expand(null, files, this.v, this.filesTable);
        files = new String[this.v.size()];
        for (int i = 0; i < files.length; ++i) {
            files[i] = ((File)this.v.elementAt(i)).getPath();
        }
        return files;
    }

    void expand(File dir, String[] files, Vector v, Hashtable t) {
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File f = dir == null ? new File(files[i]) : new File(dir, files[i]);
            if (f.isFile()) {
                if (t.contains(f)) continue;
                t.put(this.entryName(f.getPath()), f);
                v.addElement(f);
                continue;
            }
            if (f.isDirectory()) {
                String dirPath = f.getPath();
                dirPath = dirPath.endsWith(File.separator) ? dirPath : dirPath + File.separator;
                t.put(this.entryName(dirPath), f);
                v.addElement(f);
                this.expand(f, f.list(), v, t);
                continue;
            }
            this.error(this.formatMsg("error.nosuch.fileordir", String.valueOf(f)));
            this.ok = false;
        }
    }

    void create(OutputStream out, String[] files, Manifest manifest) throws IOException {
        JarOutputStream zos = new JarOutputStream(out);
        if (this.flag0) {
            zos.setMethod(0);
        }
        if (manifest != null) {
            if (this.vflag) {
                this.output(this.getMsg("out.added.manifest"));
            }
            ZipEntry e = new ZipEntry(MANIFEST_DIR);
            e.setTime(System.currentTimeMillis());
            e.setSize(0L);
            e.setCrc(0L);
            ((ZipOutputStream)zos).putNextEntry(e);
            e = new ZipEntry(MANIFEST);
            e.setTime(System.currentTimeMillis());
            if (this.flag0) {
                this.crc32Manifest(e, manifest);
            }
            ((ZipOutputStream)zos).putNextEntry(e);
            manifest.write(zos);
            zos.closeEntry();
        }
        for (int i = 0; i < files.length; ++i) {
            this.addFile(zos, new File(files[i]));
        }
        zos.close();
    }

    boolean update(InputStream in, OutputStream out, InputStream newManifest) throws IOException {
        Hashtable t = this.filesTable;
        Vector v = this.v;
        ZipInputStream zis = new ZipInputStream(in);
        JarOutputStream zos = new JarOutputStream(out);
        ZipEntry e = null;
        boolean foundManifest = false;
        byte[] buf = new byte[1024];
        int n = 0;
        boolean updateOk = true;
        if (t.containsKey(INDEX)) {
            this.addIndex((JarIndex)t.get(INDEX), zos);
        }
        while ((e = zis.getNextEntry()) != null) {
            String name = e.getName();
            boolean isManifestEntry = name.toUpperCase(Locale.ENGLISH).equals(MANIFEST);
            if (name.toUpperCase().equals(INDEX) && t.containsKey(INDEX) || this.Mflag && isManifestEntry) continue;
            if (isManifestEntry && (newManifest != null || this.ename != null)) {
                foundManifest = true;
                if (newManifest != null) {
                    FileInputStream fis = new FileInputStream(this.mname);
                    boolean ambigous = this.isAmbigousMainClass(new Manifest(fis));
                    fis.close();
                    if (ambigous) {
                        return false;
                    }
                }
                Manifest old = new Manifest(zis);
                if (newManifest != null) {
                    old.read(newManifest);
                }
                this.updateManifest(old, zos);
                continue;
            }
            if (!t.containsKey(name)) {
                ZipEntry e2 = new ZipEntry(name);
                e2.setMethod(e.getMethod());
                e2.setTime(e.getTime());
                e2.setComment(e.getComment());
                e2.setExtra(e.getExtra());
                if (e.getMethod() == 0) {
                    e2.setSize(e.getSize());
                    e2.setCrc(e.getCrc());
                }
                ((ZipOutputStream)zos).putNextEntry(e2);
                while ((n = zis.read(buf, 0, buf.length)) != -1) {
                    zos.write(buf, 0, n);
                }
                continue;
            }
            this.addFile(zos, (File)t.get(name));
            t.remove(name);
        }
        t.remove(INDEX);
        if (!t.isEmpty()) {
            for (int i = 0; i < v.size(); ++i) {
                File f = (File)v.elementAt(i);
                if (!t.containsValue(f)) continue;
                this.addFile(zos, f);
            }
        }
        if (!foundManifest) {
            if (newManifest != null) {
                Manifest m = new Manifest(newManifest);
                boolean bl = updateOk = !this.isAmbigousMainClass(m);
                if (updateOk) {
                    this.updateManifest(m, zos);
                }
            } else if (this.ename != null) {
                this.updateManifest(new Manifest(), zos);
            }
        }
        zis.close();
        zos.close();
        return updateOk;
    }

    private void addIndex(JarIndex index, ZipOutputStream zos) throws IOException {
        ZipEntry e = new ZipEntry(INDEX);
        e.setTime(System.currentTimeMillis());
        if (this.flag0) {
            e.setMethod(0);
            File ifile = File.createTempFile("index", null, new File("."));
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(ifile));
            index.write(bos);
            this.crc32File(e, ifile);
            bos.close();
            ifile.delete();
        }
        zos.putNextEntry(e);
        index.write(zos);
        if (this.vflag) {
            // empty if block
        }
    }

    private void updateManifest(Manifest m, ZipOutputStream zos) throws IOException {
        this.addVersion(m);
        this.addCreatedBy(m);
        if (this.ename != null) {
            this.addMainClass(m, this.ename);
        }
        ZipEntry e = new ZipEntry(MANIFEST);
        e.setTime(System.currentTimeMillis());
        if (this.flag0) {
            e.setMethod(0);
            this.crc32Manifest(e, m);
        }
        zos.putNextEntry(e);
        m.write(zos);
        if (this.vflag) {
            this.output(this.getMsg("out.update.manifest"));
        }
    }

    private String entryName(String name) {
        name = name.replace(File.separatorChar, '/');
        String matchPath = "";
        for (int i = 0; i < this.paths.size(); ++i) {
            String path = (String)this.paths.elementAt(i);
            if (!name.startsWith(path) || path.length() <= matchPath.length()) continue;
            matchPath = path;
        }
        if ((name = name.substring(matchPath.length())).startsWith("/")) {
            name = name.substring(1);
        } else if (name.startsWith("./")) {
            name = name.substring(2);
        }
        return name;
    }

    private void addVersion(Manifest m) {
        Attributes global = m.getMainAttributes();
        if (global.getValue(Attributes.Name.MANIFEST_VERSION) == null) {
            global.put(Attributes.Name.MANIFEST_VERSION, VERSION);
        }
    }

    private void addCreatedBy(Manifest m) {
        Attributes global = m.getMainAttributes();
        if (global.getValue(new Attributes.Name("Created-By")) == null) {
            String javaVendor = System.getProperty("java.vendor");
            String jdkVersion = System.getProperty("java.version");
            global.put(new Attributes.Name("Created-By"), jdkVersion + " (" + javaVendor + ")");
        }
    }

    private void addMainClass(Manifest m, String mainApp) {
        Attributes global = m.getMainAttributes();
        global.put(Attributes.Name.MAIN_CLASS, mainApp);
    }

    private boolean isAmbigousMainClass(Manifest m) {
        Attributes global;
        if (this.ename != null && (global = m.getMainAttributes()).get(Attributes.Name.MAIN_CLASS) != null) {
            this.error(this.getMsg("error.bad.eflag"));
            this.usageError();
            return true;
        }
        return false;
    }

    void addFile(ZipOutputStream zos, File file) throws IOException {
        long size;
        String name = file.getPath();
        boolean isDir = file.isDirectory();
        if (isDir) {
            String string = name = name.endsWith(File.separator) ? name : name + File.separator;
        }
        if ((name = this.entryName(name)).equals("") || name.equals(".") || name.equals(this.zname)) {
            return;
        }
        if ((name.equals(MANIFEST_DIR) || name.equals(MANIFEST)) && !this.Mflag) {
            if (this.vflag) {
                this.output(this.formatMsg("out.ignore.entry", name));
            }
            return;
        }
        long l = size = isDir ? 0L : file.length();
        if (this.vflag) {
            this.out.print(this.formatMsg("out.adding", name));
        }
        ZipEntry e = new ZipEntry(name);
        e.setTime(file.lastModified());
        if (size == 0L) {
            e.setMethod(0);
            e.setSize(0L);
            e.setCrc(0L);
        } else if (this.flag0) {
            e.setSize(size);
            e.setMethod(0);
            this.crc32File(e, file);
        }
        zos.putNextEntry(e);
        if (!isDir) {
            int len;
            byte[] buf = new byte[1024];
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            while ((len = ((InputStream)is).read(buf, 0, buf.length)) != -1) {
                zos.write(buf, 0, len);
            }
            ((InputStream)is).close();
        }
        zos.closeEntry();
        if (this.vflag) {
            size = e.getSize();
            long csize = e.getCompressedSize();
            this.out.print(this.formatMsg2("out.size", String.valueOf(size), String.valueOf(csize)));
            if (e.getMethod() == 8) {
                long ratio = 0L;
                if (size != 0L) {
                    ratio = (size - csize) * 100L / size;
                }
                this.output(this.formatMsg("out.deflated", String.valueOf(ratio)));
            } else {
                this.output(this.getMsg("out.stored"));
            }
        }
    }

    private void crc32Manifest(ZipEntry e, Manifest m) throws IOException {
        this.crc32.reset();
        CRC32OutputStream os = new CRC32OutputStream(this.crc32);
        m.write(os);
        e.setSize(os.n);
        e.setCrc(this.crc32.getValue());
    }

    private void crc32File(ZipEntry e, File f) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));
        byte[] buf = new byte[1024];
        this.crc32.reset();
        int r = 0;
        int nread = 0;
        long len = f.length();
        while ((r = ((InputStream)is).read(buf)) != -1) {
            nread += r;
            this.crc32.update(buf, 0, r);
        }
        ((InputStream)is).close();
        if (nread != (int)len) {
            throw new JarException(this.formatMsg("error.incorrect.length", f.getPath()));
        }
        e.setCrc(this.crc32.getValue());
    }

    void extract(InputStream in, String[] files) throws IOException {
        ZipEntry e;
        ZipInputStream zis = new ZipInputStream(in);
        HashSet<ZipEntry> dirs = new HashSet<ZipEntry>(){

            @Override
            public boolean add(ZipEntry e) {
                return e == null || useExtractionTime ? false : super.add(e);
            }
        };
        block0: while ((e = zis.getNextEntry()) != null) {
            if (files == null) {
                dirs.add(this.extractFile(zis, e));
                continue;
            }
            String name = e.getName();
            for (int i = 0; i < files.length; ++i) {
                String file = files[i].replace(File.separatorChar, '/');
                if (!name.startsWith(file)) continue;
                dirs.add(this.extractFile(zis, e));
                continue block0;
            }
        }
        for (ZipEntry dirEntry : dirs) {
            long lastModified = dirEntry.getTime();
            if (lastModified == -1L) continue;
            File dir = new File(dirEntry.getName().replace('/', File.separatorChar));
            dir.setLastModified(lastModified);
        }
    }

    ZipEntry extractFile(ZipInputStream zis, ZipEntry e) throws IOException {
        long lastModified;
        ZipEntry rc = null;
        String name = e.getName();
        File f = new File(e.getName().replace('/', File.separatorChar));
        if (e.isDirectory()) {
            if (f.exists()) {
                if (!f.isDirectory()) {
                    throw new IOException(this.formatMsg("error.create.dir", f.getPath()));
                }
            } else {
                if (!f.mkdirs()) {
                    throw new IOException(this.formatMsg("error.create.dir", f.getPath()));
                }
                rc = e;
            }
            if (this.vflag) {
                this.output(this.formatMsg("out.create", name));
            }
        } else {
            int len;
            File d;
            if (!(f.getParent() == null || ((d = new File(f.getParent())).exists() || d.mkdirs()) && d.isDirectory())) {
                throw new IOException(this.formatMsg("error.create.dir", d.getPath()));
            }
            FileOutputStream os = new FileOutputStream(f);
            byte[] b = new byte[512];
            while ((len = zis.read(b, 0, b.length)) != -1) {
                ((OutputStream)os).write(b, 0, len);
            }
            zis.closeEntry();
            ((OutputStream)os).close();
            if (this.vflag) {
                if (e.getMethod() == 8) {
                    this.output(this.formatMsg("out.inflated", name));
                } else {
                    this.output(this.formatMsg("out.extracted", name));
                }
            }
        }
        if (!useExtractionTime && (lastModified = e.getTime()) != -1L) {
            f.setLastModified(lastModified);
        }
        return rc;
    }

    void list(InputStream in, String[] files) throws IOException {
        ZipEntry e;
        ZipInputStream zis = new ZipInputStream(in);
        block0: while ((e = zis.getNextEntry()) != null) {
            String name = e.getName();
            zis.closeEntry();
            if (files == null) {
                this.printEntry(e);
                continue;
            }
            for (int i = 0; i < files.length; ++i) {
                String file = files[i].replace(File.separatorChar, '/');
                if (!name.startsWith(file)) continue;
                this.printEntry(e);
                continue block0;
            }
        }
    }

    void dumpIndex(String rootjar, JarIndex index) throws IOException {
        this.filesTable.put(INDEX, index);
        File scratchFile = File.createTempFile("scratch", null, new File("."));
        File jarFile = new File(rootjar);
        boolean updateOk = this.update(new FileInputStream(jarFile), new FileOutputStream(scratchFile), null);
        jarFile.delete();
        if (!scratchFile.renameTo(jarFile)) {
            scratchFile.delete();
            throw new IOException(this.getMsg("error.write.file"));
        }
        scratchFile.delete();
    }

    Vector getJarPath(String jar2) throws IOException {
        String value;
        Attributes attr;
        Manifest man;
        Vector<String> files = new Vector<String>();
        files.add(jar2);
        this.jarTable.put(jar2, jar2);
        String path = jar2.substring(0, Math.max(0, jar2.lastIndexOf(47) + 1));
        JarFile rf = new JarFile(jar2.replace('/', File.separatorChar));
        if (rf != null && (man = rf.getManifest()) != null && (attr = man.getMainAttributes()) != null && (value = attr.getValue(Attributes.Name.CLASS_PATH)) != null) {
            StringTokenizer st = new StringTokenizer(value);
            while (st.hasMoreTokens()) {
                String ajar = st.nextToken();
                if (ajar.endsWith("/") || this.jarTable.get(ajar = path.concat(ajar)) != null) continue;
                files.addAll(this.getJarPath(ajar));
            }
        }
        rf.close();
        return files;
    }

    void genIndex(String rootjar, String[] files) throws IOException {
        Vector jars = this.getJarPath(rootjar);
        int njars = jars.size();
        if (njars == 1 && files != null) {
            for (int i = 0; i < files.length; ++i) {
                jars.addAll(this.getJarPath(files[i]));
            }
            njars = jars.size();
        }
        String[] jarfiles = jars.toArray(new String[njars]);
        JarIndex index = new JarIndex(jarfiles);
        this.dumpIndex(rootjar, index);
    }

    void printEntry(ZipEntry e) throws IOException {
        if (this.vflag) {
            StringBuffer sb = new StringBuffer();
            String s = Long.toString(e.getSize());
            for (int i = 6 - s.length(); i > 0; --i) {
                sb.append(' ');
            }
            sb.append(s).append(' ').append(new Date(e.getTime()).toString());
            sb.append(' ').append(e.getName());
            this.output(sb.toString());
        } else {
            this.output(e.getName());
        }
    }

    void usageError() {
        this.error(this.getMsg("usage"));
    }

    void fatalError(Exception e) {
        e.printStackTrace();
    }

    void fatalError(String s) {
        this.error(this.program + ": " + s);
    }

    protected void output(String s) {
        this.out.println(s);
    }

    protected void error(String s) {
        this.err.println(s);
    }

    public static void main(String[] args) {
        Main jartool = new Main(System.out, System.err, "jar");
        System.exit(jartool.run(args) ? 0 : 1);
    }

    static {
        useExtractionTime = Boolean.getBoolean("sun.tools.jar.useExtractionTime");
        try {
            rsrc = ResourceBundle.getBundle("sun.tools.jar.resources.jar");
        }
        catch (MissingResourceException e) {
            throw new Error("Fatal: Resource for jar is missing");
        }
    }
}

