/*
 * Decompiled with CFR 0.152.
 */
package sun.security.rsa;

import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.MGF1ParameterSpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import sun.security.jca.JCAUtil;
import sun.security.rsa.RSACore;

public final class RSAPadding {
    public static final int PAD_BLOCKTYPE_1 = 1;
    public static final int PAD_BLOCKTYPE_2 = 2;
    public static final int PAD_NONE = 3;
    public static final int PAD_OAEP_MGF1 = 4;
    private final int type;
    private final int paddedSize;
    private SecureRandom random;
    private final int maxDataSize;
    private MessageDigest md;
    private MessageDigest mgfMd;
    private byte[] lHash;
    private static final Map<String, byte[]> emptyHashes = Collections.synchronizedMap(new HashMap());

    public static RSAPadding getInstance(int type, int paddedSize) throws InvalidKeyException, InvalidAlgorithmParameterException {
        return new RSAPadding(type, paddedSize, null, null);
    }

    public static RSAPadding getInstance(int type, int paddedSize, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        return new RSAPadding(type, paddedSize, random, null);
    }

    public static RSAPadding getInstance(int type, int paddedSize, SecureRandom random, OAEPParameterSpec spec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        return new RSAPadding(type, paddedSize, random, spec);
    }

    private RSAPadding(int type, int paddedSize, SecureRandom random, OAEPParameterSpec spec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.type = type;
        this.paddedSize = paddedSize;
        this.random = random;
        if (paddedSize < 64) {
            throw new InvalidKeyException("Padded size must be at least 64");
        }
        switch (type) {
            case 1: 
            case 2: {
                this.maxDataSize = paddedSize - 11;
                break;
            }
            case 3: {
                this.maxDataSize = paddedSize;
                break;
            }
            case 4: {
                String mdName = "SHA-1";
                String mgfMdName = "SHA-1";
                byte[] digestInput = null;
                try {
                    if (spec != null) {
                        mdName = spec.getDigestAlgorithm();
                        String mgfName = spec.getMGFAlgorithm();
                        if (!mgfName.equalsIgnoreCase("MGF1")) {
                            throw new InvalidAlgorithmParameterException("Unsupported MGF algo: " + mgfName);
                        }
                        mgfMdName = ((MGF1ParameterSpec)spec.getMGFParameters()).getDigestAlgorithm();
                        PSource pSrc = spec.getPSource();
                        String pSrcAlgo = pSrc.getAlgorithm();
                        if (!pSrcAlgo.equalsIgnoreCase("PSpecified")) {
                            throw new InvalidAlgorithmParameterException("Unsupported pSource algo: " + pSrcAlgo);
                        }
                        digestInput = ((PSource.PSpecified)pSrc).getValue();
                    }
                    this.md = MessageDigest.getInstance(mdName);
                    this.mgfMd = MessageDigest.getInstance(mgfMdName);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new InvalidKeyException("Digest " + mdName + " not available", e);
                }
                this.lHash = RSAPadding.getInitialHash(this.md, digestInput);
                int digestLen = this.lHash.length;
                this.maxDataSize = paddedSize - 2 - 2 * digestLen;
                if (this.maxDataSize > 0) break;
                throw new InvalidKeyException("Key is too short for encryption using OAEPPadding with " + mdName + " and MGF1" + mgfMdName);
            }
            default: {
                throw new InvalidKeyException("Invalid padding: " + type);
            }
        }
    }

    private static byte[] getInitialHash(MessageDigest md, byte[] digestInput) {
        byte[] result = null;
        if (digestInput == null || digestInput.length == 0) {
            String digestName = md.getAlgorithm();
            result = emptyHashes.get(digestName);
            if (result == null) {
                result = md.digest();
                emptyHashes.put(digestName, result);
            }
        } else {
            result = md.digest(digestInput);
        }
        return result;
    }

    public int getMaxDataSize() {
        return this.maxDataSize;
    }

    public byte[] pad(byte[] data, int ofs, int len) throws BadPaddingException {
        return this.pad(RSACore.convert(data, ofs, len));
    }

    public byte[] pad(byte[] data) throws BadPaddingException {
        if (data.length > this.maxDataSize) {
            throw new BadPaddingException("Data must be shorter than " + (this.maxDataSize + 1) + " bytes");
        }
        switch (this.type) {
            case 3: {
                return data;
            }
            case 1: 
            case 2: {
                return this.padV15(data);
            }
            case 4: {
                return this.padOAEP(data);
            }
        }
        throw new AssertionError();
    }

    public byte[] unpad(byte[] padded, int ofs, int len) throws BadPaddingException {
        return this.unpad(RSACore.convert(padded, ofs, len));
    }

    public byte[] unpad(byte[] padded) throws BadPaddingException {
        if (padded.length != this.paddedSize) {
            throw new BadPaddingException("Padded length must be " + this.paddedSize);
        }
        switch (this.type) {
            case 3: {
                return padded;
            }
            case 1: 
            case 2: {
                return this.unpadV15(padded);
            }
            case 4: {
                return this.unpadOAEP(padded);
            }
        }
        throw new AssertionError();
    }

    private byte[] padV15(byte[] data) throws BadPaddingException {
        byte[] padded = new byte[this.paddedSize];
        System.arraycopy(data, 0, padded, this.paddedSize - data.length, data.length);
        int psSize = this.paddedSize - 3 - data.length;
        int k = 0;
        padded[k++] = 0;
        padded[k++] = (byte)this.type;
        if (this.type == 1) {
            while (psSize-- > 0) {
                padded[k++] = -1;
            }
        } else {
            if (this.random == null) {
                this.random = JCAUtil.getSecureRandom();
            }
            byte[] r = new byte[64];
            int i = -1;
            while (psSize-- > 0) {
                int b;
                do {
                    if (i >= 0) continue;
                    this.random.nextBytes(r);
                    i = r.length - 1;
                } while ((b = r[i--] & 0xFF) == 0);
                padded[k++] = (byte)b;
            }
        }
        return padded;
    }

    private byte[] unpadV15(byte[] padded) throws BadPaddingException {
        int b;
        int k = 0;
        if (padded[k++] != 0) {
            throw new BadPaddingException("Data must start with zero");
        }
        if (padded[k++] != this.type) {
            throw new BadPaddingException("Blocktype mismatch: " + padded[1]);
        }
        while ((b = padded[k++] & 0xFF) != 0) {
            if (k == padded.length) {
                throw new BadPaddingException("Padding string not terminated");
            }
            if (this.type != 1 || b == 255) continue;
            throw new BadPaddingException("Padding byte not 0xff: " + b);
        }
        int n = padded.length - k;
        if (n > this.maxDataSize) {
            throw new BadPaddingException("Padding string too short");
        }
        byte[] data = new byte[n];
        System.arraycopy(padded, padded.length - n, data, 0, n);
        return data;
    }

    private byte[] padOAEP(byte[] M) throws BadPaddingException {
        if (this.random == null) {
            this.random = JCAUtil.getSecureRandom();
        }
        int hLen = this.lHash.length;
        byte[] seed = new byte[hLen];
        this.random.nextBytes(seed);
        byte[] EM = new byte[this.paddedSize];
        int seedStart = 1;
        int seedLen = hLen;
        System.arraycopy(seed, 0, EM, seedStart, seedLen);
        int dbStart = hLen + 1;
        int dbLen = EM.length - dbStart;
        int mStart = this.paddedSize - M.length;
        System.arraycopy(this.lHash, 0, EM, dbStart, hLen);
        EM[mStart - 1] = 1;
        System.arraycopy(M, 0, EM, mStart, M.length);
        this.mgf1(EM, seedStart, seedLen, EM, dbStart, dbLen);
        this.mgf1(EM, dbStart, dbLen, EM, seedStart, seedLen);
        return EM;
    }

    private byte[] unpadOAEP(byte[] padded) throws BadPaddingException {
        int i;
        byte[] EM = padded;
        int hLen = this.lHash.length;
        if (EM[0] != 0) {
            throw new BadPaddingException("Data must start with zero");
        }
        int seedStart = 1;
        int seedLen = hLen;
        int dbStart = hLen + 1;
        int dbLen = EM.length - dbStart;
        this.mgf1(EM, dbStart, dbLen, EM, seedStart, seedLen);
        this.mgf1(EM, seedStart, seedLen, EM, dbStart, dbLen);
        for (i = 0; i < hLen; ++i) {
            if (this.lHash[i] == EM[dbStart + i]) continue;
            throw new BadPaddingException("lHash mismatch");
        }
        i = dbStart + hLen;
        while (EM[i] == 0) {
            if (++i < EM.length) continue;
            throw new BadPaddingException("Padding string not terminated");
        }
        if (EM[i++] != 1) {
            throw new BadPaddingException("Padding string not terminated by 0x01 byte");
        }
        int mLen = EM.length - i;
        byte[] m = new byte[mLen];
        System.arraycopy(EM, i, m, 0, mLen);
        return m;
    }

    private void mgf1(byte[] seed, int seedOfs, int seedLen, byte[] out, int outOfs, int maskLen) throws BadPaddingException {
        byte[] C = new byte[4];
        byte[] digest = new byte[20];
        block2: while (maskLen > 0) {
            this.mgfMd.update(seed, seedOfs, seedLen);
            this.mgfMd.update(C);
            try {
                this.mgfMd.digest(digest, 0, digest.length);
            }
            catch (DigestException e) {
                throw new BadPaddingException(e.toString());
            }
            int i = 0;
            while (i < digest.length && maskLen > 0) {
                int n = outOfs++;
                out[n] = (byte)(out[n] ^ digest[i++]);
                --maskLen;
            }
            if (maskLen <= 0) continue;
            i = C.length - 1;
            while (true) {
                int n = --i;
                C[n] = (byte)(C[n] + 1);
                if (C[n] != 0 || i <= 0) continue block2;
            }
        }
    }
}

