/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.certpath.BasicChecker;
import sun.security.provider.certpath.ConstraintsChecker;
import sun.security.provider.certpath.CrlRevocationChecker;
import sun.security.provider.certpath.PolicyChecker;
import sun.security.provider.certpath.PolicyNodeImpl;
import sun.security.provider.certpath.State;
import sun.security.util.Debug;
import sun.security.x509.NameConstraintsExtension;
import sun.security.x509.SubjectKeyIdentifierExtension;
import sun.security.x509.X509CertImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReverseState
implements State {
    private static final Debug debug = Debug.getInstance("certpath");
    X500Principal subjectDN;
    PublicKey pubKey;
    SubjectKeyIdentifierExtension subjKeyId;
    NameConstraintsExtension nc;
    int explicitPolicy;
    int policyMapping;
    int inhibitAnyPolicy;
    int certIndex;
    PolicyNodeImpl rootNode;
    int remainingCACerts;
    ArrayList<PKIXCertPathChecker> userCheckers;
    private boolean init = true;
    public CrlRevocationChecker crlChecker;
    TrustAnchor trustAnchor;
    public boolean crlSign = true;

    ReverseState() {
    }

    @Override
    public boolean isInitial() {
        return this.init;
    }

    public String toString() {
        StringBuffer sb;
        block2: {
            sb = new StringBuffer();
            try {
                sb.append("State [");
                sb.append("\n  subjectDN of last cert: " + this.subjectDN);
                sb.append("\n  subjectKeyIdentifier: " + String.valueOf(this.subjKeyId));
                sb.append("\n  nameConstraints: " + String.valueOf(this.nc));
                sb.append("\n  certIndex: " + this.certIndex);
                sb.append("\n  explicitPolicy: " + this.explicitPolicy);
                sb.append("\n  policyMapping:  " + this.policyMapping);
                sb.append("\n  inhibitAnyPolicy:  " + this.inhibitAnyPolicy);
                sb.append("\n  rootNode: " + this.rootNode);
                sb.append("\n  remainingCACerts: " + this.remainingCACerts);
                sb.append("\n  crlSign: " + this.crlSign);
                sb.append("\n  init: " + this.init);
                sb.append("\n]\n");
            }
            catch (Exception e) {
                if (debug == null) break block2;
                debug.println("ReverseState.toString() unexpected exception");
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public void initState(int maxPathLen, boolean explicitPolicyRequired, boolean policyMappingInhibited, boolean anyPolicyInhibited, List<PKIXCertPathChecker> certPathCheckers) throws CertPathValidatorException {
        int n = this.remainingCACerts = maxPathLen == -1 ? Integer.MAX_VALUE : maxPathLen;
        if (explicitPolicyRequired) {
            this.explicitPolicy = 0;
        } else {
            int n2 = this.explicitPolicy = maxPathLen == -1 ? maxPathLen : maxPathLen + 2;
        }
        if (policyMappingInhibited) {
            this.policyMapping = 0;
        } else {
            int n3 = this.policyMapping = maxPathLen == -1 ? maxPathLen : maxPathLen + 2;
        }
        this.inhibitAnyPolicy = anyPolicyInhibited ? 0 : (maxPathLen == -1 ? maxPathLen : maxPathLen + 2);
        this.certIndex = 1;
        HashSet<String> initExpPolSet = new HashSet<String>(1);
        initExpPolSet.add("2.5.29.32.0");
        this.rootNode = new PolicyNodeImpl(null, "2.5.29.32.0", null, false, initExpPolSet, false);
        if (certPathCheckers != null) {
            this.userCheckers = new ArrayList<PKIXCertPathChecker>(certPathCheckers);
            for (PKIXCertPathChecker checker : certPathCheckers) {
                checker.init(false);
            }
        } else {
            this.userCheckers = new ArrayList();
        }
        this.crlSign = true;
        this.init = true;
    }

    public void updateState(TrustAnchor anchor) throws CertificateException, IOException, CertPathValidatorException {
        this.trustAnchor = anchor;
        X509Certificate trustedCert = anchor.getTrustedCert();
        if (trustedCert != null) {
            this.updateState(trustedCert);
        } else {
            X500Principal caName = anchor.getCA();
            this.updateState(anchor.getCAPublicKey(), caName);
        }
        this.init = false;
    }

    private void updateState(PublicKey pubKey, X500Principal subjectDN) {
        this.subjectDN = subjectDN;
        this.pubKey = pubKey;
    }

    @Override
    public void updateState(X509Certificate cert) throws CertificateException, IOException, CertPathValidatorException {
        if (cert == null) {
            return;
        }
        this.subjectDN = cert.getSubjectX500Principal();
        X509CertImpl icert = X509CertImpl.toImpl(cert);
        PublicKey newKey = cert.getPublicKey();
        if (newKey instanceof DSAPublicKey && ((DSAPublicKey)newKey).getParams() == null) {
            newKey = BasicChecker.makeInheritedParamsKey(newKey, this.pubKey);
        }
        this.pubKey = newKey;
        if (this.init) {
            this.init = false;
            return;
        }
        this.subjKeyId = icert.getSubjectKeyIdentifierExtension();
        this.crlSign = CrlRevocationChecker.certCanSignCrl(cert);
        if (this.nc != null) {
            this.nc.merge(icert.getNameConstraintsExtension());
        } else {
            this.nc = icert.getNameConstraintsExtension();
            if (this.nc != null) {
                this.nc = (NameConstraintsExtension)this.nc.clone();
            }
        }
        this.explicitPolicy = PolicyChecker.mergeExplicitPolicy(this.explicitPolicy, icert, false);
        this.policyMapping = PolicyChecker.mergePolicyMapping(this.policyMapping, icert);
        this.inhibitAnyPolicy = PolicyChecker.mergeInhibitAnyPolicy(this.inhibitAnyPolicy, icert);
        ++this.certIndex;
        this.remainingCACerts = ConstraintsChecker.mergeBasicConstraints(cert, this.remainingCACerts);
        this.init = false;
    }

    @Override
    public boolean keyParamsNeeded() {
        return false;
    }

    @Override
    public Object clone() {
        try {
            ReverseState clonedState = (ReverseState)super.clone();
            clonedState.userCheckers = (ArrayList)this.userCheckers.clone();
            ListIterator<PKIXCertPathChecker> li = clonedState.userCheckers.listIterator();
            while (li.hasNext()) {
                PKIXCertPathChecker checker = li.next();
                if (!(checker instanceof Cloneable)) continue;
                li.set((PKIXCertPathChecker)checker.clone());
            }
            if (this.nc != null) {
                clonedState.nc = (NameConstraintsExtension)this.nc.clone();
            }
            if (this.rootNode != null) {
                clonedState.rootNode = this.rootNode.copyTree();
            }
            return clonedState;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }
}

