/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import sun.security.action.GetPropertyAction;
import sun.security.jgss.GSSExceptionImpl;
import sun.security.jgss.GSSUtil;
import sun.security.jgss.spi.MechanismFactory;
import sun.security.jgss.wrapper.NativeGSSFactory;
import sun.security.jgss.wrapper.SunNativeProvider;

public final class ProviderList {
    private static final String PROV_PROP_PREFIX = "GssApiMechanism.";
    private static final int PROV_PROP_PREFIX_LEN = "GssApiMechanism.".length();
    private static final String SPI_MECH_FACTORY_TYPE = "sun.security.jgss.spi.MechanismFactory";
    private static final String DEFAULT_MECH_PROP = "sun.security.jgss.mechanism";
    public static final Oid DEFAULT_MECH_OID;
    private ArrayList<PreferencesEntry> preferences = new ArrayList(5);
    private HashMap<PreferencesEntry, MechanismFactory> factories = new HashMap(5);
    private HashSet<Oid> mechs = new HashSet(5);
    private final int caller;

    public ProviderList(int caller, boolean useNative) {
        this.caller = caller;
        Provider[] provList = useNative ? new Provider[]{new SunNativeProvider()} : Security.getProviders();
        for (int i = 0; i < provList.length; ++i) {
            Provider prov = provList[i];
            try {
                this.addProviderAtEnd(prov, null);
                continue;
            }
            catch (GSSException ge) {
                GSSUtil.debug("Error in adding provider " + prov.getName() + ": " + ge);
            }
        }
    }

    private boolean isMechFactoryProperty(String prop) {
        return prop.startsWith(PROV_PROP_PREFIX) || prop.regionMatches(true, 0, PROV_PROP_PREFIX, 0, PROV_PROP_PREFIX_LEN);
    }

    private Oid getOidFromMechFactoryProperty(String prop) throws GSSException {
        String oidPart = prop.substring(PROV_PROP_PREFIX_LEN);
        return new Oid(oidPart);
    }

    public synchronized MechanismFactory getMechFactory(Oid mechOid) throws GSSException {
        if (mechOid == null) {
            mechOid = DEFAULT_MECH_OID;
        }
        return this.getMechFactory(mechOid, null);
    }

    public synchronized MechanismFactory getMechFactory(Oid mechOid, Provider p) throws GSSException {
        if (mechOid == null) {
            mechOid = DEFAULT_MECH_OID;
        }
        if (p == null) {
            for (PreferencesEntry entry : this.preferences) {
                MechanismFactory retVal;
                if (!entry.impliesMechanism(mechOid) || (retVal = this.getMechFactory(entry, mechOid)) == null) continue;
                return retVal;
            }
            throw new GSSExceptionImpl(2, mechOid);
        }
        PreferencesEntry entry = new PreferencesEntry(p, mechOid);
        return this.getMechFactory(entry, mechOid);
    }

    private MechanismFactory getMechFactory(PreferencesEntry e, Oid mechOid) throws GSSException {
        Provider p = e.getProvider();
        PreferencesEntry searchEntry = new PreferencesEntry(p, mechOid);
        MechanismFactory retVal = this.factories.get(searchEntry);
        if (retVal == null) {
            String prop = PROV_PROP_PREFIX + mechOid.toString();
            String className = p.getProperty(prop);
            if (className != null) {
                retVal = ProviderList.getMechFactoryImpl(p, className, mechOid, this.caller);
                this.factories.put(searchEntry, retVal);
            } else if (e.getOid() != null) {
                throw new GSSExceptionImpl(2, "Provider " + p.getName() + " does not support mechanism " + mechOid);
            }
        }
        return retVal;
    }

    private static MechanismFactory getMechFactoryImpl(Provider p, String className, Oid mechOid, int caller) throws GSSException {
        try {
            Class<?> baseClass = Class.forName(SPI_MECH_FACTORY_TYPE);
            ClassLoader cl = p.getClass().getClassLoader();
            Class<?> implClass = cl != null ? cl.loadClass(className) : Class.forName(className);
            if (baseClass.isAssignableFrom(implClass)) {
                Constructor<?> c = implClass.getConstructor(Integer.TYPE);
                MechanismFactory mf = (MechanismFactory)c.newInstance(caller);
                if (mf instanceof NativeGSSFactory) {
                    ((NativeGSSFactory)mf).setMech(mechOid);
                }
                return mf;
            }
            throw ProviderList.createGSSException(p, className, "is not a sun.security.jgss.spi.MechanismFactory", null);
        }
        catch (ClassNotFoundException e) {
            throw ProviderList.createGSSException(p, className, "cannot be created", e);
        }
        catch (NoSuchMethodException e) {
            throw ProviderList.createGSSException(p, className, "cannot be created", e);
        }
        catch (InvocationTargetException e) {
            throw ProviderList.createGSSException(p, className, "cannot be created", e);
        }
        catch (InstantiationException e) {
            throw ProviderList.createGSSException(p, className, "cannot be created", e);
        }
        catch (IllegalAccessException e) {
            throw ProviderList.createGSSException(p, className, "cannot be created", e);
        }
        catch (SecurityException e) {
            throw ProviderList.createGSSException(p, className, "cannot be created", e);
        }
    }

    private static GSSException createGSSException(Provider p, String className, String trailingMsg, Exception cause) {
        String errClassInfo = className + " configured by " + p.getName() + " for GSS-API Mechanism Factory ";
        return new GSSExceptionImpl(2, errClassInfo + trailingMsg, cause);
    }

    public Oid[] getMechs() {
        return this.mechs.toArray(new Oid[0]);
    }

    public synchronized void addProviderAtFront(Provider p, Oid mechOid) throws GSSException {
        boolean foundSomeMech;
        PreferencesEntry newEntry = new PreferencesEntry(p, mechOid);
        Iterator<PreferencesEntry> list = this.preferences.iterator();
        while (list.hasNext()) {
            PreferencesEntry oldEntry = list.next();
            if (!newEntry.implies(oldEntry)) continue;
            list.remove();
        }
        if (mechOid == null) {
            foundSomeMech = this.addAllMechsFromProvider(p);
        } else {
            String oidStr = mechOid.toString();
            if (p.getProperty(PROV_PROP_PREFIX + oidStr) == null) {
                throw new GSSExceptionImpl(2, "Provider " + p.getName() + " does not support " + oidStr);
            }
            this.mechs.add(mechOid);
            foundSomeMech = true;
        }
        if (foundSomeMech) {
            this.preferences.add(0, newEntry);
        }
    }

    public synchronized void addProviderAtEnd(Provider p, Oid mechOid) throws GSSException {
        boolean foundSomeMech;
        PreferencesEntry newEntry = new PreferencesEntry(p, mechOid);
        for (PreferencesEntry oldEntry : this.preferences) {
            if (!oldEntry.implies(newEntry)) continue;
            return;
        }
        if (mechOid == null) {
            foundSomeMech = this.addAllMechsFromProvider(p);
        } else {
            String oidStr = mechOid.toString();
            if (p.getProperty(PROV_PROP_PREFIX + oidStr) == null) {
                throw new GSSExceptionImpl(2, "Provider " + p.getName() + " does not support " + oidStr);
            }
            this.mechs.add(mechOid);
            foundSomeMech = true;
        }
        if (foundSomeMech) {
            this.preferences.add(newEntry);
        }
    }

    private boolean addAllMechsFromProvider(Provider p) {
        boolean retVal = false;
        Enumeration<Object> props = p.keys();
        while (props.hasMoreElements()) {
            String prop = (String)props.nextElement();
            if (!this.isMechFactoryProperty(prop)) continue;
            try {
                Oid mechOid = this.getOidFromMechFactoryProperty(prop);
                this.mechs.add(mechOid);
                retVal = true;
            }
            catch (GSSException e) {
                GSSUtil.debug("Ignore the invalid property " + prop + " from provider " + p.getName());
            }
        }
        return retVal;
    }

    static {
        Oid defOid = null;
        String defaultOidStr = AccessController.doPrivileged(new GetPropertyAction(DEFAULT_MECH_PROP));
        if (defaultOidStr != null) {
            defOid = GSSUtil.createOid(defaultOidStr);
        }
        DEFAULT_MECH_OID = defOid == null ? GSSUtil.GSS_KRB5_MECH_OID : defOid;
    }

    private static final class PreferencesEntry {
        private Provider p;
        private Oid oid;

        PreferencesEntry(Provider p, Oid oid) {
            this.p = p;
            this.oid = oid;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PreferencesEntry)) {
                return false;
            }
            PreferencesEntry that = (PreferencesEntry)other;
            if (this.p.getName().equals(that.p.getName())) {
                if (this.oid != null && that.oid != null) {
                    return this.oid.equals(that.oid);
                }
                return this.oid == null && that.oid == null;
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.p.getName().hashCode();
            if (this.oid != null) {
                result = 37 * result + this.oid.hashCode();
            }
            return result;
        }

        boolean implies(Object other) {
            if (other instanceof PreferencesEntry) {
                PreferencesEntry temp = (PreferencesEntry)other;
                return this.equals(temp) || this.p.getName().equals(temp.p.getName()) && this.oid == null;
            }
            return false;
        }

        Provider getProvider() {
            return this.p;
        }

        Oid getOid() {
            return this.oid;
        }

        boolean impliesMechanism(Oid oid) {
            return this.oid == null || this.oid.equals(oid);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("<");
            buf.append(this.p.getName());
            buf.append(", ");
            buf.append(this.oid);
            buf.append(">");
            return buf.toString();
        }
    }
}

