/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import sun.rmi.runtime.NewThreadAction;
import sun.rmi.transport.Connection;
import sun.rmi.transport.tcp.TCPTransport;

class ConnectionAcceptor
implements Runnable {
    private TCPTransport transport;
    private List<Connection> queue = new ArrayList<Connection>();
    private static int threadNum = 0;

    public ConnectionAcceptor(TCPTransport transport) {
        this.transport = transport;
    }

    public void startNewAcceptor() {
        Thread t = AccessController.doPrivileged(new NewThreadAction(this, "Multiplex Accept-" + ++threadNum, true));
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(Connection conn) {
        List<Connection> list = this.queue;
        synchronized (list) {
            this.queue.add(conn);
            this.queue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Connection conn;
        List<Connection> list = this.queue;
        synchronized (list) {
            while (this.queue.size() == 0) {
                try {
                    this.queue.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.startNewAcceptor();
            conn = this.queue.remove(0);
        }
        this.transport.handleMessages(conn, true);
    }
}

