/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.net.SocketException;
import sun.nio.ch.DatagramChannelImpl;
import sun.nio.ch.Net;
import sun.nio.ch.ServerSocketChannelImpl;
import sun.nio.ch.SocketChannelImpl;
import sun.nio.ch.SocketOpts;

class OptionAdaptor {
    private final SocketOpts.IP opts;

    OptionAdaptor(SocketChannelImpl sc) {
        this.opts = (SocketOpts.IP)sc.options();
    }

    OptionAdaptor(ServerSocketChannelImpl ssc) {
        this.opts = (SocketOpts.IP)ssc.options();
    }

    OptionAdaptor(DatagramChannelImpl dc) {
        this.opts = (SocketOpts.IP)dc.options();
    }

    private SocketOpts.IP opts() {
        return this.opts;
    }

    private SocketOpts.IP.TCP tcpOpts() {
        return (SocketOpts.IP.TCP)this.opts;
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        try {
            this.tcpOpts().noDelay(on);
        }
        catch (Exception x) {
            Net.translateToSocketException(x);
        }
    }

    public boolean getTcpNoDelay() throws SocketException {
        try {
            return this.tcpOpts().noDelay();
        }
        catch (Exception x) {
            Net.translateToSocketException(x);
            return false;
        }
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        try {
            if (linger > 65535) {
                linger = 65535;
            }
            this.opts().linger(on ? linger : -1);
        }
        catch (Exception x) {
            Net.translateToSocketException(x);
        }
    }

    public int getSoLinger() throws SocketException {
        try {
            return this.opts().linger();
        }
        catch (Exception x) {
            Net.translateToSocketException(x);
            return 0;
        }
    }

    public void setOOBInline(boolean on) throws SocketException {
        try {
            this.opts().outOfBandInline(on);
        }
        catch (Exception x) {
            Net.translateToSocketException(x);
        }
    }

    public boolean getOOBInline() throws SocketException {
        try {
            return this.opts().outOfBandInline();
        }
        catch (Exception x) {
            Net.translateToSocketException(x);
            return false;
        }
    }

    public void setSendBufferSize(int size) throws SocketException {
        try {
            this.opts().sendBufferSize(size);
        }
        catch (Exception x) {
            Net.translateToSocketException(x);
        }
    }

    public int getSendBufferSize() throws SocketException {
        try {
            return this.opts().sendBufferSize();
        }
        catch (Exception x) {
            Net.translateToSocketException(x);
            return 0;
        }
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        try {
            this.opts().receiveBufferSize(size);
        }
        catch (Exception x) {
            Net.translateToSocketException(x);
        }
    }

    public int getReceiveBufferSize() throws SocketException {
        try {
            return this.opts().receiveBufferSize();
        }
        catch (Exception x) {
            Net.translateToSocketException(x);
            return 0;
        }
    }

    public void setKeepAlive(boolean on) throws SocketException {
        try {
            this.opts().keepAlive(on);
        }
        catch (Exception x) {
            Net.translateToSocketException(x);
        }
    }

    public boolean getKeepAlive() throws SocketException {
        try {
            return this.opts().keepAlive();
        }
        catch (Exception x) {
            Net.translateToSocketException(x);
            return false;
        }
    }

    public void setTrafficClass(int tc) throws SocketException {
        if (tc < 0 || tc > 255) {
            throw new IllegalArgumentException("tc is not in range 0 -- 255");
        }
        try {
            this.opts().typeOfService(tc);
        }
        catch (Exception x) {
            Net.translateToSocketException(x);
        }
    }

    public int getTrafficClass() throws SocketException {
        try {
            return this.opts().typeOfService();
        }
        catch (Exception x) {
            Net.translateToSocketException(x);
            return 0;
        }
    }

    public void setReuseAddress(boolean on) throws SocketException {
        try {
            this.opts().reuseAddress(on);
        }
        catch (Exception x) {
            Net.translateToSocketException(x);
        }
    }

    public boolean getReuseAddress() throws SocketException {
        try {
            return this.opts().reuseAddress();
        }
        catch (Exception x) {
            Net.translateToSocketException(x);
            return false;
        }
    }

    public void setBroadcast(boolean on) throws SocketException {
        try {
            this.opts().broadcast(on);
        }
        catch (Exception x) {
            Net.translateToSocketException(x);
        }
    }

    public boolean getBroadcast() throws SocketException {
        try {
            return this.opts().broadcast();
        }
        catch (Exception x) {
            Net.translateToSocketException(x);
            return false;
        }
    }
}

