/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.CodeSigner;
import java.security.cert.Certificate;
import java.util.jar.Manifest;
import sun.nio.ByteBuffered;

public abstract class Resource {
    private InputStream cis;

    public abstract String getName();

    public abstract URL getURL();

    public abstract URL getCodeSourceURL();

    public abstract InputStream getInputStream() throws IOException;

    public abstract int getContentLength() throws IOException;

    private synchronized InputStream cachedInputStream() throws IOException {
        if (this.cis == null) {
            this.cis = this.getInputStream();
        }
        return this.cis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() throws IOException {
        byte[] b;
        block22: {
            InputStream in = this.cachedInputStream();
            boolean isInterrupted = Thread.interrupted();
            while (true) {
                try {
                }
                catch (InterruptedIOException iioe) {
                    Thread.interrupted();
                    isInterrupted = true;
                    continue;
                }
                break;
            }
            try {
                byte[] tmp;
                int len;
                if (len != -1) {
                    int n;
                    b = new byte[len];
                    for (len = this.getContentLength(); len > 0; len -= n) {
                        n = 0;
                        try {
                            n = in.read(b, b.length - len, len);
                        }
                        catch (InterruptedIOException iioe) {
                            Thread.interrupted();
                            isInterrupted = true;
                        }
                        if (n != -1) continue;
                        throw new IOException("unexpected EOF");
                    }
                    break block22;
                }
                b = new byte[1024];
                int total = 0;
                while (true) {
                    len = 0;
                    try {
                        len = in.read(b, total, b.length - total);
                        if (len == -1) {
                            break;
                        }
                    }
                    catch (InterruptedIOException iioe) {
                        Thread.interrupted();
                        isInterrupted = true;
                    }
                    if ((total += len) < b.length) continue;
                    tmp = new byte[total * 2];
                    System.arraycopy(b, 0, tmp, 0, total);
                    b = tmp;
                }
                if (total != b.length) {
                    tmp = new byte[total];
                    System.arraycopy(b, 0, tmp, 0, total);
                    b = tmp;
                }
            }
            finally {
                try {
                    in.close();
                }
                catch (InterruptedIOException iioe) {
                    isInterrupted = true;
                }
                catch (IOException ignore) {}
                if (isInterrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return b;
    }

    public ByteBuffer getByteBuffer() throws IOException {
        InputStream in = this.cachedInputStream();
        if (in instanceof ByteBuffered) {
            return ((ByteBuffered)((Object)in)).getByteBuffer();
        }
        return null;
    }

    public Manifest getManifest() throws IOException {
        return null;
    }

    public Certificate[] getCertificates() {
        return null;
    }

    public CodeSigner[] getCodeSigners() {
        return null;
    }
}

