/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LRUCache<N, V> {
    private V[] oa = null;
    private final int size;

    public LRUCache(int size) {
        this.size = size;
    }

    protected abstract V create(N var1);

    protected abstract boolean hasName(V var1, N var2);

    public static void moveToFront(Object[] oa, int i) {
        Object ob = oa[i];
        for (int j = i; j > 0; --j) {
            oa[j] = oa[j - 1];
        }
        oa[0] = ob;
    }

    public V forName(N name) {
        if (this.oa == null) {
            this.oa = new Object[this.size];
        } else {
            for (int i = 0; i < this.oa.length; ++i) {
                V ob = this.oa[i];
                if (ob == null || !this.hasName(ob, name)) continue;
                if (i > 0) {
                    LRUCache.moveToFront(this.oa, i);
                }
                return ob;
            }
        }
        V ob = this.create(name);
        this.oa[this.oa.length - 1] = ob;
        LRUCache.moveToFront(this.oa, this.oa.length - 1);
        return ob;
    }
}

