/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvminstr;

import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.agent.SnmpMib;
import com.sun.jmx.snmp.agent.SnmpStandardObjectServer;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.List;
import java.util.Map;
import sun.management.snmp.jvminstr.JVM_MANAGEMENT_MIB_IMPL;
import sun.management.snmp.jvminstr.JvmMemPoolEntryImpl;
import sun.management.snmp.jvmmib.JvmMemPoolTableMeta;
import sun.management.snmp.util.JvmContextFactory;
import sun.management.snmp.util.MibLogger;
import sun.management.snmp.util.SnmpNamedListTableCache;
import sun.management.snmp.util.SnmpTableCache;
import sun.management.snmp.util.SnmpTableHandler;

public class JvmMemPoolTableMetaImpl
extends JvmMemPoolTableMeta {
    protected SnmpTableCache cache;
    static final MibLogger log = new MibLogger(JvmMemPoolTableMetaImpl.class);

    public JvmMemPoolTableMetaImpl(SnmpMib myMib, SnmpStandardObjectServer objserv) {
        super(myMib, objserv);
        this.cache = new JvmMemPoolTableCache(((JVM_MANAGEMENT_MIB_IMPL)myMib).validity() * 30L);
    }

    protected SnmpOid getNextOid(Object userData) throws SnmpStatusException {
        return this.getNextOid(null, userData);
    }

    protected SnmpOid getNextOid(SnmpOid oid, Object userData) throws SnmpStatusException {
        boolean dbg = log.isDebugOn();
        try {
            SnmpTableHandler handler;
            if (dbg) {
                log.debug("getNextOid", "previous=" + oid);
            }
            if ((handler = this.getHandler(userData)) == null) {
                if (dbg) {
                    log.debug("getNextOid", "handler is null!");
                }
                throw new SnmpStatusException(224);
            }
            SnmpOid next = handler.getNext(oid);
            if (dbg) {
                log.debug("getNextOid", "next=" + next);
            }
            if (next == null) {
                throw new SnmpStatusException(224);
            }
            return next;
        }
        catch (SnmpStatusException x) {
            if (dbg) {
                log.debug("getNextOid", "End of MIB View: " + x);
            }
            throw x;
        }
        catch (RuntimeException r) {
            if (dbg) {
                log.debug("getNextOid", "Unexpected exception: " + r);
            }
            if (dbg) {
                log.debug("getNextOid", r);
            }
            throw r;
        }
    }

    protected boolean contains(SnmpOid oid, Object userData) {
        SnmpTableHandler handler = this.getHandler(userData);
        if (handler == null) {
            return false;
        }
        return handler.contains(oid);
    }

    public Object getEntry(SnmpOid oid) throws SnmpStatusException {
        Object entry;
        String entryTag;
        if (oid == null) {
            throw new SnmpStatusException(224);
        }
        Map m = (Map)Util.cast(JvmContextFactory.getUserData());
        long index = oid.getOidArc(0);
        String string = entryTag = m == null ? null : "JvmMemPoolTable.entry." + index;
        if (m != null && (entry = m.get(entryTag)) != null) {
            return entry;
        }
        SnmpTableHandler handler = this.getHandler(m);
        if (handler == null) {
            throw new SnmpStatusException(224);
        }
        Object data = handler.getData(oid);
        if (data == null) {
            throw new SnmpStatusException(224);
        }
        if (log.isDebugOn()) {
            log.debug("getEntry", "data is a: " + data.getClass().getName());
        }
        JvmMemPoolEntryImpl entry2 = new JvmMemPoolEntryImpl((MemoryPoolMXBean)data, (int)index);
        if (m != null && entry2 != null) {
            m.put(entryTag, entry2);
        }
        return entry2;
    }

    protected SnmpTableHandler getHandler(Object userData) {
        SnmpTableHandler handler;
        Map m = userData instanceof Map ? (Map)Util.cast(userData) : null;
        if (m != null && (handler = (SnmpTableHandler)m.get("JvmMemPoolTable.handler")) != null) {
            return handler;
        }
        handler = this.cache.getTableHandler();
        if (m != null && handler != null) {
            m.put("JvmMemPoolTable.handler", handler);
        }
        return handler;
    }

    private static class JvmMemPoolTableCache
    extends SnmpNamedListTableCache {
        JvmMemPoolTableCache(long validity) {
            this.validity = validity;
        }

        protected String getKey(Object context, List rawDatas, int rank, Object item) {
            if (item == null) {
                return null;
            }
            String name = ((MemoryPoolMXBean)item).getName();
            log.debug("getKey", "key=" + name);
            return name;
        }

        public SnmpTableHandler getTableHandler() {
            Map<Object, Object> userData = JvmContextFactory.getUserData();
            return this.getTableDatas(userData);
        }

        protected String getRawDatasKey() {
            return "JvmMemManagerTable.getMemoryPools";
        }

        protected List loadRawDatas(Map userData) {
            return ManagementFactory.getMemoryPoolMXBeans();
        }
    }
}

