/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollPaneUI;
import javax.swing.plaf.metal.MetalBorders;

public class MetalScrollPaneUI
extends BasicScrollPaneUI {
    private PropertyChangeListener scrollBarSwapListener;

    public static ComponentUI createUI(JComponent x) {
        return new MetalScrollPaneUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        JScrollPane sp = (JScrollPane)c;
        this.updateScrollbarsFreeStanding();
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        JScrollPane sp = (JScrollPane)c;
        JScrollBar hsb = sp.getHorizontalScrollBar();
        JScrollBar vsb = sp.getVerticalScrollBar();
        if (hsb != null) {
            hsb.putClientProperty("JScrollBar.isFreeStanding", null);
        }
        if (vsb != null) {
            vsb.putClientProperty("JScrollBar.isFreeStanding", null);
        }
    }

    public void installListeners(JScrollPane scrollPane) {
        super.installListeners(scrollPane);
        this.scrollBarSwapListener = this.createScrollBarSwapListener();
        scrollPane.addPropertyChangeListener(this.scrollBarSwapListener);
    }

    public void uninstallListeners(JScrollPane scrollPane) {
        super.uninstallListeners(scrollPane);
        scrollPane.removePropertyChangeListener(this.scrollBarSwapListener);
    }

    private void updateScrollbarsFreeStanding() {
        if (this.scrollpane == null) {
            return;
        }
        Border border = this.scrollpane.getBorder();
        Boolean value = border instanceof MetalBorders.ScrollPaneBorder ? Boolean.FALSE : Boolean.TRUE;
        JScrollBar sb = this.scrollpane.getHorizontalScrollBar();
        if (sb != null) {
            sb.putClientProperty("JScrollBar.isFreeStanding", value);
        }
        if ((sb = this.scrollpane.getVerticalScrollBar()) != null) {
            sb.putClientProperty("JScrollBar.isFreeStanding", value);
        }
    }

    protected PropertyChangeListener createScrollBarSwapListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String propertyName = e.getPropertyName();
                if (propertyName.equals("verticalScrollBar") || propertyName.equals("horizontalScrollBar")) {
                    JScrollBar newSB;
                    JScrollBar oldSB = (JScrollBar)e.getOldValue();
                    if (oldSB != null) {
                        oldSB.putClientProperty("JScrollBar.isFreeStanding", null);
                    }
                    if ((newSB = (JScrollBar)e.getNewValue()) != null) {
                        newSB.putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
                    }
                } else if ("border".equals(propertyName)) {
                    MetalScrollPaneUI.this.updateScrollbarsFreeStanding();
                }
            }
        };
    }
}

