/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.LazyActionMap;
import javax.swing.text.View;
import sun.swing.MenuItemCheckIconFactory;
import sun.swing.StringUIClientPropertyKey;
import sun.swing.SwingUtilities2;
import sun.swing.UIAction;

public class BasicMenuItemUI
extends MenuItemUI {
    protected JMenuItem menuItem = null;
    protected Color selectionBackground;
    protected Color selectionForeground;
    protected Color disabledForeground;
    protected Color acceleratorForeground;
    protected Color acceleratorSelectionForeground;
    private String acceleratorDelimiter;
    protected int defaultTextIconGap;
    protected Font acceleratorFont;
    protected MouseInputListener mouseInputListener;
    protected MenuDragMouseListener menuDragMouseListener;
    protected MenuKeyListener menuKeyListener;
    protected PropertyChangeListener propertyChangeListener;
    Handler handler;
    protected Icon arrowIcon = null;
    protected Icon checkIcon = null;
    protected boolean oldBorderPainted;
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    private final transient LayoutInfo layoutInfo = new LayoutInfo();
    static final StringUIClientPropertyKey MAX_ARROW_WIDTH = new StringUIClientPropertyKey("maxArrowWidth");
    static final StringUIClientPropertyKey MAX_CHECK_WIDTH = new StringUIClientPropertyKey("maxCheckWidth");
    static final StringUIClientPropertyKey MAX_ICON_WIDTH = new StringUIClientPropertyKey("maxIconWidth");
    static final StringUIClientPropertyKey MAX_TEXT_WIDTH = new StringUIClientPropertyKey("maxTextWidth");
    static final StringUIClientPropertyKey MAX_ACC_WIDTH = new StringUIClientPropertyKey("maxAccWidth");
    static final StringUIClientPropertyKey MAX_LABEL_WIDTH = new StringUIClientPropertyKey("maxLabelWidth");

    static void loadActionMap(LazyActionMap map) {
        map.put(new Actions("doClick"));
        BasicLookAndFeel.installAudioActionMap(map);
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicMenuItemUI();
    }

    public void installUI(JComponent c) {
        this.menuItem = (JMenuItem)c;
        this.installDefaults();
        this.installComponents(this.menuItem);
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        String prefix = this.getPropertyPrefix();
        this.acceleratorFont = UIManager.getFont("MenuItem.acceleratorFont");
        Object opaque = UIManager.get(this.getPropertyPrefix() + ".opaque");
        if (opaque != null) {
            LookAndFeel.installProperty(this.menuItem, "opaque", opaque);
        } else {
            LookAndFeel.installProperty(this.menuItem, "opaque", Boolean.TRUE);
        }
        if (this.menuItem.getMargin() == null || this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(UIManager.getInsets(prefix + ".margin"));
        }
        LookAndFeel.installProperty(this.menuItem, "iconTextGap", new Integer(4));
        this.defaultTextIconGap = this.menuItem.getIconTextGap();
        LookAndFeel.installBorder(this.menuItem, prefix + ".border");
        this.oldBorderPainted = this.menuItem.isBorderPainted();
        LookAndFeel.installProperty(this.menuItem, "borderPainted", UIManager.get(prefix + ".borderPainted"));
        LookAndFeel.installColorsAndFont(this.menuItem, prefix + ".background", prefix + ".foreground", prefix + ".font");
        if (this.selectionBackground == null || this.selectionBackground instanceof UIResource) {
            this.selectionBackground = UIManager.getColor(prefix + ".selectionBackground");
        }
        if (this.selectionForeground == null || this.selectionForeground instanceof UIResource) {
            this.selectionForeground = UIManager.getColor(prefix + ".selectionForeground");
        }
        if (this.disabledForeground == null || this.disabledForeground instanceof UIResource) {
            this.disabledForeground = UIManager.getColor(prefix + ".disabledForeground");
        }
        if (this.acceleratorForeground == null || this.acceleratorForeground instanceof UIResource) {
            this.acceleratorForeground = UIManager.getColor(prefix + ".acceleratorForeground");
        }
        if (this.acceleratorSelectionForeground == null || this.acceleratorSelectionForeground instanceof UIResource) {
            this.acceleratorSelectionForeground = UIManager.getColor(prefix + ".acceleratorSelectionForeground");
        }
        this.acceleratorDelimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
        if (this.acceleratorDelimiter == null) {
            this.acceleratorDelimiter = "+";
        }
        if (this.arrowIcon == null || this.arrowIcon instanceof UIResource) {
            this.arrowIcon = UIManager.getIcon(prefix + ".arrowIcon");
        }
        if (this.checkIcon == null || this.checkIcon instanceof UIResource) {
            MenuItemCheckIconFactory iconFactory;
            this.checkIcon = UIManager.getIcon(prefix + ".checkIcon");
            boolean isColumnLayout = LayoutInfo.isColumnLayout(BasicGraphicsUtils.isLeftToRight(this.menuItem), this.menuItem);
            if (isColumnLayout && (iconFactory = (MenuItemCheckIconFactory)UIManager.get(prefix + ".checkIconFactory")) != null && this.useCheckAndArrow() && iconFactory.isCompatible(this.checkIcon, prefix)) {
                this.checkIcon = iconFactory.getIcon(this.menuItem);
            }
        }
    }

    protected void installComponents(JMenuItem menuItem) {
        BasicHTML.updateRenderer(menuItem, menuItem.getText());
    }

    protected String getPropertyPrefix() {
        return "MenuItem";
    }

    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener(this.menuItem);
        if (this.mouseInputListener != null) {
            this.menuItem.addMouseListener(this.mouseInputListener);
            this.menuItem.addMouseMotionListener(this.mouseInputListener);
        }
        if ((this.menuDragMouseListener = this.createMenuDragMouseListener(this.menuItem)) != null) {
            this.menuItem.addMenuDragMouseListener(this.menuDragMouseListener);
        }
        if ((this.menuKeyListener = this.createMenuKeyListener(this.menuItem)) != null) {
            this.menuItem.addMenuKeyListener(this.menuKeyListener);
        }
        if ((this.propertyChangeListener = this.createPropertyChangeListener(this.menuItem)) != null) {
            this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected void installKeyboardActions() {
        this.installLazyActionMap();
        this.updateAcceleratorBinding();
    }

    void installLazyActionMap() {
        LazyActionMap.installLazyActionMap(this.menuItem, BasicMenuItemUI.class, this.getPropertyPrefix() + ".actionMap");
    }

    public void uninstallUI(JComponent c) {
        this.menuItem = (JMenuItem)c;
        this.uninstallDefaults();
        this.uninstallComponents(this.menuItem);
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        JComponent p = BasicMenuItemUI.getMenuItemParent(this.menuItem);
        if (p != null) {
            p.putClientProperty(MAX_ARROW_WIDTH, null);
            p.putClientProperty(MAX_CHECK_WIDTH, null);
            p.putClientProperty(MAX_ACC_WIDTH, null);
            p.putClientProperty(MAX_TEXT_WIDTH, null);
            p.putClientProperty(MAX_ICON_WIDTH, null);
            p.putClientProperty(MAX_LABEL_WIDTH, null);
            p.putClientProperty(SwingUtilities2.BASICMENUITEMUI_MAX_TEXT_OFFSET, null);
        }
        this.menuItem = null;
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.menuItem);
        LookAndFeel.installProperty(this.menuItem, "borderPainted", this.oldBorderPainted);
        if (this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(null);
        }
        if (this.arrowIcon instanceof UIResource) {
            this.arrowIcon = null;
        }
        if (this.checkIcon instanceof UIResource) {
            this.checkIcon = null;
        }
    }

    protected void uninstallComponents(JMenuItem menuItem) {
        BasicHTML.updateRenderer(menuItem, "");
    }

    protected void uninstallListeners() {
        if (this.mouseInputListener != null) {
            this.menuItem.removeMouseListener(this.mouseInputListener);
            this.menuItem.removeMouseMotionListener(this.mouseInputListener);
        }
        if (this.menuDragMouseListener != null) {
            this.menuItem.removeMenuDragMouseListener(this.menuDragMouseListener);
        }
        if (this.menuKeyListener != null) {
            this.menuItem.removeMenuKeyListener(this.menuKeyListener);
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
        }
        this.mouseInputListener = null;
        this.menuDragMouseListener = null;
        this.menuKeyListener = null;
        this.propertyChangeListener = null;
        this.handler = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.menuItem, null);
        SwingUtilities.replaceUIInputMap(this.menuItem, 2, null);
    }

    protected MouseInputListener createMouseInputListener(JComponent c) {
        return this.getHandler();
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent c) {
        return this.getHandler();
    }

    protected MenuKeyListener createMenuKeyListener(JComponent c) {
        return null;
    }

    protected PropertyChangeListener createPropertyChangeListener(JComponent c) {
        return this.getHandler();
    }

    Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    InputMap createInputMap(int condition) {
        if (condition == 2) {
            return new ComponentInputMapUIResource(this.menuItem);
        }
        return null;
    }

    void updateAcceleratorBinding() {
        KeyStroke accelerator = this.menuItem.getAccelerator();
        InputMap windowInputMap = SwingUtilities.getUIInputMap(this.menuItem, 2);
        if (windowInputMap != null) {
            windowInputMap.clear();
        }
        if (accelerator != null) {
            if (windowInputMap == null) {
                windowInputMap = this.createInputMap(2);
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, windowInputMap);
            }
            windowInputMap.put(accelerator, "doClick");
        }
    }

    public Dimension getMinimumSize(JComponent c) {
        Dimension d = null;
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            d = this.getPreferredSize(c);
            d.width = (int)((float)d.width - (v.getPreferredSpan(0) - v.getMinimumSpan(0)));
        }
        return d;
    }

    public Dimension getPreferredSize(JComponent c) {
        return this.getPreferredMenuItemSize(c, this.checkIcon, this.arrowIcon, this.defaultTextIconGap);
    }

    public Dimension getMaximumSize(JComponent c) {
        Dimension d = null;
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            d = this.getPreferredSize(c);
            d.width = (int)((float)d.width + (v.getMaximumSpan(0) - v.getPreferredSpan(0)));
        }
        return d;
    }

    private static JComponent getMenuItemParent(JMenuItem mi) {
        Container parent = mi.getParent();
        if (!(!(parent instanceof JComponent) || mi instanceof JMenu && ((JMenu)mi).isTopLevelMenu())) {
            return (JComponent)parent;
        }
        return null;
    }

    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        JMenuItem mi = (JMenuItem)c;
        LayoutInfo li = this.getLayoutInfo(mi, checkIcon, arrowIcon, this.createMaxViewRect(), defaultTextIconGap, this.acceleratorDelimiter, BasicGraphicsUtils.isLeftToRight(mi), this.acceleratorFont, this.useCheckAndArrow(), this.getPropertyPrefix());
        Dimension result = new Dimension();
        result.width = li.leadingGap;
        this.addWidth(li.maxCheckWidth, li.afterCheckIconGap, result);
        if (!li.isTopLevelMenu && li.minTextOffset > 0 && result.width < li.minTextOffset) {
            result.width = li.minTextOffset;
        }
        this.addWidth(li.maxLabelWidth, li.gap, result);
        this.addWidth(li.maxAccWidth, li.gap, result);
        this.addWidth(li.maxArrowWidth, li.gap, result);
        result.height = BasicMenuItemUI.max(li.checkRect.height, li.labelRect.height, li.accRect.height, li.arrowRect.height);
        Insets insets = li.mi.getInsets();
        if (insets != null) {
            result.width += insets.left + insets.right;
            result.height += insets.top + insets.bottom;
        }
        if (result.width % 2 == 0) {
            ++result.width;
        }
        if (result.height % 2 == 0 && Boolean.TRUE != UIManager.get(this.getPropertyPrefix() + ".evenHeight")) {
            ++result.height;
        }
        li.clear();
        return result;
    }

    private Rectangle createMaxViewRect() {
        return new Rectangle(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
    }

    private void addWidth(int width, int gap, Dimension result) {
        if (width > 0) {
            result.width += width + gap;
        }
    }

    private static int max(int ... values) {
        int maxValue = Integer.MIN_VALUE;
        for (int i : values) {
            if (i <= maxValue) continue;
            maxValue = i;
        }
        return maxValue;
    }

    private LayoutInfo getLayoutInfo(JMenuItem mi, Icon checkIcon, Icon arrowIcon, Rectangle viewRect, int gap, String accDelimiter, boolean isLeftToRight, Font acceleratorFont, boolean useCheckAndArrow, String propertyPrefix) {
        this.layoutInfo.reset(mi, checkIcon, arrowIcon, viewRect, gap, accDelimiter, isLeftToRight, acceleratorFont, useCheckAndArrow, propertyPrefix);
        return this.layoutInfo;
    }

    public void update(Graphics g, JComponent c) {
        this.paint(g, c);
    }

    public void paint(Graphics g, JComponent c) {
        this.paintMenuItem(g, c, this.checkIcon, this.arrowIcon, this.selectionBackground, this.selectionForeground, this.defaultTextIconGap);
    }

    protected void paintMenuItem(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        Font holdf = g.getFont();
        Color holdc = g.getColor();
        JMenuItem mi = (JMenuItem)c;
        g.setFont(mi.getFont());
        Rectangle viewRect = new Rectangle(0, 0, mi.getWidth(), mi.getHeight());
        this.applyInsets(viewRect, mi.getInsets());
        LayoutInfo li = this.getLayoutInfo(mi, checkIcon, arrowIcon, viewRect, defaultTextIconGap, this.acceleratorDelimiter, BasicGraphicsUtils.isLeftToRight(mi), this.acceleratorFont, this.useCheckAndArrow(), this.getPropertyPrefix());
        this.layoutMenuItem(li);
        this.paintBackground(g, mi, background);
        this.paintCheckIcon(g, li, holdc, foreground);
        this.paintIcon(g, li, holdc);
        this.paintText(g, li);
        this.paintAccText(g, li);
        this.paintArrowIcon(g, li, foreground);
        g.setColor(holdc);
        g.setFont(holdf);
        li.clear();
    }

    private void paintIcon(Graphics g, LayoutInfo li, Color holdc) {
        if (li.icon != null) {
            Icon icon;
            ButtonModel model = li.mi.getModel();
            if (!model.isEnabled()) {
                icon = li.mi.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                icon = li.mi.getPressedIcon();
                if (icon == null) {
                    icon = li.mi.getIcon();
                }
            } else {
                icon = li.mi.getIcon();
            }
            if (icon != null) {
                icon.paintIcon(li.mi, g, li.iconRect.x, li.iconRect.y);
                g.setColor(holdc);
            }
        }
    }

    private void paintCheckIcon(Graphics g, LayoutInfo li, Color holdc, Color foreground) {
        if (li.checkIcon != null) {
            ButtonModel model = li.mi.getModel();
            if (model.isArmed() || li.mi instanceof JMenu && model.isSelected()) {
                g.setColor(foreground);
            } else {
                g.setColor(holdc);
            }
            if (li.useCheckAndArrow) {
                li.checkIcon.paintIcon(li.mi, g, li.checkRect.x, li.checkRect.y);
            }
            g.setColor(holdc);
        }
    }

    private void paintAccText(Graphics g, LayoutInfo li) {
        if (!li.accText.equals("")) {
            ButtonModel model = li.mi.getModel();
            g.setFont(this.acceleratorFont);
            if (!model.isEnabled()) {
                if (this.disabledForeground != null) {
                    g.setColor(this.disabledForeground);
                    SwingUtilities2.drawString((JComponent)li.mi, g, li.accText, li.accRect.x, li.accRect.y + li.accFm.getAscent());
                } else {
                    g.setColor(li.mi.getBackground().brighter());
                    SwingUtilities2.drawString((JComponent)li.mi, g, li.accText, li.accRect.x, li.accRect.y + li.accFm.getAscent());
                    g.setColor(li.mi.getBackground().darker());
                    SwingUtilities2.drawString((JComponent)li.mi, g, li.accText, li.accRect.x - 1, li.accRect.y + li.accFm.getAscent() - 1);
                }
            } else {
                if (model.isArmed() || li.mi instanceof JMenu && model.isSelected()) {
                    g.setColor(this.acceleratorSelectionForeground);
                } else {
                    g.setColor(this.acceleratorForeground);
                }
                SwingUtilities2.drawString((JComponent)li.mi, g, li.accText, li.accRect.x, li.accRect.y + li.accFm.getAscent());
            }
        }
    }

    private void paintText(Graphics g, LayoutInfo li) {
        if (!li.text.equals("")) {
            if (li.htmlView != null) {
                li.htmlView.paint(g, li.textRect);
            } else {
                this.paintText(g, li.mi, li.textRect, li.text);
            }
        }
    }

    private void paintArrowIcon(Graphics g, LayoutInfo li, Color foreground) {
        if (li.arrowIcon != null) {
            ButtonModel model = li.mi.getModel();
            if (model.isArmed() || li.mi instanceof JMenu && model.isSelected()) {
                g.setColor(foreground);
            }
            if (li.useCheckAndArrow) {
                li.arrowIcon.paintIcon(li.mi, g, li.arrowRect.x, li.arrowRect.y);
            }
        }
    }

    private void applyInsets(Rectangle rect, Insets insets) {
        if (insets != null) {
            rect.x += insets.left;
            rect.y += insets.top;
            rect.width -= insets.right + rect.x;
            rect.height -= insets.bottom + rect.y;
        }
    }

    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        if (menuItem.isOpaque()) {
            if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                g.setColor(bgColor);
                g.fillRect(0, 0, menuWidth, menuHeight);
            } else {
                g.setColor(menuItem.getBackground());
                g.fillRect(0, 0, menuWidth, menuHeight);
            }
            g.setColor(oldColor);
        } else if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
            g.setColor(bgColor);
            g.fillRect(0, 0, menuWidth, menuHeight);
            g.setColor(oldColor);
        }
    }

    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        ButtonModel model = menuItem.getModel();
        FontMetrics fm = SwingUtilities2.getFontMetrics((JComponent)menuItem, g);
        int mnemIndex = menuItem.getDisplayedMnemonicIndex();
        if (!model.isEnabled()) {
            if (UIManager.get("MenuItem.disabledForeground") instanceof Color) {
                g.setColor(UIManager.getColor("MenuItem.disabledForeground"));
                SwingUtilities2.drawStringUnderlineCharAt(menuItem, g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
            } else {
                g.setColor(menuItem.getBackground().brighter());
                SwingUtilities2.drawStringUnderlineCharAt(menuItem, g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
                g.setColor(menuItem.getBackground().darker());
                SwingUtilities2.drawStringUnderlineCharAt(menuItem, g, text, mnemIndex, textRect.x - 1, textRect.y + fm.getAscent() - 1);
            }
        } else {
            if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                g.setColor(this.selectionForeground);
            }
            SwingUtilities2.drawStringUnderlineCharAt(menuItem, g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
        }
    }

    private void layoutMenuItem(LayoutInfo li) {
        li.checkRect.width = li.maxCheckWidth;
        li.accRect.width = li.maxAccWidth;
        li.arrowRect.width = li.maxArrowWidth;
        if (li.isColumnLayout) {
            if (li.isLeftToRight) {
                this.doLTRColumnLayout(li);
            } else {
                this.doRTLColumnLayout(li);
            }
        } else if (li.isLeftToRight) {
            this.doLTRComplexLayout(li);
        } else {
            this.doRTLComplexLayout(li);
        }
        this.alignAccCheckAndArrowVertically(li);
    }

    private void alignAccCheckAndArrowVertically(LayoutInfo li) {
        li.accRect.y = (int)((float)li.labelRect.y + (float)li.labelRect.height / 2.0f - (float)li.accRect.height / 2.0f);
        this.fixVerticalAlignment(li, li.accRect);
        if (li.useCheckAndArrow) {
            li.arrowRect.y = (int)((float)li.labelRect.y + (float)li.labelRect.height / 2.0f - (float)li.arrowRect.height / 2.0f);
            li.checkRect.y = (int)((float)li.labelRect.y + (float)li.labelRect.height / 2.0f - (float)li.checkRect.height / 2.0f);
            this.fixVerticalAlignment(li, li.arrowRect);
            this.fixVerticalAlignment(li, li.checkRect);
        }
    }

    private void fixVerticalAlignment(LayoutInfo li, Rectangle r) {
        int delta = 0;
        if (r.y < li.viewRect.y) {
            delta = li.viewRect.y - r.y;
        } else if (r.y + r.height > li.viewRect.y + li.viewRect.height) {
            delta = li.viewRect.y + li.viewRect.height - r.y - r.height;
        }
        if (delta != 0) {
            li.checkRect.y += delta;
            li.iconRect.y += delta;
            li.textRect.y += delta;
            li.accRect.y += delta;
            li.arrowRect.y += delta;
        }
    }

    private void doLTRColumnLayout(LayoutInfo li) {
        li.iconRect.width = li.maxIconWidth;
        li.textRect.width = li.maxTextWidth;
        this.calcXPositionsL2R(li.viewRect.x, li.leadingGap, li.gap, li.checkRect, li.iconRect, li.textRect);
        if (li.checkRect.width > 0) {
            li.iconRect.x += li.afterCheckIconGap - li.gap;
            li.textRect.x += li.afterCheckIconGap - li.gap;
        }
        this.calcXPositionsR2L(li.viewRect.x + li.viewRect.width, li.gap, li.arrowRect, li.accRect);
        int textOffset = li.textRect.x - li.viewRect.x;
        if (!li.isTopLevelMenu && textOffset < li.minTextOffset) {
            li.textRect.x += li.minTextOffset - textOffset;
        }
        this.fixTextRects(li);
        this.calcTextAndIconYPositions(li);
        li.labelRect = li.textRect.union(li.iconRect);
    }

    private void doLTRComplexLayout(LayoutInfo li) {
        li.labelRect.width = li.maxLabelWidth;
        this.calcXPositionsL2R(li.viewRect.x, li.leadingGap, li.gap, li.checkRect, li.labelRect);
        if (li.checkRect.width > 0) {
            li.labelRect.x += li.afterCheckIconGap - li.gap;
        }
        this.calcXPositionsR2L(li.viewRect.x + li.viewRect.width, li.gap, li.arrowRect, li.accRect);
        int labelOffset = li.labelRect.x - li.viewRect.x;
        if (!li.isTopLevelMenu && labelOffset < li.minTextOffset) {
            li.labelRect.x += li.minTextOffset - labelOffset;
        }
        this.fixAccTextRect(li);
        li.textRect = new Rectangle();
        li.iconRect = new Rectangle();
        SwingUtilities.layoutCompoundLabel(li.mi, li.fm, li.text, li.icon, li.verticalAlignment, li.horizontalAlignment, li.verticalTextPosition, li.horizontalTextPosition, li.labelRect, li.iconRect, li.textRect, li.gap);
    }

    private void doRTLColumnLayout(LayoutInfo li) {
        li.iconRect.width = li.maxIconWidth;
        li.textRect.width = li.maxTextWidth;
        this.calcXPositionsR2L(li.viewRect.x + li.viewRect.width, li.leadingGap, li.gap, li.checkRect, li.iconRect, li.textRect);
        if (li.checkRect.width > 0) {
            li.iconRect.x -= li.afterCheckIconGap - li.gap;
            li.textRect.x -= li.afterCheckIconGap - li.gap;
        }
        this.calcXPositionsL2R(li.viewRect.x, li.gap, li.arrowRect, li.accRect);
        int textOffset = li.viewRect.x + li.viewRect.width - (li.textRect.x + li.textRect.width);
        if (!li.isTopLevelMenu && textOffset < li.minTextOffset) {
            li.textRect.x -= li.minTextOffset - textOffset;
        }
        this.rightAlignAllRects(li);
        this.fixTextRects(li);
        this.calcTextAndIconYPositions(li);
        li.labelRect = li.textRect.union(li.iconRect);
    }

    private void doRTLComplexLayout(LayoutInfo li) {
        li.labelRect.width = li.maxLabelWidth;
        this.calcXPositionsR2L(li.viewRect.x + li.viewRect.width, li.leadingGap, li.gap, li.checkRect, li.labelRect);
        if (li.checkRect.width > 0) {
            li.labelRect.x -= li.afterCheckIconGap - li.gap;
        }
        this.calcXPositionsL2R(li.viewRect.x, li.gap, li.arrowRect, li.accRect);
        int labelOffset = li.viewRect.x + li.viewRect.width - (li.labelRect.x + li.labelRect.width);
        if (!li.isTopLevelMenu && labelOffset < li.minTextOffset) {
            li.labelRect.x -= li.minTextOffset - labelOffset;
        }
        this.rightAlignAllRects(li);
        this.fixAccTextRect(li);
        li.textRect = new Rectangle();
        li.iconRect = new Rectangle();
        SwingUtilities.layoutCompoundLabel(this.menuItem, li.fm, li.text, li.icon, li.verticalAlignment, li.horizontalAlignment, li.verticalTextPosition, li.horizontalTextPosition, li.labelRect, li.iconRect, li.textRect, li.gap);
    }

    private void calcXPositionsL2R(int startXPos, int leadingGap, int gap, Rectangle ... rects) {
        int curXPos = startXPos + leadingGap;
        for (Rectangle rect : rects) {
            rect.x = curXPos;
            if (rect.width <= 0) continue;
            curXPos += rect.width + gap;
        }
    }

    private void calcXPositionsL2R(int startXPos, int gap, Rectangle ... rects) {
        this.calcXPositionsL2R(startXPos, gap, gap, rects);
    }

    private void calcXPositionsR2L(int startXPos, int leadingGap, int gap, Rectangle ... rects) {
        int curXPos = startXPos - leadingGap;
        for (Rectangle rect : rects) {
            rect.x = curXPos - rect.width;
            if (rect.width <= 0) continue;
            curXPos -= rect.width + gap;
        }
    }

    private void calcXPositionsR2L(int startXPos, int gap, Rectangle ... rects) {
        this.calcXPositionsR2L(startXPos, gap, gap, rects);
    }

    private void fixTextRects(LayoutInfo li) {
        int lsb;
        if (li.htmlView == null && (lsb = SwingUtilities2.getLeftSideBearing((JComponent)li.mi, li.fm, li.text)) < 0) {
            li.textRect.x -= lsb;
        }
        this.fixAccTextRect(li);
    }

    private void fixAccTextRect(LayoutInfo li) {
        int lsb = SwingUtilities2.getLeftSideBearing((JComponent)li.mi, li.accFm, li.accText);
        if (lsb < 0) {
            li.accRect.x -= lsb;
        }
    }

    private void calcTextAndIconYPositions(LayoutInfo li) {
        if (li.verticalAlignment == 1) {
            li.textRect.y = (int)((float)li.viewRect.y + (float)li.labelRect.height / 2.0f - (float)li.textRect.height / 2.0f);
            li.iconRect.y = (int)((float)li.viewRect.y + (float)li.labelRect.height / 2.0f - (float)li.iconRect.height / 2.0f);
        } else if (li.verticalAlignment == 0) {
            li.textRect.y = (int)((float)li.viewRect.y + (float)li.viewRect.height / 2.0f - (float)li.textRect.height / 2.0f);
            li.iconRect.y = (int)((float)li.viewRect.y + (float)li.viewRect.height / 2.0f - (float)li.iconRect.height / 2.0f);
        } else if (li.verticalAlignment == 3) {
            li.textRect.y = (int)((float)(li.viewRect.y + li.viewRect.height) - (float)li.labelRect.height / 2.0f - (float)li.textRect.height / 2.0f);
            li.iconRect.y = (int)((float)(li.viewRect.y + li.viewRect.height) - (float)li.labelRect.height / 2.0f - (float)li.iconRect.height / 2.0f);
        }
    }

    private void rightAlignAllRects(LayoutInfo li) {
        li.iconRect.x = li.iconRect.x + li.iconRect.width - li.origIconWidth;
        li.iconRect.width = li.origIconWidth;
        li.textRect.x = li.textRect.x + li.textRect.width - li.origTextWidth;
        li.textRect.width = li.origTextWidth;
        li.accRect.x = li.accRect.x + li.accRect.width - li.origAccWidth;
        li.accRect.width = li.origAccWidth;
        li.checkRect.x = li.checkRect.x + li.checkRect.width - li.origCheckWidth;
        li.checkRect.width = li.origCheckWidth;
        li.arrowRect.x = li.arrowRect.x + li.arrowRect.width - li.origArrowWidth;
        li.arrowRect.width = li.origArrowWidth;
    }

    private boolean useCheckAndArrow() {
        boolean b = true;
        if (this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu()) {
            b = false;
        }
        return b;
    }

    public MenuElement[] getPath() {
        MenuElement[] newPath;
        MenuSelectionManager m = MenuSelectionManager.defaultManager();
        MenuElement[] oldPath = m.getSelectedPath();
        int i = oldPath.length;
        if (i == 0) {
            return new MenuElement[0];
        }
        Container parent = this.menuItem.getParent();
        if (oldPath[i - 1].getComponent() == parent) {
            newPath = new MenuElement[i + 1];
            System.arraycopy(oldPath, 0, newPath, 0, i);
            newPath[i] = this.menuItem;
        } else {
            int j;
            for (j = oldPath.length - 1; j >= 0 && oldPath[j].getComponent() != parent; --j) {
            }
            newPath = new MenuElement[j + 2];
            System.arraycopy(oldPath, 0, newPath, 0, j + 1);
            newPath[j + 1] = this.menuItem;
        }
        return newPath;
    }

    void printMenuElementArray(MenuElement[] path, boolean dumpStack) {
        System.out.println("Path is(");
        int j = path.length;
        for (int i = 0; i < j; ++i) {
            for (int k = 0; k <= i; ++k) {
                System.out.print("  ");
            }
            MenuElement me = path[i];
            if (me instanceof JMenuItem) {
                System.out.println(((JMenuItem)me).getText() + ", ");
                continue;
            }
            if (me == null) {
                System.out.println("NULL , ");
                continue;
            }
            System.out.println("" + me + ", ");
        }
        System.out.println(")");
        if (dumpStack) {
            Thread.dumpStack();
        }
    }

    protected void doClick(MenuSelectionManager msm) {
        if (!this.isInternalFrameSystemMenu()) {
            BasicLookAndFeel.playSound(this.menuItem, this.getPropertyPrefix() + ".commandSound");
        }
        if (msm == null) {
            msm = MenuSelectionManager.defaultManager();
        }
        msm.clearSelectedPath();
        this.menuItem.doClick(0);
    }

    private boolean isInternalFrameSystemMenu() {
        String actionCommand = this.menuItem.getActionCommand();
        return actionCommand == "Close" || actionCommand == "Minimize" || actionCommand == "Restore" || actionCommand == "Maximize";
    }

    class Handler
    implements MenuDragMouseListener,
    MouseInputListener,
    PropertyChangeListener {
        Handler() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            if (!BasicMenuItemUI.this.menuItem.isEnabled()) {
                return;
            }
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            Point p = e.getPoint();
            if (p.x >= 0 && p.x < BasicMenuItemUI.this.menuItem.getWidth() && p.y >= 0 && p.y < BasicMenuItemUI.this.menuItem.getHeight()) {
                BasicMenuItemUI.this.doClick(manager);
            } else {
                manager.processMouseEvent(e);
            }
        }

        public void mouseEntered(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            int modifiers = e.getModifiers();
            if ((modifiers & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(e);
            } else {
                manager.setSelectedPath(BasicMenuItemUI.this.getPath());
            }
        }

        public void mouseExited(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            int modifiers = e.getModifiers();
            if ((modifiers & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(e);
            } else {
                MenuElement[] path = manager.getSelectedPath();
                if (path.length > 1 && path[path.length - 1] == BasicMenuItemUI.this.menuItem) {
                    MenuElement[] newPath = new MenuElement[path.length - 1];
                    int c = path.length - 1;
                    for (int i = 0; i < c; ++i) {
                        newPath[i] = path[i];
                    }
                    manager.setSelectedPath(newPath);
                }
            }
        }

        public void mouseDragged(MouseEvent e) {
            MenuSelectionManager.defaultManager().processMouseEvent(e);
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void menuDragMouseEntered(MenuDragMouseEvent e) {
            MenuSelectionManager manager = e.getMenuSelectionManager();
            MenuElement[] path = e.getPath();
            manager.setSelectedPath(path);
        }

        public void menuDragMouseDragged(MenuDragMouseEvent e) {
            MenuSelectionManager manager = e.getMenuSelectionManager();
            MenuElement[] path = e.getPath();
            manager.setSelectedPath(path);
        }

        public void menuDragMouseExited(MenuDragMouseEvent e) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent e) {
            if (!BasicMenuItemUI.this.menuItem.isEnabled()) {
                return;
            }
            MenuSelectionManager manager = e.getMenuSelectionManager();
            MenuElement[] path = e.getPath();
            Point p = e.getPoint();
            if (p.x >= 0 && p.x < BasicMenuItemUI.this.menuItem.getWidth() && p.y >= 0 && p.y < BasicMenuItemUI.this.menuItem.getHeight()) {
                BasicMenuItemUI.this.doClick(manager);
            } else {
                manager.clearSelectedPath();
            }
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name == "labelFor" || name == "displayedMnemonic" || name == "accelerator") {
                BasicMenuItemUI.this.updateAcceleratorBinding();
            } else if (name == "text" || "font" == name || "foreground" == name) {
                JMenuItem lbl = (JMenuItem)e.getSource();
                String text = lbl.getText();
                BasicHTML.updateRenderer(lbl, text);
            } else if (name == "iconTextGap") {
                BasicMenuItemUI.this.defaultTextIconGap = ((Number)e.getNewValue()).intValue();
            }
        }
    }

    private static class Actions
    extends UIAction {
        private static final String CLICK = "doClick";

        Actions(String key) {
            super(key);
        }

        public void actionPerformed(ActionEvent e) {
            JMenuItem mi = (JMenuItem)e.getSource();
            MenuSelectionManager.defaultManager().clearSelectedPath();
            mi.doClick();
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            BasicMenuItemUI.this.getHandler().mouseClicked(e);
        }

        public void mousePressed(MouseEvent e) {
            BasicMenuItemUI.this.getHandler().mousePressed(e);
        }

        public void mouseReleased(MouseEvent e) {
            BasicMenuItemUI.this.getHandler().mouseReleased(e);
        }

        public void mouseEntered(MouseEvent e) {
            BasicMenuItemUI.this.getHandler().mouseEntered(e);
        }

        public void mouseExited(MouseEvent e) {
            BasicMenuItemUI.this.getHandler().mouseExited(e);
        }

        public void mouseDragged(MouseEvent e) {
            BasicMenuItemUI.this.getHandler().mouseDragged(e);
        }

        public void mouseMoved(MouseEvent e) {
            BasicMenuItemUI.this.getHandler().mouseMoved(e);
        }
    }

    private static class LayoutInfo {
        JMenuItem mi;
        JComponent miParent;
        FontMetrics fm;
        FontMetrics accFm;
        Icon icon;
        Icon checkIcon;
        Icon arrowIcon;
        String text;
        String accText;
        boolean isColumnLayout;
        boolean useCheckAndArrow;
        boolean isLeftToRight;
        boolean isTopLevelMenu;
        View htmlView;
        int verticalAlignment;
        int horizontalAlignment;
        int verticalTextPosition;
        int horizontalTextPosition;
        int gap;
        int leadingGap;
        int afterCheckIconGap;
        int minTextOffset;
        Rectangle viewRect;
        Rectangle iconRect;
        Rectangle textRect;
        Rectangle accRect;
        Rectangle checkRect;
        Rectangle arrowRect;
        Rectangle labelRect;
        int origIconWidth;
        int origTextWidth;
        int origAccWidth;
        int origCheckWidth;
        int origArrowWidth;
        int maxIconWidth;
        int maxTextWidth;
        int maxAccWidth;
        int maxCheckWidth;
        int maxArrowWidth;
        int maxLabelWidth;

        public LayoutInfo() {
        }

        public LayoutInfo(JMenuItem mi, Icon checkIcon, Icon arrowIcon, Rectangle viewRect, int gap, String accDelimiter, boolean isLeftToRight, Font acceleratorFont, boolean useCheckAndArrow, String propertyPrefix) {
            this.reset(mi, checkIcon, arrowIcon, viewRect, gap, accDelimiter, isLeftToRight, acceleratorFont, useCheckAndArrow, propertyPrefix);
        }

        public void reset(JMenuItem mi, Icon checkIcon, Icon arrowIcon, Rectangle viewRect, int gap, String accDelimiter, boolean isLeftToRight, Font acceleratorFont, boolean useCheckAndArrow, String propertyPrefix) {
            this.mi = mi;
            this.miParent = BasicMenuItemUI.getMenuItemParent(mi);
            this.accText = this.getAccText(accDelimiter);
            this.verticalAlignment = mi.getVerticalAlignment();
            this.horizontalAlignment = mi.getHorizontalAlignment();
            this.verticalTextPosition = mi.getVerticalTextPosition();
            this.horizontalTextPosition = mi.getHorizontalTextPosition();
            this.useCheckAndArrow = useCheckAndArrow;
            this.fm = mi.getFontMetrics(mi.getFont());
            this.accFm = mi.getFontMetrics(acceleratorFont);
            this.isLeftToRight = isLeftToRight;
            this.isColumnLayout = this.isColumnLayout();
            this.isTopLevelMenu = this.miParent == null;
            this.checkIcon = checkIcon;
            this.icon = this.getIcon(propertyPrefix);
            this.arrowIcon = arrowIcon;
            this.text = mi.getText();
            this.gap = gap;
            this.afterCheckIconGap = this.getAfterCheckIconGap(propertyPrefix);
            this.minTextOffset = this.getMinTextOffset(propertyPrefix);
            this.htmlView = (View)mi.getClientProperty("html");
            this.viewRect = viewRect;
            this.iconRect = new Rectangle();
            this.textRect = new Rectangle();
            this.accRect = new Rectangle();
            this.checkRect = new Rectangle();
            this.arrowRect = new Rectangle();
            this.labelRect = new Rectangle();
            this.calcWidthsAndHeights();
            this.origIconWidth = this.iconRect.width;
            this.origTextWidth = this.textRect.width;
            this.origAccWidth = this.accRect.width;
            this.origCheckWidth = this.checkRect.width;
            this.origArrowWidth = this.arrowRect.width;
            this.calcMaxWidths();
            this.leadingGap = this.getLeadingGap(propertyPrefix);
            this.calcMaxTextOffset();
        }

        public void clear() {
            this.mi = null;
            this.miParent = null;
            this.fm = null;
            this.accFm = null;
            this.icon = null;
            this.checkIcon = null;
            this.arrowIcon = null;
            this.text = null;
            this.accText = null;
            this.htmlView = null;
            this.viewRect = null;
            this.iconRect = null;
            this.textRect = null;
            this.accRect = null;
            this.checkRect = null;
            this.arrowRect = null;
            this.labelRect = null;
        }

        private String getAccText(String acceleratorDelimiter) {
            String accText = "";
            KeyStroke accelerator = this.mi.getAccelerator();
            if (accelerator != null) {
                int keyCode;
                int modifiers = accelerator.getModifiers();
                if (modifiers > 0) {
                    accText = KeyEvent.getKeyModifiersText(modifiers);
                    accText = accText + acceleratorDelimiter;
                }
                accText = (keyCode = accelerator.getKeyCode()) != 0 ? accText + KeyEvent.getKeyText(keyCode) : accText + accelerator.getKeyChar();
            }
            return accText;
        }

        private Icon getIcon(String propertyPrefix) {
            Icon icon = null;
            MenuItemCheckIconFactory iconFactory = (MenuItemCheckIconFactory)UIManager.get(propertyPrefix + ".checkIconFactory");
            if (!(this.isColumnLayout && this.useCheckAndArrow && iconFactory != null && iconFactory.isCompatible(this.checkIcon, propertyPrefix))) {
                icon = this.mi.getIcon();
            }
            return icon;
        }

        private int getMinTextOffset(String propertyPrefix) {
            int minimumTextOffset = 0;
            Object minimumTextOffsetObject = UIManager.get(propertyPrefix + ".minimumTextOffset");
            if (minimumTextOffsetObject instanceof Integer) {
                minimumTextOffset = (Integer)minimumTextOffsetObject;
            }
            return minimumTextOffset;
        }

        private int getAfterCheckIconGap(String propertyPrefix) {
            int afterCheckIconGap = this.gap;
            Object afterCheckIconGapObject = UIManager.get(propertyPrefix + ".afterCheckIconGap");
            if (afterCheckIconGapObject instanceof Integer) {
                afterCheckIconGap = (Integer)afterCheckIconGapObject;
            }
            return afterCheckIconGap;
        }

        private int getLeadingGap(String propertyPrefix) {
            if (this.maxCheckWidth > 0) {
                return this.getCheckOffset(propertyPrefix);
            }
            return this.gap;
        }

        private int getCheckOffset(String propertyPrefix) {
            int checkIconOffset = this.gap;
            Object checkIconOffsetObject = UIManager.get(propertyPrefix + ".checkIconOffset");
            if (checkIconOffsetObject instanceof Integer) {
                checkIconOffset = (Integer)checkIconOffsetObject;
            }
            return checkIconOffset;
        }

        private void calcWidthsAndHeights() {
            if (this.icon != null) {
                this.iconRect.width = this.icon.getIconWidth();
                this.iconRect.height = this.icon.getIconHeight();
            }
            if (!this.accText.equals("")) {
                this.accRect.width = SwingUtilities2.stringWidth(this.mi, this.accFm, this.accText);
                this.accRect.height = this.accFm.getHeight();
            }
            if (this.text == null) {
                this.text = "";
            } else if (!this.text.equals("")) {
                if (this.htmlView != null) {
                    this.textRect.width = (int)this.htmlView.getPreferredSpan(0);
                    this.textRect.height = (int)this.htmlView.getPreferredSpan(1);
                } else {
                    this.textRect.width = SwingUtilities2.stringWidth(this.mi, this.fm, this.text);
                    this.textRect.height = this.fm.getHeight();
                }
            }
            if (this.useCheckAndArrow) {
                if (this.checkIcon != null) {
                    this.checkRect.width = this.checkIcon.getIconWidth();
                    this.checkRect.height = this.checkIcon.getIconHeight();
                }
                if (this.arrowIcon != null) {
                    this.arrowRect.width = this.arrowIcon.getIconWidth();
                    this.arrowRect.height = this.arrowIcon.getIconHeight();
                }
            }
            if (this.isColumnLayout) {
                this.labelRect.width = this.iconRect.width + this.textRect.width + this.gap;
                this.labelRect.height = BasicMenuItemUI.max(new int[]{this.checkRect.height, this.iconRect.height, this.textRect.height, this.accRect.height, this.arrowRect.height});
            } else {
                this.textRect = new Rectangle();
                this.iconRect = new Rectangle();
                SwingUtilities.layoutCompoundLabel(this.mi, this.fm, this.text, this.icon, this.verticalAlignment, this.horizontalAlignment, this.verticalTextPosition, this.horizontalTextPosition, this.viewRect, this.iconRect, this.textRect, this.gap);
                this.labelRect = this.iconRect.union(this.textRect);
            }
        }

        private void calcMaxWidths() {
            this.maxCheckWidth = this.calcMaxValue(MAX_CHECK_WIDTH, this.checkRect.width);
            this.maxArrowWidth = this.calcMaxValue(MAX_ARROW_WIDTH, this.arrowRect.width);
            this.maxAccWidth = this.calcMaxValue(MAX_ACC_WIDTH, this.accRect.width);
            if (this.isColumnLayout) {
                this.maxIconWidth = this.calcMaxValue(MAX_ICON_WIDTH, this.iconRect.width);
                this.maxTextWidth = this.calcMaxValue(MAX_TEXT_WIDTH, this.textRect.width);
                int curGap = this.gap;
                if (this.maxIconWidth == 0 || this.maxTextWidth == 0) {
                    curGap = 0;
                }
                this.maxLabelWidth = this.calcMaxValue(MAX_LABEL_WIDTH, this.maxIconWidth + this.maxTextWidth + curGap);
            } else {
                this.maxIconWidth = this.getParentIntProperty(MAX_ICON_WIDTH);
                this.maxLabelWidth = this.calcMaxValue(MAX_LABEL_WIDTH, this.labelRect.width);
                int candidateTextWidth = this.maxLabelWidth - this.maxIconWidth;
                if (this.maxIconWidth > 0) {
                    candidateTextWidth -= this.gap;
                }
                this.maxTextWidth = this.calcMaxValue(MAX_TEXT_WIDTH, candidateTextWidth);
            }
        }

        private int calcMaxValue(Object propertyName, int value) {
            int maxValue = this.getParentIntProperty(propertyName);
            if (value > maxValue) {
                if (this.miParent != null) {
                    this.miParent.putClientProperty(propertyName, value);
                }
                return value;
            }
            return maxValue;
        }

        private int getParentIntProperty(Object propertyName) {
            Object value = null;
            if (this.miParent != null) {
                value = this.miParent.getClientProperty(propertyName);
            }
            if (value == null || !(value instanceof Integer)) {
                value = 0;
            }
            return (Integer)value;
        }

        private boolean isColumnLayout() {
            return LayoutInfo.isColumnLayout(this.isLeftToRight, this.horizontalAlignment, this.horizontalTextPosition, this.verticalTextPosition);
        }

        public static boolean isColumnLayout(boolean isLeftToRight, JMenuItem mi) {
            assert (mi != null);
            return LayoutInfo.isColumnLayout(isLeftToRight, mi.getHorizontalAlignment(), mi.getHorizontalTextPosition(), mi.getVerticalTextPosition());
        }

        public static boolean isColumnLayout(boolean isLeftToRight, int horizontalAlignment, int horizontalTextPosition, int verticalTextPosition) {
            if (verticalTextPosition != 0) {
                return false;
            }
            if (isLeftToRight) {
                if (horizontalAlignment != 10 && horizontalAlignment != 2) {
                    return false;
                }
                if (horizontalTextPosition != 11 && horizontalTextPosition != 4) {
                    return false;
                }
            } else {
                if (horizontalAlignment != 10 && horizontalAlignment != 4) {
                    return false;
                }
                if (horizontalTextPosition != 11 && horizontalTextPosition != 2) {
                    return false;
                }
            }
            return true;
        }

        private void calcMaxTextOffset() {
            if (!this.isColumnLayout || !this.isLeftToRight) {
                return;
            }
            int offset = this.viewRect.x + this.leadingGap + this.maxCheckWidth + this.afterCheckIconGap + this.maxIconWidth + this.gap;
            if (this.maxCheckWidth == 0) {
                offset -= this.afterCheckIconGap;
            }
            if (this.maxIconWidth == 0) {
                offset -= this.gap;
            }
            if (offset < this.minTextOffset) {
                offset = this.minTextOffset;
            }
            this.calcMaxValue(SwingUtilities2.BASICMENUITEMUI_MAX_TEXT_OFFSET, offset);
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append(super.toString()).append("\n");
            result.append("accFm = ").append(this.accFm).append("\n");
            result.append("accRect = ").append(this.accRect).append("\n");
            result.append("accText = ").append(this.accText).append("\n");
            result.append("afterCheckIconGap = ").append(this.afterCheckIconGap).append("\n");
            result.append("arrowIcon = ").append(this.arrowIcon).append("\n");
            result.append("arrowRect = ").append(this.arrowRect).append("\n");
            result.append("checkIcon = ").append(this.checkIcon).append("\n");
            result.append("checkRect = ").append(this.checkRect).append("\n");
            result.append("fm = ").append(this.fm).append("\n");
            result.append("gap = ").append(this.gap).append("\n");
            result.append("horizontalAlignment = ").append(this.horizontalAlignment).append("\n");
            result.append("horizontalTextPosition = ").append(this.horizontalTextPosition).append("\n");
            result.append("htmlView = ").append(this.htmlView).append("\n");
            result.append("icon = ").append(this.icon).append("\n");
            result.append("iconRect = ").append(this.iconRect).append("\n");
            result.append("isColumnLayout = ").append(this.isColumnLayout).append("\n");
            result.append("isLeftToRight = ").append(this.isLeftToRight).append("\n");
            result.append("isTopLevelMenu = ").append(this.isTopLevelMenu).append("\n");
            result.append("labelRect = ").append(this.labelRect).append("\n");
            result.append("leadingGap = ").append(this.leadingGap).append("\n");
            result.append("maxAccWidth = ").append(this.maxAccWidth).append("\n");
            result.append("maxArrowWidth = ").append(this.maxArrowWidth).append("\n");
            result.append("maxCheckWidth = ").append(this.maxCheckWidth).append("\n");
            result.append("maxIconWidth = ").append(this.maxIconWidth).append("\n");
            result.append("maxLabelWidth = ").append(this.maxLabelWidth).append("\n");
            result.append("maxTextWidth = ").append(this.maxTextWidth).append("\n");
            result.append("maxTextOffset = ").append(this.getParentIntProperty(SwingUtilities2.BASICMENUITEMUI_MAX_TEXT_OFFSET)).append("\n");
            result.append("mi = ").append(this.mi).append("\n");
            result.append("minTextOffset = ").append(this.minTextOffset).append("\n");
            result.append("miParent = ").append(this.miParent).append("\n");
            result.append("origAccWidth = ").append(this.origAccWidth).append("\n");
            result.append("origArrowWidth = ").append(this.origArrowWidth).append("\n");
            result.append("origCheckWidth = ").append(this.origCheckWidth).append("\n");
            result.append("origIconWidth = ").append(this.origIconWidth).append("\n");
            result.append("origTextWidth = ").append(this.origTextWidth).append("\n");
            result.append("text = ").append(this.text).append("\n");
            result.append("textRect = ").append(this.textRect).append("\n");
            result.append("useCheckAndArrow = ").append(this.useCheckAndArrow).append("\n");
            result.append("verticalAlignment = ").append(this.verticalAlignment).append("\n");
            result.append("verticalTextPosition = ").append(this.verticalTextPosition).append("\n");
            result.append("viewRect = ").append(this.viewRect).append("\n");
            return result.toString();
        }
    }
}

