/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabularType
extends OpenType<TabularData> {
    static final long serialVersionUID = 6554071860220659261L;
    private CompositeType rowType;
    private List<String> indexNames;
    private transient Integer myHashCode = null;
    private transient String myToString = null;

    public TabularType(String typeName, String description, CompositeType rowType, String[] indexNames) throws OpenDataException {
        super(TabularData.class.getName(), typeName, description, false);
        if (rowType == null) {
            throw new IllegalArgumentException("Argument rowType cannot be null.");
        }
        TabularType.checkForNullElement(indexNames, "indexNames");
        TabularType.checkForEmptyString(indexNames, "indexNames");
        for (int i = 0; i < indexNames.length; ++i) {
            if (rowType.containsKey(indexNames[i])) continue;
            throw new OpenDataException("Argument's element value indexNames[" + i + "]=\"" + indexNames[i] + "\" is not a valid item name for rowType.");
        }
        this.rowType = rowType;
        ArrayList<String> tmpList = new ArrayList<String>(indexNames.length + 1);
        for (int i = 0; i < indexNames.length; ++i) {
            tmpList.add(indexNames[i]);
        }
        this.indexNames = Collections.unmodifiableList(tmpList);
    }

    private static void checkForNullElement(Object[] arg, String argName) {
        if (arg == null || arg.length == 0) {
            throw new IllegalArgumentException("Argument " + argName + "[] cannot be null or empty.");
        }
        for (int i = 0; i < arg.length; ++i) {
            if (arg[i] != null) continue;
            throw new IllegalArgumentException("Argument's element " + argName + "[" + i + "] cannot be null.");
        }
    }

    private static void checkForEmptyString(String[] arg, String argName) {
        for (int i = 0; i < arg.length; ++i) {
            if (!arg[i].trim().equals("")) continue;
            throw new IllegalArgumentException("Argument's element " + argName + "[" + i + "] cannot be an empty string.");
        }
    }

    public CompositeType getRowType() {
        return this.rowType;
    }

    public List<String> getIndexNames() {
        return this.indexNames;
    }

    @Override
    public boolean isValue(Object obj) {
        if (!(obj instanceof TabularData)) {
            return false;
        }
        TabularData value = (TabularData)obj;
        TabularType valueType = value.getTabularType();
        return this.isAssignableFrom((OpenType)valueType);
    }

    @Override
    boolean isAssignableFrom(OpenType ot) {
        if (!(ot instanceof TabularType)) {
            return false;
        }
        TabularType tt = (TabularType)ot;
        if (!this.getTypeName().equals(tt.getTypeName()) || !((Object)this.getIndexNames()).equals(tt.getIndexNames())) {
            return false;
        }
        return this.getRowType().isAssignableFrom((OpenType)tt.getRowType());
    }

    @Override
    public boolean equals(Object obj) {
        TabularType other;
        if (obj == null) {
            return false;
        }
        try {
            other = (TabularType)obj;
        }
        catch (ClassCastException e) {
            return false;
        }
        if (!this.getTypeName().equals(other.getTypeName())) {
            return false;
        }
        if (!this.rowType.equals(other.rowType)) {
            return false;
        }
        return ((Object)this.indexNames).equals(other.indexNames);
    }

    @Override
    public int hashCode() {
        if (this.myHashCode == null) {
            int value = 0;
            value += this.getTypeName().hashCode();
            value += this.rowType.hashCode();
            Iterator<String> k = this.indexNames.iterator();
            while (k.hasNext()) {
                value += k.next().hashCode();
            }
            this.myHashCode = new Integer(value);
        }
        return this.myHashCode;
    }

    @Override
    public String toString() {
        if (this.myToString == null) {
            StringBuilder result = new StringBuilder().append(this.getClass().getName()).append("(name=").append(this.getTypeName()).append(",rowType=").append(this.rowType.toString()).append(",indexNames=(");
            int i = 0;
            Iterator<String> k = this.indexNames.iterator();
            while (k.hasNext()) {
                if (i > 0) {
                    result.append(",");
                }
                result.append(k.next().toString());
                ++i;
            }
            result.append("))");
            this.myToString = result.toString();
        }
        return this.myToString;
    }
}

