/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.messaging.saaj.packaging.mime.MessagingException;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.ContentType;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.InternetHeaders;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.ParseException;
import com.sun.xml.internal.ws.message.stream.StreamAttachment;
import com.sun.xml.internal.ws.util.ASCIIUtility;
import com.sun.xml.internal.ws.util.ByteArrayBuffer;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MimeMultipartParser {
    private final InputStream in;
    private final String start;
    private final byte[] boundaryBytes;
    private final BitSet lastPartFound = new BitSet(1);
    private int b = 0;
    private final int[] bcs = new int[256];
    private int[] gss;
    private static final int BUFFER_SIZE = 4096;
    private byte[] buffer = new byte[4096];
    private byte[] prevBuffer = new byte[4096];
    private boolean firstPart = true;
    private final Map<String, StreamAttachment> attachments = new HashMap<String, StreamAttachment>();
    private StreamAttachment root;
    private int cidCounter = 0;

    public MimeMultipartParser(InputStream in, String contentType) {
        try {
            ContentType ct = new ContentType(contentType);
            String boundary = ct.getParameter("boundary");
            if (boundary == null || boundary.equals("")) {
                throw new WebServiceException("MIME boundary parameter not found" + contentType);
            }
            String bnd = "--" + boundary;
            this.boundaryBytes = ASCIIUtility.getBytes(bnd);
            this.start = ct.getParameter("start");
        }
        catch (ParseException e) {
            throw new WebServiceException(e);
        }
        this.in = !in.markSupported() ? new BufferedInputStream(in) : in;
    }

    @Nullable
    public StreamAttachment getRootPart() {
        if (this.root != null) {
            return this.root;
        }
        while (!this.lastBodyPartFound() && this.b != -1 && this.root == null) {
            this.getNextPart();
        }
        return this.root;
    }

    @NotNull
    public Map<String, StreamAttachment> getAttachmentParts() {
        while (!this.lastBodyPartFound() && this.b != -1) {
            this.getNextPart();
        }
        return this.attachments;
    }

    @Nullable
    public StreamAttachment getAttachmentPart(String contentId) throws IOException {
        StreamAttachment streamAttach = this.attachments.get(contentId);
        if (streamAttach != null) {
            return streamAttach;
        }
        while (!this.lastBodyPartFound() && this.b != -1) {
            streamAttach = this.getNextPart();
            String newContentId = streamAttach.getContentId();
            if (newContentId == null || !newContentId.equals(contentId)) continue;
            return streamAttach;
        }
        return null;
    }

    private StreamAttachment getNextPart() {
        assert (!this.lastBodyPartFound());
        try {
            String mimeContentId;
            InternetHeaders ih;
            String[] contentTypes;
            if (this.firstPart) {
                this.compileBoundaryPattern();
                if (!this.skipPreamble()) {
                    throw new WebServiceException("Missing Start Boundary, or boundary does not start on a new line");
                }
            }
            String contentType = (contentTypes = (ih = new InternetHeaders(this.in)).getHeader("content-type")) != null ? contentTypes[0] : "application/octet-stream";
            String[] contentIds = ih.getHeader("content-id");
            String contentId = mimeContentId = contentIds != null ? contentIds[0] : null;
            if (mimeContentId != null && mimeContentId.length() > 2 && contentId.charAt(0) == '<') {
                contentId = mimeContentId.substring(1, mimeContentId.length() - 1);
            }
            ByteArrayBuffer bos = new ByteArrayBuffer();
            this.b = this.readBody(bos);
            StreamAttachment as = new StreamAttachment(bos, contentId, contentType);
            if (this.start == null && this.firstPart) {
                this.root = as;
            } else if (mimeContentId != null && this.start != null && this.start.equals(mimeContentId)) {
                this.root = as;
            } else if (contentId != null) {
                this.attachments.put(contentId, as);
            } else {
                ++this.cidCounter;
                this.attachments.put("" + this.cidCounter, as);
            }
            this.firstPart = false;
            return as;
        }
        catch (IOException ioe) {
            throw new WebServiceException(ioe);
        }
        catch (MessagingException me) {
            throw new WebServiceException(me);
        }
    }

    private int readBody(ByteArrayBuffer baos) throws IOException {
        if (!this.findMimeBody(baos)) {
            throw new WebServiceException("Missing boundary delimitier ");
        }
        return this.b;
    }

    private boolean findMimeBody(ByteArrayBuffer out) throws IOException {
        int l = this.boundaryBytes.length;
        int lx = l - 1;
        int s = 0;
        boolean first = true;
        BitSet eof = new BitSet(1);
        while (true) {
            int i;
            int bufferLength;
            this.in.mark(l);
            if (!first) {
                byte[] tmp = this.prevBuffer;
                this.prevBuffer = this.buffer;
                this.buffer = tmp;
            }
            if ((bufferLength = this.readNext(this.in, l, eof)) == -1) {
                this.b = -1;
                if (s == l) {
                    out.write(this.prevBuffer, 0, s);
                }
                return true;
            }
            if (bufferLength < l) {
                out.write(this.buffer, 0, bufferLength);
                this.b = -1;
                return true;
            }
            for (i = lx; i >= 0 && this.buffer[i] == this.boundaryBytes[i]; --i) {
            }
            if (i < 0) {
                if (s > 0) {
                    if (s <= 2) {
                        String crlf = new String(this.prevBuffer, 0, s);
                        if (!"\n".equals(crlf) && !"\r\n".equals(crlf)) {
                            throw new WebServiceException("Boundary characters encountered in part Body without a preceeding CRLF");
                        }
                    } else if (s > 2) {
                        if (this.prevBuffer[s - 2] == 13 && this.prevBuffer[s - 1] == 10) {
                            out.write(this.prevBuffer, 0, s - 2);
                        } else if (this.prevBuffer[s - 1] == 10) {
                            out.write(this.prevBuffer, 0, s - 1);
                        } else {
                            throw new WebServiceException("Boundary characters encountered in part Body without a preceeding CRLF");
                        }
                    }
                }
                if (!this.skipLWSPAndCRLF(this.in)) {
                    // empty if block
                }
                return true;
            }
            if (s > 0) {
                if (this.prevBuffer[s - 1] == 13) {
                    if (this.buffer[0] == 10) {
                        int j;
                        for (j = lx - 1; j > 0 && this.buffer[j + 1] == this.boundaryBytes[j]; --j) {
                        }
                        if (j == 0) {
                            out.write(this.prevBuffer, 0, s - 1);
                        } else {
                            out.write(this.prevBuffer, 0, s);
                        }
                    } else {
                        out.write(this.prevBuffer, 0, s);
                    }
                } else {
                    out.write(this.prevBuffer, 0, s);
                }
            }
            s = Math.max(i + 1 - this.bcs[this.buffer[i] & 0x7F], this.gss[i]);
            this.in.reset();
            this.in.skip(s);
            if (!first) continue;
            first = false;
        }
    }

    private boolean lastBodyPartFound() {
        return this.lastPartFound.get(0);
    }

    private void compileBoundaryPattern() {
        int i;
        int l = this.boundaryBytes.length;
        for (i = 0; i < l; ++i) {
            this.bcs[this.boundaryBytes[i]] = i + 1;
        }
        this.gss = new int[l];
        block1: for (i = l; i > 0; --i) {
            int j;
            for (j = l - 1; j >= i; --j) {
                if (this.boundaryBytes[j] != this.boundaryBytes[j - i]) continue block1;
                this.gss[j - 1] = i;
            }
            while (j > 0) {
                this.gss[--j] = i;
            }
        }
        this.gss[l - 1] = 1;
    }

    private boolean skipPreamble() throws IOException {
        if (!this.findBoundary()) {
            return false;
        }
        if (this.lastPartFound.get(0)) {
            throw new WebServiceException("Found closing boundary delimiter while trying to skip preamble");
        }
        return true;
    }

    private boolean findBoundary() throws IOException {
        int l = this.boundaryBytes.length;
        int lx = l - 1;
        BitSet eof = new BitSet(1);
        while (true) {
            int i;
            this.in.mark(l);
            this.readNext(this.in, l, eof);
            if (eof.get(0)) {
                return false;
            }
            for (i = lx; i >= 0 && this.buffer[i] == this.boundaryBytes[i]; --i) {
            }
            if (i < 0) {
                if (!this.skipLWSPAndCRLF(this.in)) {
                    throw new WebServiceException("Boundary does not terminate with CRLF");
                }
                return true;
            }
            int s = Math.max(i + 1 - this.bcs[this.buffer[i] & 0x7F], this.gss[i]);
            this.in.reset();
            this.in.skip(s);
        }
    }

    private boolean skipLWSPAndCRLF(InputStream is) throws IOException {
        this.b = is.read();
        if (this.b == 10) {
            return true;
        }
        if (this.b == 13) {
            this.b = is.read();
            if (this.b == 10) {
                return true;
            }
            throw new WebServiceException("transport padding after a Mime Boundary  should end in a CRLF, found CR only");
        }
        if (this.b == 45) {
            this.b = is.read();
            if (this.b != 45) {
                throw new WebServiceException("Unexpected singular '-' character after Mime Boundary");
            }
            this.lastPartFound.flip(0);
            this.b = is.read();
        }
        while (this.b != -1 && (this.b == 32 || this.b == 9)) {
            this.b = is.read();
            if (this.b != 13) continue;
            this.b = is.read();
            if (this.b != 10) continue;
            return true;
        }
        if (this.b == -1) {
            if (!this.lastPartFound.get(0)) {
                throw new WebServiceException("End of Multipart Stream before encountering  closing boundary delimiter");
            }
            return true;
        }
        return false;
    }

    private int readNext(InputStream is, int patternLength, BitSet eof) throws IOException {
        int bufferLength = is.read(this.buffer, 0, patternLength);
        if (bufferLength == -1) {
            eof.flip(0);
        } else if (bufferLength < patternLength) {
            int i;
            for (i = bufferLength; i < patternLength; ++i) {
                int temp = is.read();
                if (temp == -1) {
                    eof.flip(0);
                    break;
                }
                this.buffer[i] = (byte)temp;
            }
            bufferLength = i;
        }
        return bufferLength;
    }
}

