/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.InetAddressAcl;
import com.sun.jmx.snmp.SnmpDefinitions;
import com.sun.jmx.snmp.SnmpMessage;
import com.sun.jmx.snmp.SnmpPduBulk;
import com.sun.jmx.snmp.SnmpPduFactory;
import com.sun.jmx.snmp.SnmpPduPacket;
import com.sun.jmx.snmp.SnmpPduRequest;
import com.sun.jmx.snmp.SnmpPduTrap;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpTooBigException;
import com.sun.jmx.snmp.SnmpValue;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.SnmpVarBindList;
import com.sun.jmx.snmp.agent.SnmpMibAgent;
import com.sun.jmx.snmp.agent.SnmpUserDataFactory;
import com.sun.jmx.snmp.daemon.ClientHandler;
import com.sun.jmx.snmp.daemon.SnmpAdaptorServer;
import com.sun.jmx.snmp.daemon.SnmpMibTree;
import com.sun.jmx.snmp.daemon.SnmpSubBulkRequestHandler;
import com.sun.jmx.snmp.daemon.SnmpSubNextRequestHandler;
import com.sun.jmx.snmp.daemon.SnmpSubRequestHandler;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import javax.management.MBeanServer;
import javax.management.ObjectName;

class SnmpRequestHandler
extends ClientHandler
implements SnmpDefinitions {
    private transient DatagramSocket socket = null;
    private transient DatagramPacket packet = null;
    private transient Vector mibs = null;
    private transient Hashtable<SnmpMibAgent, SnmpSubRequestHandler> subs = null;
    private transient SnmpMibTree root;
    private transient Object ipacl = null;
    private transient SnmpPduFactory pduFactory = null;
    private transient SnmpUserDataFactory userDataFactory = null;
    private transient SnmpAdaptorServer adaptor = null;
    private static final String InterruptSysCallMsg = "Interrupted system call";
    private static final SnmpStatusException noSuchNameException = new SnmpStatusException(10);

    public SnmpRequestHandler(SnmpAdaptorServer server, int id, DatagramSocket s, DatagramPacket p, SnmpMibTree tree, Vector m, Object a, SnmpPduFactory factory, SnmpUserDataFactory dataFactory, MBeanServer f, ObjectName n) {
        super(server, id, f, n);
        this.adaptor = server;
        this.socket = s;
        this.packet = p;
        this.root = tree;
        this.mibs = (Vector)m.clone();
        this.subs = new Hashtable(this.mibs.size());
        this.ipacl = a;
        this.pduFactory = factory;
        this.userDataFactory = dataFactory;
    }

    public void doRun() {
        block11: {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "doRun", "Packet received:\n" + SnmpMessage.dumpHexBuffer(this.packet.getData(), 0, this.packet.getLength()));
            }
            DatagramPacket respPacket = this.makeResponsePacket(this.packet);
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER) && respPacket != null) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "doRun", "Packet to be sent:\n" + SnmpMessage.dumpHexBuffer(respPacket.getData(), 0, respPacket.getLength()));
            }
            if (respPacket != null) {
                try {
                    this.socket.send(respPacket);
                }
                catch (SocketException e) {
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                        if (e.getMessage().equals(InterruptSysCallMsg)) {
                            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "doRun", "interrupted");
                        } else {
                            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "doRun", "I/O exception", e);
                        }
                    }
                }
                catch (InterruptedIOException e) {
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "doRun", "interrupted");
                    }
                }
                catch (Exception e) {
                    if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) break block11;
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "doRun", "failure when sending response", e);
                }
            }
        }
    }

    private DatagramPacket makeResponsePacket(DatagramPacket reqPacket) {
        DatagramPacket respPacket = null;
        SnmpMessage reqMsg = new SnmpMessage();
        try {
            reqMsg.decodeMessage(reqPacket.getData(), reqPacket.getLength());
            reqMsg.address = reqPacket.getAddress();
            reqMsg.port = reqPacket.getPort();
        }
        catch (SnmpStatusException x) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "makeResponsePacket", "packet decoding failed", x);
            }
            reqMsg = null;
            ((SnmpAdaptorServer)this.adaptorServer).incSnmpInASNParseErrs(1);
        }
        SnmpMessage respMsg = null;
        if (reqMsg != null) {
            respMsg = this.makeResponseMessage(reqMsg);
        }
        if (respMsg != null) {
            try {
                reqPacket.setLength(respMsg.encodeMessage(reqPacket.getData()));
                respPacket = reqPacket;
            }
            catch (SnmpTooBigException x) {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "makeResponsePacket", "response message is too big");
                }
                try {
                    respMsg = this.newTooBigMessage(reqMsg);
                    reqPacket.setLength(respMsg.encodeMessage(reqPacket.getData()));
                    respPacket = reqPacket;
                }
                catch (SnmpTooBigException xx) {
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "makeResponsePacket", "'too big' is 'too big' !!!");
                    }
                    this.adaptor.incSnmpSilentDrops(1);
                }
            }
        }
        return respPacket;
    }

    private SnmpMessage makeResponseMessage(SnmpMessage reqMsg) {
        Object userData;
        SnmpPduPacket reqPdu;
        SnmpMessage respMsg;
        block31: {
            respMsg = null;
            reqPdu = null;
            userData = null;
            try {
                reqPdu = (SnmpPduPacket)this.pduFactory.decodeSnmpPdu(reqMsg);
                if (reqPdu != null && this.userDataFactory != null) {
                    userData = this.userDataFactory.allocateUserData(reqPdu);
                }
            }
            catch (SnmpStatusException x) {
                reqPdu = null;
                SnmpAdaptorServer snmpServer = (SnmpAdaptorServer)this.adaptorServer;
                snmpServer.incSnmpInASNParseErrs(1);
                if (x.getStatus() == 221) {
                    snmpServer.incSnmpInBadVersions(1);
                }
                if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) break block31;
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "makeResponseMessage", "message decoding failed", x);
            }
        }
        SnmpPduPacket respPdu = null;
        if (reqPdu != null) {
            respPdu = this.makeResponsePdu(reqPdu, userData);
            try {
                if (this.userDataFactory != null) {
                    this.userDataFactory.releaseUserData(userData, respPdu);
                }
            }
            catch (SnmpStatusException x) {
                respPdu = null;
            }
        }
        if (respPdu != null) {
            try {
                respMsg = (SnmpMessage)this.pduFactory.encodeSnmpPdu(respPdu, this.packet.getData().length);
            }
            catch (SnmpStatusException x) {
                respMsg = null;
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "makeResponseMessage", "failure when encoding the response message", x);
                }
            }
            catch (SnmpTooBigException x) {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "makeResponseMessage", "response message is too big");
                }
                try {
                    if (this.packet.getData().length <= 32) {
                        throw x;
                    }
                    int pos = x.getVarBindCount();
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "makeResponseMessage", "fail on element" + pos);
                    }
                    int old = 0;
                    while (true) {
                        try {
                            respPdu = this.reduceResponsePdu(reqPdu, respPdu, pos);
                            respMsg = (SnmpMessage)this.pduFactory.encodeSnmpPdu(respPdu, this.packet.getData().length - 32);
                        }
                        catch (SnmpTooBigException xx) {
                            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "makeResponseMessage", "response message is still too big");
                            }
                            old = pos;
                            pos = xx.getVarBindCount();
                            if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) continue;
                            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "makeResponseMessage", "fail on element" + pos);
                            if (pos != old) continue;
                            throw xx;
                        }
                        break;
                    }
                }
                catch (SnmpStatusException xx) {
                    respMsg = null;
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "makeResponseMessage", "failure when encoding the response message", xx);
                    }
                }
                catch (SnmpTooBigException xx) {
                    try {
                        respPdu = this.newTooBigPdu(reqPdu);
                        respMsg = (SnmpMessage)this.pduFactory.encodeSnmpPdu(respPdu, this.packet.getData().length);
                    }
                    catch (SnmpTooBigException xxx) {
                        respMsg = null;
                        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "makeResponseMessage", "'too big' is 'too big' !!!");
                        }
                        this.adaptor.incSnmpSilentDrops(1);
                    }
                    catch (Exception xxx) {
                        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "makeResponseMessage", "Got unexpected exception", xxx);
                        }
                        respMsg = null;
                    }
                }
                catch (Exception xx) {
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "makeResponseMessage", "Got unexpected exception", xx);
                    }
                    respMsg = null;
                }
            }
        }
        return respMsg;
    }

    private SnmpPduPacket makeResponsePdu(SnmpPduPacket reqPdu, Object userData) {
        SnmpPduPacket respPdu;
        block14: {
            SnmpAdaptorServer snmpServer = (SnmpAdaptorServer)this.adaptorServer;
            respPdu = null;
            snmpServer.updateRequestCounters(reqPdu.type);
            if (reqPdu.varBindList != null) {
                snmpServer.updateVarCounters(reqPdu.type, reqPdu.varBindList.length);
            }
            if (this.checkPduType(reqPdu)) {
                respPdu = this.checkAcl(reqPdu);
                if (respPdu == null) {
                    if (this.mibs.size() < 1) {
                        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "makeResponsePdu", "Request " + reqPdu.requestId + " received but no MIB registered.");
                        }
                        return this.makeNoMibErrorPdu((SnmpPduRequest)reqPdu, userData);
                    }
                    switch (reqPdu.type) {
                        case 1: 
                        case 2: 
                        case 4: {
                            respPdu = this.makeGetSetResponsePdu((SnmpPduRequest)reqPdu, userData);
                            break;
                        }
                        case 223: {
                            respPdu = this.makeGetBulkResponsePdu((SnmpPduBulk)reqPdu, userData);
                        }
                    }
                } else {
                    if (!snmpServer.getAuthRespEnabled()) {
                        respPdu = null;
                    }
                    if (snmpServer.getAuthTrapEnabled()) {
                        try {
                            snmpServer.snmpV1Trap(SnmpPduTrap.trapAuthenticationFailure, 0, new SnmpVarBindList());
                        }
                        catch (Exception x) {
                            if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) break block14;
                            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "makeResponsePdu", "Failure when sending authentication trap", x);
                        }
                    }
                }
            }
        }
        return respPdu;
    }

    SnmpPduPacket makeErrorVarbindPdu(SnmpPduPacket req, int statusTag) {
        SnmpVarBind[] vblist = req.varBindList;
        int length = vblist.length;
        switch (statusTag) {
            case 55: {
                for (int i = 0; i < length; ++i) {
                    vblist[i].value = SnmpVarBind.endOfMibView;
                }
                break;
            }
            case 33: {
                for (int i = 0; i < length; ++i) {
                    vblist[i].value = SnmpVarBind.noSuchObject;
                }
                break;
            }
            case 44: {
                for (int i = 0; i < length; ++i) {
                    vblist[i].value = SnmpVarBind.noSuchInstance;
                }
                break;
            }
            default: {
                return this.newErrorResponsePdu(req, 0, 1);
            }
        }
        return this.newValidResponsePdu(req, vblist);
    }

    SnmpPduPacket makeNoMibErrorPdu(SnmpPduRequest req, Object userData) {
        if (req.version == 330) {
            return this.newErrorResponsePdu(req, 10, 1);
        }
        if (req.version == 220) {
            switch (req.type) {
                case 3: 
                case 4: {
                    return this.newErrorResponsePdu(req, 20, 1);
                }
                case 1: {
                    return this.makeErrorVarbindPdu(req, 33);
                }
                case 2: 
                case 8: {
                    return this.makeErrorVarbindPdu(req, 55);
                }
            }
        }
        return this.newErrorResponsePdu(req, 0, 1);
    }

    private SnmpPduPacket makeGetSetResponsePdu(SnmpPduRequest req, Object userData) {
        if (req.varBindList == null) {
            return this.newValidResponsePdu(req, null);
        }
        this.splitRequest(req);
        int nbSubRequest = this.subs.size();
        if (nbSubRequest == 1) {
            return this.turboProcessingGetSet(req, userData);
        }
        SnmpPduPacket result = this.executeSubRequest(req, userData);
        if (result != null) {
            return result;
        }
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "makeGetSetResponsePdu", "Build the unified response for request " + req.requestId);
        }
        return this.mergeResponses(req);
    }

    private SnmpPduPacket executeSubRequest(SnmpPduPacket req, Object userData) {
        SnmpSubRequestHandler sub;
        Enumeration<SnmpSubRequestHandler> e;
        int errorStatus = 1230;
        int nbSubRequest = this.subs.size();
        int i = 0;
        if (req.type == 4) {
            i = 0;
            e = this.subs.elements();
            while (e.hasMoreElements()) {
                sub = e.nextElement();
                sub.setUserData(userData);
                sub.type = 3;
                sub.run();
                sub.type = 4;
                if (sub.getErrorStatus() != 1230) {
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "executeSubRequest", "an error occurs");
                    }
                    return this.newErrorResponsePdu(req, errorStatus, sub.getErrorIndex() + 1);
                }
                ++i;
            }
        }
        i = 0;
        e = this.subs.elements();
        while (e.hasMoreElements()) {
            sub = e.nextElement();
            sub.setUserData(userData);
            sub.run();
            if (sub.getErrorStatus() != 1230) {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "executeSubRequest", "an error occurs");
                }
                return this.newErrorResponsePdu(req, errorStatus, sub.getErrorIndex() + 1);
            }
            ++i;
        }
        return null;
    }

    private SnmpPduPacket turboProcessingGetSet(SnmpPduRequest req, Object userData) {
        int errorStatus = 1230;
        SnmpSubRequestHandler sub = this.subs.elements().nextElement();
        sub.setUserData(userData);
        if (req.type == 4) {
            sub.type = 3;
            sub.run();
            sub.type = 4;
            errorStatus = sub.getErrorStatus();
            if (errorStatus != 1230) {
                return this.newErrorResponsePdu(req, errorStatus, sub.getErrorIndex() + 1);
            }
        }
        sub.run();
        errorStatus = sub.getErrorStatus();
        if (errorStatus != 1230) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "turboProcessingGetSet", "an error occurs");
            }
            int realIndex = sub.getErrorIndex() + 1;
            return this.newErrorResponsePdu(req, errorStatus, realIndex);
        }
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "turboProcessingGetSet", "build the unified response for request " + req.requestId);
        }
        return this.mergeResponses(req);
    }

    private SnmpPduPacket makeGetBulkResponsePdu(SnmpPduBulk req, Object userData) {
        int t;
        SnmpVarBind[] respVarBindList = null;
        int L = req.varBindList.length;
        int N = Math.max(Math.min(req.nonRepeaters, L), 0);
        int M = Math.max(req.maxRepetitions, 0);
        int R = L - N;
        if (req.varBindList == null) {
            return this.newValidResponsePdu(req, null);
        }
        this.splitBulkRequest(req, N, M, R);
        SnmpPduPacket result = this.executeSubRequest(req, userData);
        if (result != null) {
            return result;
        }
        respVarBindList = this.mergeBulkResponses(N + M * R);
        for (t = respVarBindList.length; t > N && respVarBindList[t - 1].value.equals(SnmpVarBind.endOfMibView); --t) {
        }
        int m2 = t == N ? N + R : N + ((t - 1 - N) / R + 2) * R;
        if (m2 < respVarBindList.length) {
            SnmpVarBind[] truncatedList = new SnmpVarBind[m2];
            for (int i = 0; i < m2; ++i) {
                truncatedList[i] = respVarBindList[i];
            }
            respVarBindList = truncatedList;
        }
        return this.newValidResponsePdu(req, respVarBindList);
    }

    private boolean checkPduType(SnmpPduPacket pdu) {
        boolean result = true;
        switch (pdu.type) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                result = true;
                break;
            }
            default: {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "checkPduType", "cannot respond to this kind of PDU");
                }
                result = false;
            }
        }
        return result;
    }

    private SnmpPduPacket checkAcl(SnmpPduPacket pdu) {
        SnmpPduRequest response = null;
        String community = new String(pdu.community);
        if (this.ipacl != null) {
            int err;
            if (pdu.type == 4) {
                if (!((InetAddressAcl)this.ipacl).checkWritePermission(pdu.address, community)) {
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "checkAcl", "sender is " + pdu.address + " with " + community + ". Sender has no write permission");
                    }
                    err = SnmpSubRequestHandler.mapErrorStatus(70, pdu.version, pdu.type);
                    response = this.newErrorResponsePdu(pdu, err, 0);
                } else if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "checkAcl", "sender is " + pdu.address + " with " + community + ". Sender has write permission");
                }
            } else if (!((InetAddressAcl)this.ipacl).checkReadPermission(pdu.address, community)) {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "checkAcl", "sender is " + pdu.address + " with " + community + ". Sender has no read permission");
                }
                err = SnmpSubRequestHandler.mapErrorStatus(70, pdu.version, pdu.type);
                response = this.newErrorResponsePdu(pdu, err, 0);
                SnmpAdaptorServer snmpServer = (SnmpAdaptorServer)this.adaptorServer;
                snmpServer.updateErrorCounters(10);
            } else if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "checkAcl", "sender is " + pdu.address + " with " + community + ". Sender has read permission");
            }
        }
        if (response != null) {
            SnmpAdaptorServer snmpServer = (SnmpAdaptorServer)this.adaptorServer;
            snmpServer.incSnmpInBadCommunityUses(1);
            if (!((InetAddressAcl)this.ipacl).checkCommunity(community)) {
                snmpServer.incSnmpInBadCommunityNames(1);
            }
        }
        return response;
    }

    private SnmpPduRequest newValidResponsePdu(SnmpPduPacket reqPdu, SnmpVarBind[] varBindList) {
        SnmpPduRequest result = new SnmpPduRequest();
        result.address = reqPdu.address;
        result.port = reqPdu.port;
        result.version = reqPdu.version;
        result.community = reqPdu.community;
        result.type = 6;
        result.requestId = reqPdu.requestId;
        result.errorStatus = 1230;
        result.errorIndex = 0;
        result.varBindList = varBindList;
        ((SnmpAdaptorServer)this.adaptorServer).updateErrorCounters(result.errorStatus);
        return result;
    }

    private SnmpPduRequest newErrorResponsePdu(SnmpPduPacket req, int s, int i) {
        SnmpPduRequest result = this.newValidResponsePdu(req, null);
        result.errorStatus = s;
        result.errorIndex = i;
        result.varBindList = req.varBindList;
        ((SnmpAdaptorServer)this.adaptorServer).updateErrorCounters(result.errorStatus);
        return result;
    }

    private SnmpMessage newTooBigMessage(SnmpMessage reqMsg) throws SnmpTooBigException {
        SnmpMessage result = null;
        SnmpPduPacket reqPdu = null;
        try {
            reqPdu = (SnmpPduPacket)this.pduFactory.decodeSnmpPdu(reqMsg);
            if (reqPdu != null) {
                SnmpPduPacket respPdu = this.newTooBigPdu(reqPdu);
                result = (SnmpMessage)this.pduFactory.encodeSnmpPdu(respPdu, this.packet.getData().length);
            }
        }
        catch (SnmpStatusException x) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "newTooBigMessage", "Internal error", x);
            }
            throw new InternalError();
        }
        return result;
    }

    private SnmpPduPacket newTooBigPdu(SnmpPduPacket req) {
        SnmpPduRequest result = this.newErrorResponsePdu(req, 660, 0);
        result.varBindList = null;
        return result;
    }

    private SnmpPduPacket reduceResponsePdu(SnmpPduPacket req, SnmpPduPacket resp, int acceptedVbCount) throws SnmpTooBigException {
        if (req.type != 223) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "reduceResponsePdu", "cannot remove anything");
            }
            throw new SnmpTooBigException(acceptedVbCount);
        }
        int vbCount = resp.varBindList.length;
        vbCount = acceptedVbCount >= 3 ? Math.min(acceptedVbCount - 1, resp.varBindList.length) : (acceptedVbCount == 1 ? 1 : resp.varBindList.length / 2);
        if (vbCount < 1) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "reduceResponsePdu", "cannot remove anything");
            }
            throw new SnmpTooBigException(acceptedVbCount);
        }
        SnmpVarBind[] newVbList = new SnmpVarBind[vbCount];
        for (int i = 0; i < vbCount; ++i) {
            newVbList[i] = resp.varBindList[i];
        }
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "reduceResponsePdu", resp.varBindList.length - newVbList.length + " items have been removed");
        }
        resp.varBindList = newVbList;
        return resp;
    }

    private void splitRequest(SnmpPduRequest req) {
        int nbAgents = this.mibs.size();
        SnmpMibAgent agent2 = (SnmpMibAgent)this.mibs.firstElement();
        if (nbAgents == 1) {
            this.subs.put(agent2, new SnmpSubRequestHandler(agent2, req, true));
            return;
        }
        if (req.type == 2) {
            Enumeration e = this.mibs.elements();
            while (e.hasMoreElements()) {
                SnmpMibAgent ag = (SnmpMibAgent)e.nextElement();
                this.subs.put(ag, new SnmpSubNextRequestHandler(this.adaptor, ag, req));
            }
            return;
        }
        int nbReqs = req.varBindList.length;
        SnmpVarBind[] vars = req.varBindList;
        for (int i = 0; i < nbReqs; ++i) {
            agent2 = this.root.getAgentMib(vars[i].oid);
            SnmpSubRequestHandler sub = this.subs.get(agent2);
            if (sub == null) {
                sub = new SnmpSubRequestHandler(agent2, req);
                this.subs.put(agent2, sub);
            }
            sub.updateRequest(vars[i], i);
        }
    }

    private void splitBulkRequest(SnmpPduBulk req, int nonRepeaters, int maxRepetitions, int R) {
        Enumeration e = this.mibs.elements();
        while (e.hasMoreElements()) {
            SnmpMibAgent agent2 = (SnmpMibAgent)e.nextElement();
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "splitBulkRequest", "Create a sub with : " + agent2 + " " + nonRepeaters + " " + maxRepetitions + " " + R);
            }
            this.subs.put(agent2, new SnmpSubBulkRequestHandler(this.adaptor, agent2, req, nonRepeaters, maxRepetitions, R));
        }
    }

    private SnmpPduPacket mergeResponses(SnmpPduRequest req) {
        if (req.type == 2) {
            return this.mergeNextResponses(req);
        }
        SnmpVarBind[] result = req.varBindList;
        Enumeration<SnmpSubRequestHandler> e = this.subs.elements();
        while (e.hasMoreElements()) {
            SnmpSubRequestHandler sub = e.nextElement();
            sub.updateResult(result);
        }
        return this.newValidResponsePdu(req, result);
    }

    private SnmpPduPacket mergeNextResponses(SnmpPduRequest req) {
        int max = req.varBindList.length;
        SnmpVarBind[] result = new SnmpVarBind[max];
        Enumeration<SnmpSubRequestHandler> e = this.subs.elements();
        while (e.hasMoreElements()) {
            SnmpSubRequestHandler sub = e.nextElement();
            sub.updateResult(result);
        }
        if (req.version == 220) {
            return this.newValidResponsePdu(req, result);
        }
        for (int i = 0; i < max; ++i) {
            SnmpValue val = result[i].value;
            if (val != SnmpVarBind.endOfMibView) continue;
            return this.newErrorResponsePdu(req, 10, i + 1);
        }
        return this.newValidResponsePdu(req, result);
    }

    private SnmpVarBind[] mergeBulkResponses(int size) {
        SnmpVarBind[] result = new SnmpVarBind[size];
        for (int i = size - 1; i >= 0; --i) {
            result[i] = new SnmpVarBind();
            result[i].value = SnmpVarBind.endOfMibView;
        }
        Enumeration<SnmpSubRequestHandler> e = this.subs.elements();
        while (e.hasMoreElements()) {
            SnmpSubRequestHandler sub = e.nextElement();
            sub.updateResult(result);
        }
        return result;
    }

    protected String makeDebugTag() {
        return "SnmpRequestHandler[" + this.adaptorServer.getProtocol() + ":" + this.adaptorServer.getPort() + "]";
    }

    Thread createThread(Runnable r) {
        return null;
    }
}

