/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import com.sun.net.ssl.internal.ssl.X509ExtendedTrustManager;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import javax.net.ssl.X509TrustManager;
import sun.security.ssl.Debug;
import sun.security.ssl.JsseJce;
import sun.security.util.HostnameChecker;
import sun.security.validator.KeyStores;
import sun.security.validator.PKIXValidator;
import sun.security.validator.Validator;

final class X509TrustManagerImpl
extends X509ExtendedTrustManager
implements X509TrustManager {
    private static final boolean checkRevocation = Debug.getBooleanProperty("com.sun.net.ssl.checkRevocation", false);
    private final String validatorType;
    private final Collection<X509Certificate> trustedCerts;
    private final PKIXBuilderParameters pkixParams;
    private volatile Validator clientValidator;
    private volatile Validator serverValidator;
    private static final Debug debug = Debug.getInstance("ssl");

    X509TrustManagerImpl(String validatorType, KeyStore ks) throws KeyStoreException {
        this.validatorType = validatorType;
        this.pkixParams = null;
        this.trustedCerts = ks == null ? Collections.emptySet() : KeyStores.getTrustedCerts((KeyStore)ks);
        this.showTrustedCerts();
    }

    X509TrustManagerImpl(String validatorType, PKIXBuilderParameters params) {
        this.validatorType = validatorType;
        this.pkixParams = params;
        Validator v = this.getValidator("tls server");
        this.trustedCerts = v.getTrustedCertificates();
        this.serverValidator = v;
        this.showTrustedCerts();
    }

    private void showTrustedCerts() {
        if (debug != null && Debug.isOn("trustmanager")) {
            for (X509Certificate cert : this.trustedCerts) {
                System.out.println("adding as trusted cert:");
                System.out.println("  Subject: " + cert.getSubjectX500Principal());
                System.out.println("  Issuer:  " + cert.getIssuerX500Principal());
                System.out.println("  Algorithm: " + cert.getPublicKey().getAlgorithm() + "; Serial number: 0x" + cert.getSerialNumber().toString(16));
                System.out.println("  Valid from " + cert.getNotBefore() + " until " + cert.getNotAfter());
                System.out.println();
            }
        }
    }

    private Validator getValidator(String variant) {
        Validator v;
        if (this.pkixParams == null) {
            v = Validator.getInstance(this.validatorType, variant, this.trustedCerts);
            if (v instanceof PKIXValidator) {
                PKIXValidator pkixValidator = (PKIXValidator)v;
                pkixValidator.getParameters().setRevocationEnabled(checkRevocation);
            }
        } else {
            v = Validator.getInstance(this.validatorType, variant, this.pkixParams);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate[] validate(Validator v, X509Certificate[] chain, String authType) throws CertificateException {
        Object o = JsseJce.beginFipsProvider();
        try {
            X509Certificate[] x509CertificateArray = v.validate(chain, null, authType);
            return x509CertificateArray;
        }
        finally {
            JsseJce.endFipsProvider(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (chain == null || chain.length == 0) {
            throw new IllegalArgumentException("null or zero-length certificate chain");
        }
        if (authType == null || authType.length() == 0) {
            throw new IllegalArgumentException("null or zero-length authentication type");
        }
        Validator v = this.clientValidator;
        if (v == null) {
            X509TrustManagerImpl x509TrustManagerImpl = this;
            synchronized (x509TrustManagerImpl) {
                v = this.clientValidator;
                if (v == null) {
                    this.clientValidator = v = this.getValidator("tls client");
                }
            }
        }
        X509Certificate[] trustedChain = X509TrustManagerImpl.validate(v, chain, null);
        if (debug != null && Debug.isOn("trustmanager")) {
            System.out.println("Found trusted certificate:");
            System.out.println(trustedChain[trustedChain.length - 1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (chain == null || chain.length == 0) {
            throw new IllegalArgumentException("null or zero-length certificate chain");
        }
        if (authType == null || authType.length() == 0) {
            throw new IllegalArgumentException("null or zero-length authentication type");
        }
        Validator v = this.serverValidator;
        if (v == null) {
            X509TrustManagerImpl x509TrustManagerImpl = this;
            synchronized (x509TrustManagerImpl) {
                v = this.serverValidator;
                if (v == null) {
                    this.serverValidator = v = this.getValidator("tls server");
                }
            }
        }
        X509Certificate[] trustedChain = X509TrustManagerImpl.validate(v, chain, authType);
        if (debug != null && Debug.isOn("trustmanager")) {
            System.out.println("Found trusted certificate:");
            System.out.println(trustedChain[trustedChain.length - 1]);
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] certsArray = new X509Certificate[this.trustedCerts.size()];
        this.trustedCerts.toArray(certsArray);
        return certsArray;
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType, String hostname, String algorithm) throws CertificateException {
        this.checkClientTrusted(chain, authType);
        this.checkIdentity(hostname, chain[0], algorithm);
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType, String hostname, String algorithm) throws CertificateException {
        this.checkServerTrusted(chain, authType);
        this.checkIdentity(hostname, chain[0], algorithm);
    }

    private void checkIdentity(String hostname, X509Certificate cert, String algorithm) throws CertificateException {
        if (algorithm != null && algorithm.length() != 0) {
            if (hostname != null && hostname.startsWith("[") && hostname.endsWith("]")) {
                hostname = hostname.substring(1, hostname.length() - 1);
            }
            if (algorithm.equalsIgnoreCase("HTTPS")) {
                HostnameChecker.getInstance((byte)1).match(hostname, cert);
            } else if (algorithm.equalsIgnoreCase("LDAP")) {
                HostnameChecker.getInstance((byte)2).match(hostname, cert);
            } else {
                throw new CertificateException("Unknown identification algorithm: " + algorithm);
            }
        }
    }
}

