/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import sun.security.ssl.CloneableDigest;

final class HandshakeHash {
    private final MessageDigest md5;
    private final MessageDigest sha;

    HandshakeHash(boolean needCertificateVerify) {
        int n = needCertificateVerify ? 3 : 2;
        try {
            this.md5 = CloneableDigest.getDigest("MD5", n);
            this.sha = CloneableDigest.getDigest("SHA", n);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Algorithm MD5 or SHA not available", e);
        }
    }

    void update(byte b) {
        this.md5.update(b);
        this.sha.update(b);
    }

    void update(byte[] b, int offset, int len) {
        this.md5.update(b, offset, len);
        this.sha.update(b, offset, len);
    }

    void reset() {
        this.md5.reset();
        this.sha.reset();
    }

    MessageDigest getMD5Clone() {
        return HandshakeHash.cloneDigest(this.md5);
    }

    MessageDigest getSHAClone() {
        return HandshakeHash.cloneDigest(this.sha);
    }

    private static MessageDigest cloneDigest(MessageDigest digest) {
        try {
            return (MessageDigest)digest.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Could not clone digest", e);
        }
    }
}

