/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.FileInputStream;
import java.security.AccessController;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.util.HashMap;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import sun.security.ssl.Debug;
import sun.security.ssl.SSLContextImpl;
import sun.security.ssl.TrustManagerFactoryImpl;

public final class DefaultSSLContextImpl
extends SSLContextImpl {
    private static final String NONE = "NONE";
    private static final String P11KEYSTORE = "PKCS11";
    private static final Debug debug = Debug.getInstance("ssl");
    private static volatile SSLContextImpl defaultImpl;
    private static TrustManager[] defaultTrustManagers;
    private static KeyManager[] defaultKeyManagers;

    public DefaultSSLContextImpl() throws Exception {
        super(defaultImpl);
        try {
            super.engineInit(DefaultSSLContextImpl.getDefaultKeyManager(), DefaultSSLContextImpl.getDefaultTrustManager(), null);
        }
        catch (Exception e) {
            if (debug != null && Debug.isOn("defaultctx")) {
                System.out.println("default context init failed: " + e);
            }
            throw e;
        }
        if (defaultImpl == null) {
            defaultImpl = this;
        }
    }

    protected void engineInit(KeyManager[] km, TrustManager[] tm, SecureRandom sr) throws KeyManagementException {
        throw new KeyManagementException("Default SSLContext is initialized automatically");
    }

    static synchronized SSLContextImpl getDefaultImpl() throws Exception {
        if (defaultImpl == null) {
            new DefaultSSLContextImpl();
        }
        return defaultImpl;
    }

    private static synchronized TrustManager[] getDefaultTrustManager() throws Exception {
        if (defaultTrustManagers != null) {
            return defaultTrustManagers;
        }
        KeyStore ks = TrustManagerFactoryImpl.getCacertsKeyStore("defaultctx");
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ks);
        defaultTrustManagers = tmf.getTrustManagers();
        return defaultTrustManagers;
    }

    private static synchronized KeyManager[] getDefaultKeyManager() throws Exception {
        if (defaultKeyManagers != null) {
            return defaultKeyManagers;
        }
        final HashMap props = new HashMap();
        AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                props.put("keyStore", System.getProperty("javax.net.ssl.keyStore", ""));
                props.put("keyStoreType", System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType()));
                props.put("keyStoreProvider", System.getProperty("javax.net.ssl.keyStoreProvider", ""));
                props.put("keyStorePasswd", System.getProperty("javax.net.ssl.keyStorePassword", ""));
                return null;
            }
        });
        final String defaultKeyStore = (String)props.get("keyStore");
        String defaultKeyStoreType = (String)props.get("keyStoreType");
        String defaultKeyStoreProvider = (String)props.get("keyStoreProvider");
        if (debug != null && Debug.isOn("defaultctx")) {
            System.out.println("keyStore is : " + defaultKeyStore);
            System.out.println("keyStore type is : " + defaultKeyStoreType);
            System.out.println("keyStore provider is : " + defaultKeyStoreProvider);
        }
        if (P11KEYSTORE.equals(defaultKeyStoreType) && !NONE.equals(defaultKeyStore)) {
            throw new IllegalArgumentException("if keyStoreType is PKCS11, then keyStore must be NONE");
        }
        FileInputStream fs = null;
        if (defaultKeyStore.length() != 0 && !NONE.equals(defaultKeyStore)) {
            fs = AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                @Override
                public FileInputStream run() throws Exception {
                    return new FileInputStream(defaultKeyStore);
                }
            });
        }
        String defaultKeyStorePassword = (String)props.get("keyStorePasswd");
        char[] passwd = null;
        if (defaultKeyStorePassword.length() != 0) {
            passwd = defaultKeyStorePassword.toCharArray();
        }
        KeyStore ks = null;
        if (defaultKeyStoreType.length() != 0) {
            if (debug != null && Debug.isOn("defaultctx")) {
                System.out.println("init keystore");
            }
            ks = defaultKeyStoreProvider.length() == 0 ? KeyStore.getInstance(defaultKeyStoreType) : KeyStore.getInstance(defaultKeyStoreType, defaultKeyStoreProvider);
            ks.load(fs, passwd);
        }
        if (fs != null) {
            fs.close();
            fs = null;
        }
        if (debug != null && Debug.isOn("defaultctx")) {
            System.out.println("init keymanager of type " + KeyManagerFactory.getDefaultAlgorithm());
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        if (P11KEYSTORE.equals(defaultKeyStoreType)) {
            kmf.init(ks, null);
        } else {
            kmf.init(ks, passwd);
        }
        defaultKeyManagers = kmf.getKeyManagers();
        return defaultKeyManagers;
    }
}

