/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

public abstract class SimpleEUCEncoder
extends CharsetEncoder {
    protected short[] index1;
    protected String index2;
    protected String index2a;
    protected String index2b;
    protected String index2c;
    protected int mask1;
    protected int mask2;
    protected int shift;
    private byte[] outputByte = new byte[4];
    private final Surrogate.Parser sgp = new Surrogate.Parser();

    protected SimpleEUCEncoder(Charset cs) {
        super(cs, 3.0f, 4.0f);
    }

    public boolean canEncode(char ch) {
        String theChars;
        int index = this.index1[(ch & this.mask1) >> this.shift] + (ch & this.mask2);
        if (index < 7500) {
            theChars = this.index2;
        } else if (index < 15000) {
            index -= 7500;
            theChars = this.index2a;
        } else if (index < 22500) {
            index -= 15000;
            theChars = this.index2b;
        } else {
            index -= 22500;
            theChars = this.index2c;
        }
        if (theChars.charAt(2 * index) != '\u0000' || theChars.charAt(2 * index + 1) != '\u0000') {
            return true;
        }
        return ch == '\u0000';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeArrayLoop(CharBuffer src, ByteBuffer dst) {
        char[] sa = src.array();
        int sp = src.arrayOffset() + src.position();
        int sl = src.arrayOffset() + src.limit();
        assert (sp <= sl);
        byte[] da = dst.array();
        int dp = dst.arrayOffset() + dst.position();
        int dl = dst.arrayOffset() + dst.limit();
        assert (dp <= dl);
        dp = dp <= dl ? dp : dl;
        try {
            for (sp = sp <= sl ? sp : sl; sp < sl; ++sp) {
                int spaceNeeded;
                int i;
                String theChars;
                CoderResult coderResult;
                boolean allZeroes = true;
                char inputChar = sa[sp];
                if (Surrogate.is(inputChar)) {
                    if (this.sgp.parse(inputChar, sa, sp, sl) < 0) {
                        coderResult = this.sgp.error();
                        return coderResult;
                    }
                    coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                if (inputChar >= '\ufffe') {
                    coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                int index = this.index1[(inputChar & this.mask1) >> this.shift] + (inputChar & this.mask2);
                if (index < 7500) {
                    theChars = this.index2;
                } else if (index < 15000) {
                    index -= 7500;
                    theChars = this.index2a;
                } else if (index < 22500) {
                    index -= 15000;
                    theChars = this.index2b;
                } else {
                    index -= 22500;
                    theChars = this.index2c;
                }
                char aChar = theChars.charAt(2 * index);
                this.outputByte[0] = (byte)((aChar & 0xFF00) >> 8);
                this.outputByte[1] = (byte)(aChar & 0xFF);
                aChar = theChars.charAt(2 * index + 1);
                this.outputByte[2] = (byte)((aChar & 0xFF00) >> 8);
                this.outputByte[3] = (byte)(aChar & 0xFF);
                for (i = 0; i < this.outputByte.length; ++i) {
                    if (this.outputByte[i] == 0) continue;
                    allZeroes = false;
                    break;
                }
                if (allZeroes && inputChar != '\u0000') {
                    CoderResult coderResult2 = CoderResult.unmappableForLength(1);
                    return coderResult2;
                }
                int oindex = 0;
                for (spaceNeeded = this.outputByte.length; spaceNeeded > 1 && this.outputByte[oindex++] == 0; --spaceNeeded) {
                }
                if (dp + spaceNeeded > dl) {
                    CoderResult coderResult3 = CoderResult.OVERFLOW;
                    return coderResult3;
                }
                for (i = this.outputByte.length - spaceNeeded; i < this.outputByte.length; ++i) {
                    da[dp++] = this.outputByte[i];
                }
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            src.position(sp - src.arrayOffset());
            dst.position(dp - dst.arrayOffset());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeBufferLoop(CharBuffer src, ByteBuffer dst) {
        int mark = src.position();
        try {
            while (src.hasRemaining()) {
                int spaceNeeded;
                int i;
                String theChars;
                CoderResult coderResult;
                char inputChar = src.get();
                boolean allZeroes = true;
                if (Surrogate.is(inputChar)) {
                    if (this.sgp.parse(inputChar, src) < 0) {
                        coderResult = this.sgp.error();
                        return coderResult;
                    }
                    coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                if (inputChar >= '\ufffe') {
                    coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                int index = this.index1[(inputChar & this.mask1) >> this.shift] + (inputChar & this.mask2);
                if (index < 7500) {
                    theChars = this.index2;
                } else if (index < 15000) {
                    index -= 7500;
                    theChars = this.index2a;
                } else if (index < 22500) {
                    index -= 15000;
                    theChars = this.index2b;
                } else {
                    index -= 22500;
                    theChars = this.index2c;
                }
                char aChar = theChars.charAt(2 * index);
                this.outputByte[0] = (byte)((aChar & 0xFF00) >> 8);
                this.outputByte[1] = (byte)(aChar & 0xFF);
                aChar = theChars.charAt(2 * index + 1);
                this.outputByte[2] = (byte)((aChar & 0xFF00) >> 8);
                this.outputByte[3] = (byte)(aChar & 0xFF);
                for (i = 0; i < this.outputByte.length; ++i) {
                    if (this.outputByte[i] == 0) continue;
                    allZeroes = false;
                    break;
                }
                if (allZeroes && inputChar != '\u0000') {
                    CoderResult coderResult2 = CoderResult.unmappableForLength(1);
                    return coderResult2;
                }
                int oindex = 0;
                for (spaceNeeded = this.outputByte.length; spaceNeeded > 1 && this.outputByte[oindex++] == 0; --spaceNeeded) {
                }
                if (dst.remaining() < spaceNeeded) {
                    CoderResult coderResult3 = CoderResult.OVERFLOW;
                    return coderResult3;
                }
                for (i = this.outputByte.length - spaceNeeded; i < this.outputByte.length; ++i) {
                    dst.put(this.outputByte[i]);
                }
                ++mark;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            src.position(mark);
        }
    }

    protected CoderResult encodeLoop(CharBuffer src, ByteBuffer dst) {
        if (src.hasArray() && dst.hasArray()) {
            return this.encodeArrayLoop(src, dst);
        }
        return this.encodeBufferLoop(src, dst);
    }

    public byte encode(char inputChar) {
        return (byte)this.index2.charAt(this.index1[(inputChar & this.mask1) >> this.shift] + (inputChar & this.mask2));
    }
}

