/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

abstract class DBCS_IBM_ASCII_Decoder
extends CharsetDecoder {
    protected static final char REPLACE_CHAR = '\ufffd';
    protected String singleByteToChar;
    protected boolean[] leadByte;
    protected short[] index1;
    protected String index2;
    protected int mask1;
    protected int mask2;
    protected int shift;

    protected DBCS_IBM_ASCII_Decoder(Charset cs) {
        super(cs, 0.5f, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeArrayLoop(ByteBuffer src, CharBuffer dst) {
        byte[] sa = src.array();
        int sp = src.arrayOffset() + src.position();
        int sl = src.arrayOffset() + src.limit();
        assert (sp <= sl);
        char[] da = dst.array();
        int dp = dst.arrayOffset() + dst.position();
        int dl = dst.arrayOffset() + dst.limit();
        assert (dp <= dl);
        dp = dp <= dl ? dp : dl;
        try {
            int inputSize;
            for (sp = sp <= sl ? sp : sl; sp < sl; sp += inputSize) {
                int b1 = sa[sp];
                inputSize = 1;
                int v = 0;
                int outputChar = 65533;
                if (b1 < 0) {
                    b1 += 256;
                }
                if (!this.leadByte[b1]) {
                    outputChar = this.singleByteToChar.charAt(b1);
                } else {
                    if (sl - sp < 2) {
                        CoderResult coderResult = CoderResult.UNDERFLOW;
                        return coderResult;
                    }
                    int b2 = sa[sp + 1];
                    if (b2 < 0) {
                        b2 += 256;
                    }
                    ++inputSize;
                    v = b1 * 256 + b2;
                    outputChar = this.index2.charAt(this.index1[(v & this.mask1) >> this.shift] + (v & this.mask2));
                }
                if (outputChar == 65533) {
                    CoderResult coderResult = CoderResult.unmappableForLength(inputSize);
                    return coderResult;
                }
                if (dl - dp < 1) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                da[dp++] = outputChar;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            src.position(sp - src.arrayOffset());
            dst.position(dp - dst.arrayOffset());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeBufferLoop(ByteBuffer src, CharBuffer dst) {
        int mark = src.position();
        try {
            while (src.hasRemaining()) {
                char outputChar = '\ufffd';
                int inputSize = 1;
                int v = 0;
                int b1 = src.get();
                if (b1 < 0) {
                    b1 += 256;
                }
                if (!this.leadByte[b1]) {
                    outputChar = this.singleByteToChar.charAt(b1);
                } else {
                    if (src.remaining() < 1) {
                        CoderResult coderResult = CoderResult.UNDERFLOW;
                        return coderResult;
                    }
                    int b2 = src.get();
                    if (b2 < 0) {
                        b2 += 256;
                    }
                    ++inputSize;
                    v = b1 * 256 + b2;
                    outputChar = this.index2.charAt(this.index1[(v & this.mask1) >> this.shift] + (v & this.mask2));
                }
                if (outputChar == '\ufffd') {
                    CoderResult coderResult = CoderResult.unmappableForLength(inputSize);
                    return coderResult;
                }
                if (!dst.hasRemaining()) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                mark += inputSize;
                dst.put(outputChar);
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            src.position(mark);
        }
    }

    protected CoderResult decodeLoop(ByteBuffer src, CharBuffer dst) {
        if (src.hasArray() && dst.hasArray()) {
            return this.decodeArrayLoop(src, dst);
        }
        return this.decodeBufferLoop(src, dst);
    }
}

