/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.registry;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.ObjID;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import sun.misc.URLClassPath;
import sun.rmi.server.LoaderHandler;
import sun.rmi.server.UnicastServerRef;
import sun.rmi.server.UnicastServerRef2;
import sun.rmi.transport.LiveRef;

public class RegistryImpl
extends RemoteServer
implements Registry {
    private static final long serialVersionUID = 4666870661827494597L;
    private Hashtable bindings = new Hashtable(101);
    private static Hashtable allowedAccessCache = new Hashtable(3);
    private static RegistryImpl registry;
    private static ObjID id;
    private static ResourceBundle resources;

    public RegistryImpl(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        LiveRef lref = new LiveRef(id, port, csf, ssf);
        this.setup(new UnicastServerRef2(lref));
    }

    public RegistryImpl(int port) throws RemoteException {
        LiveRef lref = new LiveRef(id, port);
        this.setup(new UnicastServerRef(lref));
    }

    private void setup(UnicastServerRef uref) throws RemoteException {
        this.ref = uref;
        uref.exportObject(this, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Remote lookup(String name) throws RemoteException, NotBoundException {
        Hashtable hashtable = this.bindings;
        synchronized (hashtable) {
            Remote obj = (Remote)this.bindings.get(name);
            if (obj == null) {
                throw new NotBoundException(name);
            }
            return obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(String name, Remote obj) throws RemoteException, AlreadyBoundException, AccessException {
        RegistryImpl.checkAccess("Registry.bind");
        Hashtable hashtable = this.bindings;
        synchronized (hashtable) {
            Remote curr = (Remote)this.bindings.get(name);
            if (curr != null) {
                throw new AlreadyBoundException(name);
            }
            this.bindings.put(name, obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(String name) throws RemoteException, NotBoundException, AccessException {
        RegistryImpl.checkAccess("Registry.unbind");
        Hashtable hashtable = this.bindings;
        synchronized (hashtable) {
            Remote obj = (Remote)this.bindings.get(name);
            if (obj == null) {
                throw new NotBoundException(name);
            }
            this.bindings.remove(name);
        }
    }

    public void rebind(String name, Remote obj) throws RemoteException, AccessException {
        RegistryImpl.checkAccess("Registry.rebind");
        this.bindings.put(name, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] list() throws RemoteException {
        String[] names;
        Hashtable hashtable = this.bindings;
        synchronized (hashtable) {
            int i = this.bindings.size();
            names = new String[i];
            Enumeration enum_ = this.bindings.keys();
            while (--i >= 0) {
                names[i] = (String)enum_.nextElement();
            }
        }
        return names;
    }

    public static void checkAccess(String op) throws AccessException {
        block8: {
            try {
                InetAddress clientHost;
                final String clientHostName = RegistryImpl.getClientHost();
                try {
                    clientHost = (InetAddress)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws UnknownHostException {
                            return InetAddress.getByName(clientHostName);
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw (UnknownHostException)pae.getException();
                }
                if (allowedAccessCache.get(clientHost) != null) break block8;
                if (clientHost.isAnyLocalAddress()) {
                    throw new AccessException("Registry." + op + " disallowed; origin unknown");
                }
                try {
                    final InetAddress finalClientHost = clientHost;
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            new ServerSocket(0, 10, finalClientHost).close();
                            allowedAccessCache.put(finalClientHost, finalClientHost);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw new AccessException("Registry." + op + " disallowed; origin " + clientHost + " is non-local host");
                }
            }
            catch (ServerNotActiveException ex) {
            }
            catch (UnknownHostException ex) {
                throw new AccessException("Registry." + op + " disallowed; origin is unknown host");
            }
        }
    }

    public static ObjID getID() {
        return id;
    }

    private static String getTextResource(String key) {
        if (resources == null) {
            try {
                resources = ResourceBundle.getBundle("sun.rmi.registry.resources.rmiregistry");
            }
            catch (MissingResourceException mre) {
                // empty catch block
            }
            if (resources == null) {
                return "[missing resource file: " + key + "]";
            }
        }
        String val = null;
        try {
            val = resources.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (val == null) {
            return "[missing resource: " + key + "]";
        }
        return val;
    }

    public static void main(String[] args) {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        try {
            String envcp = System.getProperty("env.class.path");
            if (envcp == null) {
                envcp = ".";
            }
            URL[] urls = URLClassPath.pathToURLs(envcp);
            URLClassLoader cl = new URLClassLoader(urls);
            LoaderHandler.registerCodebaseLoader(cl);
            Thread.currentThread().setContextClassLoader(cl);
            int regPort = 1099;
            if (args.length >= 1) {
                regPort = Integer.parseInt(args[0]);
            }
            registry = new RegistryImpl(regPort);
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(Long.MAX_VALUE);
                    }
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
        }
        catch (NumberFormatException e) {
            System.err.println(MessageFormat.format(RegistryImpl.getTextResource("rmiregistry.port.badnumber"), args[0]));
            System.err.println(MessageFormat.format(RegistryImpl.getTextResource("rmiregistry.usage"), "rmiregistry"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(1);
    }

    static {
        id = new ObjID(0);
        resources = null;
    }
}

