/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectionKey;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectorImpl;

class SelectionKeyImpl
extends AbstractSelectionKey {
    final SelChImpl channel;
    final SelectorImpl selector;
    private int index;
    private volatile int interestOps;
    private int readyOps;

    SelectionKeyImpl(SelChImpl ch, SelectorImpl sel) {
        this.channel = ch;
        this.selector = sel;
    }

    public SelectableChannel channel() {
        return (SelectableChannel)((Object)this.channel);
    }

    public Selector selector() {
        return this.selector;
    }

    int getIndex() {
        return this.index;
    }

    void setIndex(int i) {
        this.index = i;
    }

    private void ensureValid() {
        if (!this.isValid()) {
            throw new CancelledKeyException();
        }
    }

    public int interestOps() {
        this.ensureValid();
        return this.interestOps;
    }

    public SelectionKey interestOps(int ops) {
        this.ensureValid();
        return this.nioInterestOps(ops);
    }

    public int readyOps() {
        this.ensureValid();
        return this.readyOps;
    }

    void nioReadyOps(int ops) {
        this.readyOps = ops;
    }

    int nioReadyOps() {
        return this.readyOps;
    }

    SelectionKey nioInterestOps(int ops) {
        if ((ops & ~this.channel().validOps()) != 0) {
            throw new IllegalArgumentException();
        }
        this.channel.translateAndSetInterestOps(ops, this);
        this.interestOps = ops;
        return this;
    }

    int nioInterestOps() {
        return this.interestOps;
    }
}

