/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.SwingUtilities2;
import sun.swing.plaf.synth.SynthUI;

class SynthProgressBarUI
extends BasicProgressBarUI
implements SynthUI,
PropertyChangeListener {
    private SynthStyle style;
    private int progressPadding;
    private boolean paintOutsideClip;

    SynthProgressBarUI() {
    }

    public static ComponentUI createUI(JComponent x) {
        return new SynthProgressBarUI();
    }

    protected void installListeners() {
        super.installListeners();
        this.progressBar.addPropertyChangeListener(this);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.progressBar.removePropertyChangeListener(this);
    }

    protected void installDefaults() {
        this.updateStyle(this.progressBar);
    }

    private void updateStyle(JProgressBar c) {
        SynthContext context = this.getContext(c, 1);
        SynthStyle oldStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(context, this);
        if (this.style != oldStyle) {
            this.setCellLength(this.style.getInt(context, "ProgressBar.cellLength", 1));
            this.setCellSpacing(this.style.getInt(context, "ProgressBar.cellSpacing", 0));
            this.progressPadding = this.style.getInt(context, "ProgressBar.progressPadding", 0);
            this.paintOutsideClip = this.style.getBoolean(context, "ProgressBar.paintOutsideClip", false);
        }
        context.dispose();
    }

    protected void uninstallDefaults() {
        SynthContext context = this.getContext(this.progressBar, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
    }

    public SynthContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    private SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(SynthContext.class, c, SynthLookAndFeel.getRegion(c), this.style, state);
    }

    private Region getRegion(JComponent c) {
        return SynthLookAndFeel.getRegion(c);
    }

    private int getComponentState(JComponent c) {
        return SynthLookAndFeel.getComponentState(c);
    }

    public int getBaseline(JComponent c, int width, int height) {
        super.getBaseline(c, width, height);
        if (this.progressBar.isStringPainted() && this.progressBar.getOrientation() == 0) {
            SynthContext context = this.getContext(c);
            Font font = context.getStyle().getFont(context);
            FontMetrics metrics = this.progressBar.getFontMetrics(font);
            context.dispose();
            return (height - metrics.getAscent() - metrics.getDescent()) / 2 + metrics.getAscent();
        }
        return -1;
    }

    protected void setAnimationIndex(int newValue) {
        if (this.paintOutsideClip) {
            if (this.getAnimationIndex() == newValue) {
                return;
            }
            super.setAnimationIndex(newValue);
            this.progressBar.repaint();
        } else {
            super.setAnimationIndex(newValue);
        }
    }

    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        SynthLookAndFeel.update(context, g);
        context.getPainter().paintProgressBarBackground(context, g, 0, 0, c.getWidth(), c.getHeight(), this.progressBar.getOrientation());
        this.paint(context, g);
        context.dispose();
    }

    public void paint(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SynthContext context, Graphics g) {
        JProgressBar pBar = (JProgressBar)context.getComponent();
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        if (!pBar.isIndeterminate()) {
            Insets pBarInsets = pBar.getInsets();
            double percentComplete = pBar.getPercentComplete();
            if (percentComplete != 0.0) {
                if (pBar.getOrientation() == 0) {
                    x = pBarInsets.left + this.progressPadding;
                    y = pBarInsets.top + this.progressPadding;
                    width = (int)(percentComplete * (double)(pBar.getWidth() - (pBarInsets.left + this.progressPadding + pBarInsets.right + this.progressPadding)));
                    height = pBar.getHeight() - (pBarInsets.top + this.progressPadding + pBarInsets.bottom + this.progressPadding);
                    if (!SynthLookAndFeel.isLeftToRight(pBar)) {
                        x = pBar.getWidth() - pBarInsets.right - width - this.progressPadding;
                    }
                } else {
                    x = pBarInsets.left + this.progressPadding;
                    width = pBar.getWidth() - (pBarInsets.left + this.progressPadding + pBarInsets.right + this.progressPadding);
                    height = (int)(percentComplete * (double)(pBar.getHeight() - (pBarInsets.top + this.progressPadding + pBarInsets.bottom + this.progressPadding)));
                    y = pBar.getHeight() - pBarInsets.bottom - height - this.progressPadding;
                }
            }
        } else {
            this.boxRect = this.getBox(this.boxRect);
            x = this.boxRect.x + this.progressPadding;
            y = this.boxRect.y + this.progressPadding;
            width = this.boxRect.width - this.progressPadding - this.progressPadding;
            height = this.boxRect.height - this.progressPadding - this.progressPadding;
        }
        context.getPainter().paintProgressBarForeground(context, g, x, y, width, height, pBar.getOrientation());
        if (pBar.isStringPainted() && !pBar.isIndeterminate()) {
            this.paintText(context, g, pBar.getString());
        }
    }

    protected void paintText(SynthContext context, Graphics g, String title) {
        Font font = context.getStyle().getFont(context);
        FontMetrics metrics = SwingUtilities2.getFontMetrics(this.progressBar, g, font);
        if (this.progressBar.isStringPainted()) {
            String pBarString = this.progressBar.getString();
            Rectangle bounds = this.progressBar.getBounds();
            int strLength = context.getStyle().getGraphicsUtils(context).computeStringWidth(context, font, metrics, pBarString);
            Rectangle textRect = new Rectangle(bounds.width / 2 - strLength / 2, (bounds.height - (metrics.getAscent() + metrics.getDescent())) / 2, 0, 0);
            if (textRect.y < 0) {
                return;
            }
            SynthStyle style = context.getStyle();
            g.setColor(style.getColor(context, ColorType.TEXT_FOREGROUND));
            g.setFont(style.getFont(context));
            style.getGraphicsUtils(context).paintText(context, g, title, textRect.x, textRect.y, -1);
        }
    }

    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintProgressBarBorder(context, g, x, y, w, h, this.progressBar.getOrientation());
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (SynthLookAndFeel.shouldUpdateStyle(e)) {
            this.updateStyle((JProgressBar)e.getSource());
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        Insets border = this.progressBar.getInsets();
        FontMetrics fontSizer = this.progressBar.getFontMetrics(this.progressBar.getFont());
        Dimension size = this.progressBar.getOrientation() == 0 ? new Dimension(this.getPreferredInnerHorizontal()) : new Dimension(this.getPreferredInnerVertical());
        if (this.progressBar.isStringPainted()) {
            int stringWidth;
            String progString = this.progressBar.getString();
            int stringHeight = fontSizer.getHeight() + fontSizer.getDescent();
            if (stringHeight > size.height) {
                size.height = stringHeight;
            }
            if ((stringWidth = SwingUtilities2.stringWidth(this.progressBar, fontSizer, progString)) > size.width) {
                size.width = stringWidth;
            }
        }
        size.width += border.left + border.right;
        size.height += border.top + border.bottom;
        return size;
    }
}

