/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicMenuBarUI;
import javax.swing.plaf.synth.DefaultMenuLayout;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.plaf.synth.SynthUI;

class SynthMenuBarUI
extends BasicMenuBarUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;

    SynthMenuBarUI() {
    }

    public static ComponentUI createUI(JComponent x) {
        return new SynthMenuBarUI();
    }

    protected void installDefaults() {
        if (this.menuBar.getLayout() == null || this.menuBar.getLayout() instanceof UIResource) {
            this.menuBar.setLayout(new DefaultMenuLayout(this.menuBar, 2));
        }
        this.updateStyle(this.menuBar);
    }

    protected void installListeners() {
        super.installListeners();
        this.menuBar.addPropertyChangeListener(this);
    }

    private void updateStyle(JMenuBar c) {
        SynthContext context = this.getContext(c, 1);
        SynthStyle oldStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(context, this);
        if (this.style != oldStyle && oldStyle != null) {
            this.uninstallKeyboardActions();
            this.installKeyboardActions();
        }
        context.dispose();
    }

    protected void uninstallDefaults() {
        SynthContext context = this.getContext(this.menuBar, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.menuBar.removePropertyChangeListener(this);
    }

    public SynthContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    private SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(SynthContext.class, c, SynthLookAndFeel.getRegion(c), this.style, state);
    }

    private Region getRegion(JComponent c) {
        return SynthLookAndFeel.getRegion(c);
    }

    private int getComponentState(JComponent c) {
        return SynthLookAndFeel.getComponentState(c);
    }

    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        SynthLookAndFeel.update(context, g);
        context.getPainter().paintMenuBarBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        this.paint(context, g);
        context.dispose();
    }

    public void paint(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SynthContext context, Graphics g) {
    }

    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintMenuBarBorder(context, g, x, y, w, h);
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (SynthLookAndFeel.shouldUpdateStyle(e)) {
            this.updateStyle((JMenuBar)e.getSource());
        }
    }
}

