/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.management.relation.Role;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleList
extends ArrayList<Object> {
    private transient boolean typeSafe;
    private transient boolean tainted;
    private static final long serialVersionUID = 5568344346499649313L;

    public RoleList() {
    }

    public RoleList(int initialCapacity) {
        super(initialCapacity);
    }

    public RoleList(List<Role> list) throws IllegalArgumentException {
        if (list == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        RoleList.checkTypeSafe(list);
        super.addAll(list);
    }

    public List<Role> asList() {
        if (!this.typeSafe) {
            if (this.tainted) {
                RoleList.checkTypeSafe(this);
            }
            this.typeSafe = true;
        }
        return this;
    }

    public void add(Role role) throws IllegalArgumentException {
        if (role == null) {
            String excMsg = "Invalid parameter";
            throw new IllegalArgumentException(excMsg);
        }
        super.add(role);
    }

    @Override
    public void add(int index, Role role) throws IllegalArgumentException, IndexOutOfBoundsException {
        if (role == null) {
            String excMsg = "Invalid parameter";
            throw new IllegalArgumentException(excMsg);
        }
        super.add(index, role);
    }

    @Override
    public void set(int index, Role role) throws IllegalArgumentException, IndexOutOfBoundsException {
        if (role == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        super.set(index, role);
    }

    public boolean addAll(RoleList roleList) throws IndexOutOfBoundsException {
        if (roleList == null) {
            return true;
        }
        return super.addAll(roleList);
    }

    public boolean addAll(int index, RoleList roleList) throws IllegalArgumentException, IndexOutOfBoundsException {
        if (roleList == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        return super.addAll(index, roleList);
    }

    @Override
    public boolean add(Object o) {
        if (!this.tainted) {
            this.tainted = RoleList.isTainted(o);
        }
        if (this.typeSafe) {
            RoleList.checkTypeSafe(o);
        }
        return super.add(o);
    }

    @Override
    public void add(int index, Object element) {
        if (!this.tainted) {
            this.tainted = RoleList.isTainted(element);
        }
        if (this.typeSafe) {
            RoleList.checkTypeSafe(element);
        }
        super.add(index, element);
    }

    @Override
    public boolean addAll(Collection<?> c) {
        if (!this.tainted) {
            this.tainted = RoleList.isTainted(c);
        }
        if (this.typeSafe) {
            RoleList.checkTypeSafe(c);
        }
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<?> c) {
        if (!this.tainted) {
            this.tainted = RoleList.isTainted(c);
        }
        if (this.typeSafe) {
            RoleList.checkTypeSafe(c);
        }
        return super.addAll(index, c);
    }

    @Override
    public Object set(int index, Object element) {
        if (!this.tainted) {
            this.tainted = RoleList.isTainted(element);
        }
        if (this.typeSafe) {
            RoleList.checkTypeSafe(element);
        }
        return super.set(index, element);
    }

    private static void checkTypeSafe(Object o) {
        try {
            o = (Role)o;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static void checkTypeSafe(Collection<?> c) {
        try {
            for (Object o : c) {
                Role r = (Role)o;
            }
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static boolean isTainted(Object o) {
        try {
            RoleList.checkTypeSafe(o);
        }
        catch (IllegalArgumentException e) {
            return true;
        }
        return false;
    }

    private static boolean isTainted(Collection<?> c) {
        try {
            RoleList.checkTypeSafe(c);
        }
        catch (IllegalArgumentException e) {
            return true;
        }
        return false;
    }
}

