/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.metadata;

import java.util.ArrayList;
import java.util.List;
import javax.imageio.metadata.IIOAttr;
import javax.imageio.metadata.IIODOMException;
import javax.imageio.metadata.IIONamedNodeMap;
import javax.imageio.metadata.IIONodeList;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

public class IIOMetadataNode
implements Element,
NodeList {
    private String nodeName = null;
    private String nodeValue = null;
    private Object userObject = null;
    private IIOMetadataNode parent = null;
    private int numChildren = 0;
    private IIOMetadataNode firstChild = null;
    private IIOMetadataNode lastChild = null;
    private IIOMetadataNode nextSibling = null;
    private IIOMetadataNode previousSibling = null;
    private List attributes = new ArrayList();
    String textContent;

    public IIOMetadataNode() {
    }

    public IIOMetadataNode(String nodeName) {
        this.nodeName = nodeName;
    }

    private void checkNode(Node node) throws DOMException {
        if (node == null) {
            return;
        }
        if (!(node instanceof IIOMetadataNode)) {
            throw new IIODOMException(4, "Node not an IIOMetadataNode!");
        }
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getNodeValue() throws DOMException {
        return this.nodeValue;
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        this.nodeValue = nodeValue;
    }

    public short getNodeType() {
        return 1;
    }

    public Node getParentNode() {
        return this.parent;
    }

    public NodeList getChildNodes() {
        return this;
    }

    public Node getFirstChild() {
        return this.firstChild;
    }

    public Node getLastChild() {
        return this.lastChild;
    }

    public Node getPreviousSibling() {
        return this.previousSibling;
    }

    public Node getNextSibling() {
        return this.nextSibling;
    }

    public NamedNodeMap getAttributes() {
        return new IIONamedNodeMap(this.attributes);
    }

    public Document getOwnerDocument() {
        return null;
    }

    public Node insertBefore(Node newChild, Node refChild) {
        if (newChild == null) {
            throw new IllegalArgumentException("newChild == null!");
        }
        this.checkNode(newChild);
        this.checkNode(refChild);
        IIOMetadataNode newChildNode = (IIOMetadataNode)newChild;
        IIOMetadataNode refChildNode = (IIOMetadataNode)refChild;
        IIOMetadataNode previous = null;
        IIOMetadataNode next = null;
        if (refChild == null) {
            previous = this.lastChild;
            next = null;
            this.lastChild = newChildNode;
        } else {
            previous = refChildNode.previousSibling;
            next = refChildNode;
        }
        if (previous != null) {
            previous.nextSibling = newChildNode;
        }
        if (next != null) {
            next.previousSibling = newChildNode;
        }
        newChildNode.parent = this;
        newChildNode.previousSibling = previous;
        newChildNode.nextSibling = next;
        if (this.firstChild == refChildNode) {
            this.firstChild = newChildNode;
        }
        ++this.numChildren;
        return newChildNode;
    }

    public Node replaceChild(Node newChild, Node oldChild) {
        if (newChild == null) {
            throw new IllegalArgumentException("newChild == null!");
        }
        this.checkNode(newChild);
        this.checkNode(oldChild);
        IIOMetadataNode newChildNode = (IIOMetadataNode)newChild;
        IIOMetadataNode oldChildNode = (IIOMetadataNode)oldChild;
        IIOMetadataNode previous = oldChildNode.previousSibling;
        IIOMetadataNode next = oldChildNode.nextSibling;
        if (previous != null) {
            previous.nextSibling = newChildNode;
        }
        if (next != null) {
            next.previousSibling = newChildNode;
        }
        newChildNode.parent = this;
        newChildNode.previousSibling = previous;
        newChildNode.nextSibling = next;
        if (this.firstChild == oldChildNode) {
            this.firstChild = newChildNode;
        }
        if (this.lastChild == oldChildNode) {
            this.lastChild = newChildNode;
        }
        oldChildNode.parent = null;
        oldChildNode.previousSibling = null;
        oldChildNode.nextSibling = null;
        return oldChildNode;
    }

    public Node removeChild(Node oldChild) {
        if (oldChild == null) {
            throw new IllegalArgumentException("oldChild == null!");
        }
        this.checkNode(oldChild);
        IIOMetadataNode oldChildNode = (IIOMetadataNode)oldChild;
        IIOMetadataNode previous = oldChildNode.previousSibling;
        IIOMetadataNode next = oldChildNode.nextSibling;
        if (previous != null) {
            previous.nextSibling = next;
        }
        if (next != null) {
            next.previousSibling = previous;
        }
        if (this.firstChild == oldChildNode) {
            this.firstChild = next;
        }
        if (this.lastChild == oldChildNode) {
            this.lastChild = previous;
        }
        oldChildNode.parent = null;
        oldChildNode.previousSibling = null;
        oldChildNode.nextSibling = null;
        --this.numChildren;
        return oldChildNode;
    }

    public Node appendChild(Node newChild) {
        if (newChild == null) {
            throw new IllegalArgumentException("newChild == null!");
        }
        this.checkNode(newChild);
        return this.insertBefore(newChild, null);
    }

    public boolean hasChildNodes() {
        return this.numChildren > 0;
    }

    public Node cloneNode(boolean deep) {
        IIOMetadataNode newNode = new IIOMetadataNode(this.nodeName);
        newNode.setUserObject(this.getUserObject());
        if (deep) {
            IIOMetadataNode child = this.firstChild;
            while (child != null) {
                newNode.appendChild(child.cloneNode(true));
                child = child.nextSibling;
            }
        }
        return newNode;
    }

    public void normalize() {
    }

    public boolean isSupported(String feature, String version) {
        return false;
    }

    public String getNamespaceURI() throws DOMException {
        return null;
    }

    public String getPrefix() {
        return null;
    }

    public void setPrefix(String prefix) {
    }

    public String getLocalName() {
        return this.nodeName;
    }

    public String getTagName() {
        return this.nodeName;
    }

    public String getAttribute(String name) {
        Attr attr = this.getAttributeNode(name);
        if (attr == null) {
            return "";
        }
        return attr.getValue();
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        return this.getAttribute(localName);
    }

    public void setAttribute(String name, String value) {
        boolean valid = true;
        char[] chs = name.toCharArray();
        for (int i = 0; i < chs.length; ++i) {
            if (chs[i] < '\ufffe') continue;
            valid = false;
            break;
        }
        if (!valid) {
            throw new IIODOMException(5, "Attribute name is illegal!");
        }
        this.removeAttribute(name, false);
        this.attributes.add(new IIOAttr(this, name, value));
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) {
        this.setAttribute(qualifiedName, value);
    }

    public void removeAttribute(String name) {
        this.removeAttribute(name, true);
    }

    private void removeAttribute(String name, boolean checkPresent) {
        int numAttributes = this.attributes.size();
        for (int i = 0; i < numAttributes; ++i) {
            IIOAttr attr = (IIOAttr)this.attributes.get(i);
            if (!name.equals(attr.getName())) continue;
            attr.setOwnerElement(null);
            this.attributes.remove(i);
            return;
        }
        if (checkPresent) {
            throw new IIODOMException(8, "No such attribute!");
        }
    }

    public void removeAttributeNS(String namespaceURI, String localName) {
        this.removeAttribute(localName);
    }

    public Attr getAttributeNode(String name) {
        Node node = this.getAttributes().getNamedItem(name);
        return (Attr)node;
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        return this.getAttributeNode(localName);
    }

    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        IIOAttr attr;
        Element owner = newAttr.getOwnerElement();
        if (owner != null) {
            if (owner == this) {
                return null;
            }
            throw new DOMException(10, "Attribute is already in use");
        }
        if (newAttr instanceof IIOAttr) {
            attr = (IIOAttr)newAttr;
            attr.setOwnerElement(this);
        } else {
            attr = new IIOAttr(this, newAttr.getName(), newAttr.getValue());
        }
        Attr oldAttr = this.getAttributeNode(attr.getName());
        if (oldAttr != null) {
            this.removeAttributeNode(oldAttr);
        }
        this.attributes.add(attr);
        return oldAttr;
    }

    public Attr setAttributeNodeNS(Attr newAttr) {
        return this.setAttributeNode(newAttr);
    }

    public Attr removeAttributeNode(Attr oldAttr) {
        this.removeAttribute(oldAttr.getName());
        return oldAttr;
    }

    public NodeList getElementsByTagName(String name) {
        ArrayList l = new ArrayList();
        this.getElementsByTagName(name, l);
        return new IIONodeList(l);
    }

    private void getElementsByTagName(String name, List l) {
        if (this.nodeName.equals(name)) {
            l.add(this);
        }
        for (Node child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            ((IIOMetadataNode)child).getElementsByTagName(name, l);
        }
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return this.getElementsByTagName(localName);
    }

    public boolean hasAttributes() {
        return this.attributes.size() > 0;
    }

    public boolean hasAttribute(String name) {
        return this.getAttributeNode(name) != null;
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.hasAttribute(localName);
    }

    public int getLength() {
        return this.numChildren;
    }

    public Node item(int index) {
        Node child;
        if (index < 0) {
            return null;
        }
        for (child = this.getFirstChild(); child != null && index-- > 0; child = child.getNextSibling()) {
        }
        return child;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public void setIdAttribute(String name, boolean isId) throws DOMException {
        throw new DOMException(9, "Method not supported");
    }

    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        throw new DOMException(9, "Method not supported");
    }

    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        throw new DOMException(9, "Method not supported");
    }

    public TypeInfo getSchemaTypeInfo() {
        throw new DOMException(9, "Method not supported");
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        throw new DOMException(9, "Method not supported");
    }

    public Object getUserData(String key) {
        throw new DOMException(9, "Method not supported");
    }

    public Object getFeature(String feature, String version) {
        throw new DOMException(9, "Method not supported");
    }

    public boolean isSameNode(Node node) {
        throw new DOMException(9, "Method not supported");
    }

    public boolean isEqualNode(Node node) {
        throw new DOMException(9, "Method not supported");
    }

    public String lookupNamespaceURI(String prefix) {
        throw new DOMException(9, "Method not supported");
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        throw new DOMException(9, "Method not supported");
    }

    public String lookupPrefix(String namespaceURI) {
        throw new DOMException(9, "Method not supported");
    }

    public String getTextContent() throws DOMException {
        return this.textContent;
    }

    public void setTextContent(String textContent) throws DOMException {
        this.textContent = textContent;
    }

    public short compareDocumentPosition(Node other) throws DOMException {
        throw new DOMException(9, "Method not supported");
    }

    public String getBaseURI() {
        throw new DOMException(9, "Method not supported");
    }
}

