/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.Introspector;
import java.beans.PropertyEditor;
import java.util.Hashtable;
import sun.beans.editors.BooleanEditor;
import sun.beans.editors.ByteEditor;
import sun.beans.editors.DoubleEditor;
import sun.beans.editors.EnumEditor;
import sun.beans.editors.FloatEditor;
import sun.beans.editors.IntegerEditor;
import sun.beans.editors.LongEditor;
import sun.beans.editors.ShortEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyEditorManager {
    private static String[] searchPath = new String[]{"sun.beans.editors"};
    private static Hashtable registry;

    public static void registerEditor(Class<?> targetType, Class<?> editorClass) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertiesAccess();
        }
        PropertyEditorManager.initialize();
        if (editorClass == null) {
            registry.remove(targetType);
        } else {
            registry.put(targetType, editorClass);
        }
    }

    public static synchronized PropertyEditor findEditor(Class<?> targetType) {
        PropertyEditorManager.initialize();
        Class editorClass = (Class)registry.get(targetType);
        if (editorClass != null) {
            try {
                Object o = editorClass.newInstance();
                return (PropertyEditor)o;
            }
            catch (Exception ex) {
                System.err.println("Couldn't instantiate type editor \"" + editorClass.getName() + "\" : " + ex);
            }
        }
        String editorName = targetType.getName() + "Editor";
        try {
            return (PropertyEditor)Introspector.instantiate(targetType, editorName);
        }
        catch (Exception ex) {
            int index = editorName.lastIndexOf(46) + 1;
            if (index > 0) {
                editorName = editorName.substring(index);
            }
            for (String path : searchPath) {
                String name = path + '.' + editorName;
                try {
                    return (PropertyEditor)Introspector.instantiate(targetType, name);
                }
                catch (Exception ex2) {
                }
            }
            if (null != targetType.getEnumConstants()) {
                return new EnumEditor(targetType);
            }
            return null;
        }
    }

    public static synchronized String[] getEditorSearchPath() {
        String[] result = new String[searchPath.length];
        System.arraycopy(searchPath, 0, result, 0, searchPath.length);
        return result;
    }

    public static synchronized void setEditorSearchPath(String[] path) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertiesAccess();
        }
        if (path == null) {
            path = new String[]{};
        }
        searchPath = path;
    }

    private static synchronized void initialize() {
        if (registry != null) {
            return;
        }
        registry = new Hashtable();
        registry.put(Byte.TYPE, ByteEditor.class);
        registry.put(Short.TYPE, ShortEditor.class);
        registry.put(Integer.TYPE, IntegerEditor.class);
        registry.put(Long.TYPE, LongEditor.class);
        registry.put(Boolean.TYPE, BooleanEditor.class);
        registry.put(Float.TYPE, FloatEditor.class);
        registry.put(Double.TYPE, DoubleEditor.class);
    }
}

