/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.pipe;

import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.Tube;

public final class NextAction {
    int kind;
    Tube next;
    Packet packet;
    Throwable throwable;
    static final int INVOKE = 0;
    static final int INVOKE_AND_FORGET = 1;
    static final int RETURN = 2;
    static final int THROW = 3;
    static final int SUSPEND = 4;

    private void set(int k, Tube v, Packet p, Throwable t) {
        this.kind = k;
        this.next = v;
        this.packet = p;
        this.throwable = t;
    }

    public void invoke(Tube next, Packet p) {
        this.set(0, next, p, null);
    }

    public void invokeAndForget(Tube next, Packet p) {
        this.set(1, next, p, null);
    }

    public void returnWith(Packet response) {
        this.set(2, null, response, null);
    }

    public void throwException(Throwable t) {
        assert (t instanceof RuntimeException || t instanceof Error);
        this.set(3, null, null, t);
    }

    public void suspend() {
        this.set(4, null, null, null);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(super.toString()).append(" [");
        buf.append("kind=").append(this.getKindString()).append(',');
        buf.append("next=").append(this.next).append(',');
        buf.append("packet=").append(this.packet).append(',');
        buf.append("throwable=").append(this.throwable).append(']');
        return buf.toString();
    }

    public String getKindString() {
        switch (this.kind) {
            case 0: {
                return "INVOKE";
            }
            case 1: {
                return "INVOKE_AND_FORGET";
            }
            case 2: {
                return "RETURN";
            }
            case 3: {
                return "THROW";
            }
            case 4: {
                return "SUSPEND";
            }
        }
        throw new AssertionError(this.kind);
    }
}

