/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.content;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.KeyInfoContent;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509CRL;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509Certificate;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509IssuerSerial;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509SKI;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509SubjectName;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class X509Data
extends SignatureElementProxy
implements KeyInfoContent {
    static Logger log = Logger.getLogger(X509Data.class.getName());

    public X509Data(Document doc) {
        super(doc);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public X509Data(Element element, String BaseURI) throws XMLSecurityException {
        super(element, BaseURI);
        boolean noElements = true;
        Node sibling = this._constructionElement.getFirstChild();
        while (sibling != null) {
            if (sibling.getNodeType() != 1) {
                sibling = sibling.getNextSibling();
                continue;
            }
            noElements = false;
            Element currentElem = (Element)sibling;
            sibling = sibling.getNextSibling();
            String localname = currentElem.getLocalName();
            if (currentElem.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#")) {
                if (localname.equals("X509IssuerSerial")) {
                    XMLX509IssuerSerial is = new XMLX509IssuerSerial(currentElem, BaseURI);
                    this.add(is);
                    continue;
                }
                if (localname.equals("X509SKI")) {
                    XMLX509SKI ski = new XMLX509SKI(currentElem, BaseURI);
                    this.add(ski);
                    continue;
                }
                if (localname.equals("X509SubjectName")) {
                    XMLX509SubjectName sn = new XMLX509SubjectName(currentElem, BaseURI);
                    this.add(sn);
                    continue;
                }
                if (localname.equals("X509Certificate")) {
                    XMLX509Certificate cert = new XMLX509Certificate(currentElem, BaseURI);
                    this.add(cert);
                    continue;
                }
                if (localname.equals("X509CRL")) {
                    XMLX509CRL crl = new XMLX509CRL(currentElem, BaseURI);
                    this.add(crl);
                    continue;
                }
                log.log(Level.WARNING, "Found a " + currentElem.getTagName() + " element in " + "X509Data");
                this.addUnknownElement(currentElem);
                continue;
            }
            log.log(Level.WARNING, "Found a " + currentElem.getTagName() + " element in " + "X509Data");
            this.addUnknownElement(currentElem);
        }
        if (noElements) {
            Object[] exArgs = new Object[]{"Elements", "X509Data"};
            throw new XMLSecurityException("xml.WrongContent", exArgs);
        }
    }

    public void addIssuerSerial(String X509IssuerName, BigInteger X509SerialNumber) {
        this.add(new XMLX509IssuerSerial(this._doc, X509IssuerName, X509SerialNumber));
    }

    public void addIssuerSerial(String X509IssuerName, String X509SerialNumber) {
        this.add(new XMLX509IssuerSerial(this._doc, X509IssuerName, X509SerialNumber));
    }

    public void addIssuerSerial(String X509IssuerName, int X509SerialNumber) {
        this.add(new XMLX509IssuerSerial(this._doc, X509IssuerName, X509SerialNumber));
    }

    public void add(XMLX509IssuerSerial xmlX509IssuerSerial) {
        if (this._state == 0) {
            this._constructionElement.appendChild(xmlX509IssuerSerial.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void addSKI(byte[] skiBytes) {
        this.add(new XMLX509SKI(this._doc, skiBytes));
    }

    public void addSKI(X509Certificate x509certificate) throws XMLSecurityException {
        this.add(new XMLX509SKI(this._doc, x509certificate));
    }

    public void add(XMLX509SKI xmlX509SKI) {
        if (this._state == 0) {
            this._constructionElement.appendChild(xmlX509SKI.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void addSubjectName(String subjectName) {
        this.add(new XMLX509SubjectName(this._doc, subjectName));
    }

    public void addSubjectName(X509Certificate x509certificate) {
        this.add(new XMLX509SubjectName(this._doc, x509certificate));
    }

    public void add(XMLX509SubjectName xmlX509SubjectName) {
        if (this._state == 0) {
            this._constructionElement.appendChild(xmlX509SubjectName.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void addCertificate(X509Certificate x509certificate) throws XMLSecurityException {
        this.add(new XMLX509Certificate(this._doc, x509certificate));
    }

    public void addCertificate(byte[] x509certificateBytes) {
        this.add(new XMLX509Certificate(this._doc, x509certificateBytes));
    }

    public void add(XMLX509Certificate xmlX509Certificate) {
        if (this._state == 0) {
            this._constructionElement.appendChild(xmlX509Certificate.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void addCRL(byte[] crlBytes) {
        this.add(new XMLX509CRL(this._doc, crlBytes));
    }

    public void add(XMLX509CRL xmlX509CRL) {
        if (this._state == 0) {
            this._constructionElement.appendChild(xmlX509CRL.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void addUnknownElement(Element element) {
        if (this._state == 0) {
            this._constructionElement.appendChild(element);
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public int lengthIssuerSerial() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "X509IssuerSerial");
    }

    public int lengthSKI() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "X509SKI");
    }

    public int lengthSubjectName() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "X509SubjectName");
    }

    public int lengthCertificate() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "X509Certificate");
    }

    public int lengthCRL() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "X509CRL");
    }

    public int lengthUnknownElement() {
        int result = 0;
        for (Node n = this._constructionElement.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1 || n.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#")) continue;
            ++result;
        }
        return result;
    }

    public XMLX509IssuerSerial itemIssuerSerial(int i) throws XMLSecurityException {
        Element e = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "X509IssuerSerial", i);
        if (e != null) {
            return new XMLX509IssuerSerial(e, this._baseURI);
        }
        return null;
    }

    public XMLX509SKI itemSKI(int i) throws XMLSecurityException {
        Element e = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "X509SKI", i);
        if (e != null) {
            return new XMLX509SKI(e, this._baseURI);
        }
        return null;
    }

    public XMLX509SubjectName itemSubjectName(int i) throws XMLSecurityException {
        Element e = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "X509SubjectName", i);
        if (e != null) {
            return new XMLX509SubjectName(e, this._baseURI);
        }
        return null;
    }

    public XMLX509Certificate itemCertificate(int i) throws XMLSecurityException {
        Element e = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "X509Certificate", i);
        if (e != null) {
            return new XMLX509Certificate(e, this._baseURI);
        }
        return null;
    }

    public XMLX509CRL itemCRL(int i) throws XMLSecurityException {
        Element e = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "X509CRL", i);
        if (e != null) {
            return new XMLX509CRL(e, this._baseURI);
        }
        return null;
    }

    public Element itemUnknownElement(int i) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "itemUnknownElement not implemented:" + i);
        }
        return null;
    }

    public boolean containsIssuerSerial() {
        return this.lengthIssuerSerial() > 0;
    }

    public boolean containsSKI() {
        return this.lengthSKI() > 0;
    }

    public boolean containsSubjectName() {
        return this.lengthSubjectName() > 0;
    }

    public boolean containsCertificate() {
        return this.lengthCertificate() > 0;
    }

    public boolean containsCRL() {
        return this.lengthCRL() > 0;
    }

    public boolean containsUnknownElement() {
        return this.lengthUnknownElement() > 0;
    }

    public String getBaseLocalName() {
        return "X509Data";
    }
}

