/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.ModelInstrument;
import com.sun.media.sound.ModelOscillator;
import com.sun.media.sound.ModelOscillatorStream;
import com.sun.media.sound.ModelPatch;
import com.sun.media.sound.ModelPerformer;
import com.sun.media.sound.SimpleInstrument;
import com.sun.media.sound.SimpleSoundbank;
import java.io.IOException;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.Patch;
import javax.sound.midi.Soundbank;
import javax.sound.midi.SoundbankResource;
import javax.sound.midi.VoiceStatus;

public abstract class ModelAbstractOscillator
implements ModelOscillator,
ModelOscillatorStream,
Soundbank {
    protected float pitch = 6000.0f;
    protected float samplerate;
    protected MidiChannel channel;
    protected VoiceStatus voice;
    protected int noteNumber;
    protected int velocity;
    protected boolean on = false;

    public void init() {
    }

    public void close() throws IOException {
    }

    public void noteOff(int velocity) {
        this.on = false;
    }

    public void noteOn(MidiChannel channel, VoiceStatus voice, int noteNumber, int velocity) {
        this.channel = channel;
        this.voice = voice;
        this.noteNumber = noteNumber;
        this.velocity = velocity;
        this.on = true;
    }

    public int read(float[][] buffer, int offset, int len) throws IOException {
        return -1;
    }

    public MidiChannel getChannel() {
        return this.channel;
    }

    public VoiceStatus getVoice() {
        return this.voice;
    }

    public int getNoteNumber() {
        return this.noteNumber;
    }

    public int getVelocity() {
        return this.velocity;
    }

    public boolean isOn() {
        return this.on;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setSampleRate(float samplerate) {
        this.samplerate = samplerate;
    }

    public float getSampleRate() {
        return this.samplerate;
    }

    public float getAttenuation() {
        return 0.0f;
    }

    public int getChannels() {
        return 1;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public Patch getPatch() {
        return new Patch(0, 0);
    }

    public ModelOscillatorStream open(float samplerate) {
        ModelAbstractOscillator oscs;
        try {
            oscs = (ModelAbstractOscillator)this.getClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        oscs.setSampleRate(samplerate);
        oscs.init();
        return oscs;
    }

    public ModelPerformer getPerformer() {
        ModelPerformer performer = new ModelPerformer();
        performer.getOscillators().add(this);
        return performer;
    }

    public ModelInstrument getInstrument() {
        SimpleInstrument ins = new SimpleInstrument();
        ins.setName(this.getName());
        ins.add(this.getPerformer());
        ins.setPatch(this.getPatch());
        return ins;
    }

    public Soundbank getSoundBank() {
        SimpleSoundbank sbk = new SimpleSoundbank();
        sbk.addInstrument(this.getInstrument());
        return sbk;
    }

    public String getDescription() {
        return this.getName();
    }

    public Instrument getInstrument(Patch patch) {
        ModelInstrument ins = this.getInstrument();
        Patch p = ins.getPatch();
        if (p.getBank() != patch.getBank()) {
            return null;
        }
        if (p.getProgram() != patch.getProgram()) {
            return null;
        }
        if (p instanceof ModelPatch && patch instanceof ModelPatch && ((ModelPatch)p).isPercussion() != ((ModelPatch)patch).isPercussion()) {
            return null;
        }
        return ins;
    }

    public Instrument[] getInstruments() {
        return new Instrument[]{this.getInstrument()};
    }

    public SoundbankResource[] getResources() {
        return new SoundbankResource[0];
    }

    public String getVendor() {
        return null;
    }

    public String getVersion() {
        return null;
    }
}

