/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.url.ldap;

import com.sun.jndi.ldap.LdapURL;
import com.sun.jndi.toolkit.url.GenericURLDirContext;
import com.sun.jndi.url.ldap.ldapURLContextFactory;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.spi.ResolveResult;

public final class ldapURLContext
extends GenericURLDirContext {
    ldapURLContext(Hashtable env) {
        super(env);
    }

    protected ResolveResult getRootURLContext(String name, Hashtable env) throws NamingException {
        return ldapURLContextFactory.getUsingURLIgnoreRootDN(name, env);
    }

    protected Name getURLSuffix(String prefix, String url) throws NamingException {
        LdapURL ldapUrl = new LdapURL(url);
        String dn = ldapUrl.getDN() != null ? ldapUrl.getDN() : "";
        CompositeName remaining = new CompositeName();
        if (!"".equals(dn)) {
            remaining.add(dn);
        }
        return remaining;
    }

    public Object lookup(String name) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        return super.lookup(name);
    }

    public Object lookup(Name name) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.lookup(name);
    }

    public void bind(String name, Object obj) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        super.bind(name, obj);
    }

    public void bind(Name name, Object obj) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        super.bind(name, obj);
    }

    public void rebind(String name, Object obj) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        super.rebind(name, obj);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        super.rebind(name, obj);
    }

    public void unbind(String name) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        super.unbind(name);
    }

    public void unbind(Name name) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        super.unbind(name);
    }

    public void rename(String oldName, String newName) throws NamingException {
        if (LdapURL.hasQueryComponents(oldName)) {
            throw new InvalidNameException(oldName);
        }
        if (LdapURL.hasQueryComponents(newName)) {
            throw new InvalidNameException(newName);
        }
        super.rename(oldName, newName);
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        if (LdapURL.hasQueryComponents(oldName.get(0))) {
            throw new InvalidNameException(oldName.toString());
        }
        if (LdapURL.hasQueryComponents(newName.get(0))) {
            throw new InvalidNameException(newName.toString());
        }
        super.rename(oldName, newName);
    }

    public NamingEnumeration list(String name) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        return super.list(name);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.list(name);
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        return super.listBindings(name);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.listBindings(name);
    }

    public void destroySubcontext(String name) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        super.destroySubcontext(name);
    }

    public void destroySubcontext(Name name) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        super.destroySubcontext(name);
    }

    public Context createSubcontext(String name) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        return super.createSubcontext(name);
    }

    public Context createSubcontext(Name name) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.createSubcontext(name);
    }

    public Object lookupLink(String name) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        return super.lookupLink(name);
    }

    public Object lookupLink(Name name) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.lookupLink(name);
    }

    public NameParser getNameParser(String name) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        return super.getNameParser(name);
    }

    public NameParser getNameParser(Name name) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.getNameParser(name);
    }

    public String composeName(String name, String prefix) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        if (LdapURL.hasQueryComponents(prefix)) {
            throw new InvalidNameException(prefix);
        }
        return super.composeName(name, prefix);
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        if (LdapURL.hasQueryComponents(prefix.get(0))) {
            throw new InvalidNameException(prefix.toString());
        }
        return super.composeName(name, prefix);
    }

    public Attributes getAttributes(String name) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        return super.getAttributes(name);
    }

    public Attributes getAttributes(Name name) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.getAttributes(name);
    }

    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        return super.getAttributes(name, attrIds);
    }

    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.getAttributes(name, attrIds);
    }

    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        super.modifyAttributes(name, mod_op, attrs);
    }

    public void modifyAttributes(Name name, int mod_op, Attributes attrs) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        super.modifyAttributes(name, mod_op, attrs);
    }

    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        super.modifyAttributes(name, mods);
    }

    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        super.modifyAttributes(name, mods);
    }

    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        super.bind(name, obj, attrs);
    }

    public void bind(Name name, Object obj, Attributes attrs) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        super.bind(name, obj, attrs);
    }

    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        super.rebind(name, obj, attrs);
    }

    public void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        super.rebind(name, obj, attrs);
    }

    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        return super.createSubcontext(name, attrs);
    }

    public DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.createSubcontext(name, attrs);
    }

    public DirContext getSchema(String name) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        return super.getSchema(name);
    }

    public DirContext getSchema(Name name) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.getSchema(name);
    }

    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        return super.getSchemaClassDefinition(name);
    }

    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.getSchemaClassDefinition(name);
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            return this.searchUsingURL(name);
        }
        return super.search(name, matchingAttributes);
    }

    public NamingEnumeration search(Name name, Attributes matchingAttributes) throws NamingException {
        if (name.size() == 1) {
            return this.search(name.get(0), matchingAttributes);
        }
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.search(name, matchingAttributes);
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            return this.searchUsingURL(name);
        }
        return super.search(name, matchingAttributes, attributesToReturn);
    }

    public NamingEnumeration search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        if (name.size() == 1) {
            return this.search(name.get(0), matchingAttributes, attributesToReturn);
        }
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.search(name, matchingAttributes, attributesToReturn);
    }

    public NamingEnumeration search(String name, String filter, SearchControls cons) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            return this.searchUsingURL(name);
        }
        return super.search(name, filter, cons);
    }

    public NamingEnumeration search(Name name, String filter, SearchControls cons) throws NamingException {
        if (name.size() == 1) {
            return this.search(name.get(0), filter, cons);
        }
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.search(name, filter, cons);
    }

    public NamingEnumeration search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            return this.searchUsingURL(name);
        }
        return super.search(name, filterExpr, filterArgs, cons);
    }

    public NamingEnumeration search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        if (name.size() == 1) {
            return this.search(name.get(0), filterExpr, filterArgs, cons);
        }
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.search(name, filterExpr, filterArgs, cons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NamingEnumeration searchUsingURL(String name) throws NamingException {
        LdapURL url = new LdapURL(name);
        ResolveResult res = this.getRootURLContext(name, this.myEnv);
        DirContext ctx = (DirContext)res.getResolvedObj();
        try {
            NamingEnumeration<SearchResult> namingEnumeration = ctx.search(res.getRemainingName(), ldapURLContext.setFilterUsingURL(url), ldapURLContext.setSearchControlsUsingURL(url));
            return namingEnumeration;
        }
        finally {
            ctx.close();
        }
    }

    private static String setFilterUsingURL(LdapURL url) {
        String filter = url.getFilter();
        if (filter == null) {
            filter = "(objectClass=*)";
        }
        return filter;
    }

    private static SearchControls setSearchControlsUsingURL(LdapURL url) {
        SearchControls cons = new SearchControls();
        String scope = url.getScope();
        String attributes = url.getAttributes();
        if (scope == null) {
            cons.setSearchScope(0);
        } else if (scope.equals("sub")) {
            cons.setSearchScope(2);
        } else if (scope.equals("one")) {
            cons.setSearchScope(1);
        } else if (scope.equals("base")) {
            cons.setSearchScope(0);
        }
        if (attributes == null) {
            cons.setReturningAttributes(null);
        } else {
            StringTokenizer tokens = new StringTokenizer(attributes, ",");
            int count = tokens.countTokens();
            String[] attrs = new String[count];
            for (int i = 0; i < count; ++i) {
                attrs[i] = tokens.nextToken();
            }
            cons.setReturningAttributes(attrs);
        }
        return cons;
    }
}

