/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import com.sun.jndi.dns.Header;
import com.sun.jndi.dns.ResourceRecord;
import java.util.Vector;
import javax.naming.CommunicationException;
import javax.naming.NamingException;

class ResourceRecords {
    Vector question = new Vector();
    Vector answer = new Vector();
    Vector authority = new Vector();
    Vector additional = new Vector();
    boolean zoneXfer;

    ResourceRecords(byte[] msg, int msgLen, Header hdr2, boolean zoneXfer) throws NamingException {
        if (zoneXfer) {
            this.answer.ensureCapacity(8192);
        }
        this.zoneXfer = zoneXfer;
        this.add(msg, msgLen, hdr2);
    }

    int getFirstAnsType() {
        if (this.answer.size() == 0) {
            return -1;
        }
        return ((ResourceRecord)this.answer.firstElement()).getType();
    }

    int getLastAnsType() {
        if (this.answer.size() == 0) {
            return -1;
        }
        return ((ResourceRecord)this.answer.lastElement()).getType();
    }

    void add(byte[] msg, int msgLen, Header hdr2) throws NamingException {
        int pos = 12;
        try {
            ResourceRecord rr;
            int i;
            for (i = 0; i < hdr2.numQuestions; ++i) {
                rr = new ResourceRecord(msg, msgLen, pos, true, false);
                if (!this.zoneXfer) {
                    this.question.addElement(rr);
                }
                pos += rr.size();
            }
            for (i = 0; i < hdr2.numAnswers; ++i) {
                rr = new ResourceRecord(msg, msgLen, pos, false, !this.zoneXfer);
                this.answer.addElement(rr);
                pos += rr.size();
            }
            if (this.zoneXfer) {
                return;
            }
            for (i = 0; i < hdr2.numAuthorities; ++i) {
                rr = new ResourceRecord(msg, msgLen, pos, false, true);
                this.authority.addElement(rr);
                pos += rr.size();
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new CommunicationException("DNS error: corrupted message");
        }
    }
}

