/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.ClassWriter;
import com.sun.java.util.jar.pack.NativeUnpack;
import com.sun.java.util.jar.pack.Package;
import com.sun.java.util.jar.pack.PackageReader;
import com.sun.java.util.jar.pack.PropMap;
import com.sun.java.util.jar.pack.Utils;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;

public class UnpackerImpl
implements Pack200.Unpacker {
    final PropMap _props = new PropMap();
    Object _nunp;

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._props.addListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._props.removeListener(listener);
    }

    public SortedMap properties() {
        return this._props;
    }

    public String toString() {
        return Utils.getVersionString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpack(InputStream in0, JarOutputStream out) throws IOException {
        assert (Utils.currentInstance.get() == null);
        TimeZone tz = this._props.getBoolean("com.sun.java.util.jar.pack.default.timezone") ? null : TimeZone.getDefault();
        try {
            Utils.currentInstance.set(this);
            if (tz != null) {
                TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
            }
            int verbose = this._props.getInteger("com.sun.java.util.jar.pack.verbose");
            BufferedInputStream in = new BufferedInputStream(in0);
            if (Utils.isJarMagic(Utils.readMagic(in))) {
                if (verbose > 0) {
                    Utils.log.info("Copying unpacked JAR file...");
                }
                Utils.copyJarFile(new JarInputStream(in), out);
            } else if (this._props.getBoolean("com.sun.java.util.jar.pack.disable.native")) {
                new DoUnpack().run(in, out);
                in.close();
                Utils.markJarFile(out);
            } else {
                new NativeUnpack(this).run(in, out);
                in.close();
                Utils.markJarFile(out);
            }
        }
        finally {
            this._nunp = null;
            Utils.currentInstance.set(null);
            if (tz != null) {
                TimeZone.setDefault(tz);
            }
        }
    }

    public void unpack(File in, JarOutputStream out) throws IOException {
        FileInputStream instr = new FileInputStream(in);
        this.unpack(instr, out);
        if (this._props.getBoolean("com.sun.java.util.jar.pack.unpack.remove.packfile")) {
            in.delete();
        }
    }

    private class DoUnpack {
        final int verbose;
        final Package pkg;
        final boolean keepModtime;
        final boolean keepDeflateHint;
        final int modtime;
        final boolean deflateHint;
        final CRC32 crc;
        final ByteArrayOutputStream bufOut;
        final OutputStream crcOut;

        private DoUnpack() {
            this.verbose = UnpackerImpl.this._props.getInteger("com.sun.java.util.jar.pack.verbose");
            UnpackerImpl.this._props.setInteger("unpack.progress", 0);
            this.pkg = new Package();
            this.keepModtime = "keep".equals(UnpackerImpl.this._props.getProperty("com.sun.java.util.jar.pack.unpack.modification.time", "keep"));
            this.keepDeflateHint = "keep".equals(UnpackerImpl.this._props.getProperty("unpack.deflate.hint", "keep"));
            this.modtime = !this.keepModtime ? UnpackerImpl.this._props.getTime("com.sun.java.util.jar.pack.unpack.modification.time") : this.pkg.default_modtime;
            this.deflateHint = this.keepDeflateHint ? false : UnpackerImpl.this._props.getBoolean("unpack.deflate.hint");
            this.crc = new CRC32();
            this.bufOut = new ByteArrayOutputStream();
            this.crcOut = new CheckedOutputStream(this.bufOut, this.crc);
        }

        public void run(BufferedInputStream in, JarOutputStream out) throws IOException {
            if (this.verbose > 0) {
                UnpackerImpl.this._props.list(System.out);
            }
            int seg = 1;
            while (true) {
                this.unpackSegment(in, out);
                if (!Utils.isPackMagic(Utils.readMagic(in))) break;
                if (this.verbose > 0) {
                    Utils.log.info("Finished segment #" + seg);
                }
                ++seg;
            }
        }

        private void unpackSegment(InputStream in, JarOutputStream out) throws IOException {
            UnpackerImpl.this._props.setProperty("unpack.progress", "0");
            new PackageReader(this.pkg, in).read();
            if (UnpackerImpl.this._props.getBoolean("unpack.strip.debug")) {
                this.pkg.stripAttributeKind("Debug");
            }
            if (UnpackerImpl.this._props.getBoolean("unpack.strip.compile")) {
                this.pkg.stripAttributeKind("Compile");
            }
            UnpackerImpl.this._props.setProperty("unpack.progress", "50");
            this.pkg.ensureAllClassFiles();
            HashSet classesToWrite = new HashSet(this.pkg.getClasses());
            for (Package.File file : this.pkg.getFiles()) {
                boolean needCRC;
                String name = file.nameString;
                JarEntry je = new JarEntry(Utils.getJarEntryName(name));
                boolean deflate = this.keepDeflateHint ? (file.options & 1) != 0 || (this.pkg.default_options & 0x20) != 0 : this.deflateHint;
                boolean bl = needCRC = !deflate;
                if (needCRC) {
                    this.crc.reset();
                }
                this.bufOut.reset();
                if (file.isClassStub()) {
                    Package.Class cls = file.getStubClass();
                    assert (cls != null);
                    new ClassWriter(cls, needCRC ? this.crcOut : this.bufOut).write();
                    classesToWrite.remove(cls);
                } else {
                    file.writeTo(needCRC ? this.crcOut : this.bufOut);
                }
                je.setMethod(deflate ? 8 : 0);
                if (needCRC) {
                    if (this.verbose > 0) {
                        Utils.log.info("stored size=" + this.bufOut.size() + " and crc=" + this.crc.getValue());
                    }
                    je.setMethod(0);
                    je.setSize(this.bufOut.size());
                    je.setCrc(this.crc.getValue());
                }
                if (this.keepModtime) {
                    je.setTime(file.modtime);
                    je.setTime((long)file.modtime * 1000L);
                } else {
                    je.setTime((long)this.modtime * 1000L);
                }
                out.putNextEntry(je);
                this.bufOut.writeTo(out);
                out.closeEntry();
                if (this.verbose <= 0) continue;
                Utils.log.info("Writing " + Utils.zeString(je));
            }
            assert (classesToWrite.isEmpty());
            UnpackerImpl.this._props.setProperty("unpack.progress", "100");
            this.pkg.reset();
        }
    }
}

