/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import com.sun.net.ssl.internal.ssl.X509ExtendedTrustManager;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.ArrayList;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.ssl.Alerts;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.CipherSuiteList;
import sun.security.ssl.DHClientKeyExchange;
import sun.security.ssl.DHCrypt;
import sun.security.ssl.Debug;
import sun.security.ssl.ECDHClientKeyExchange;
import sun.security.ssl.ECDHCrypt;
import sun.security.ssl.ExtensionType;
import sun.security.ssl.HandshakeMessage;
import sun.security.ssl.Handshaker;
import sun.security.ssl.HelloExtension;
import sun.security.ssl.JsseJce;
import sun.security.ssl.KerberosClientKeyExchange;
import sun.security.ssl.ProtocolList;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.RSAClientKeyExchange;
import sun.security.ssl.SSLContextImpl;
import sun.security.ssl.SSLEngineImpl;
import sun.security.ssl.SSLSessionContextImpl;
import sun.security.ssl.SSLSessionImpl;
import sun.security.ssl.SSLSocketImpl;
import sun.security.ssl.SupportedEllipticCurvesExtension;

final class ClientHandshaker
extends Handshaker {
    private PublicKey serverKey;
    private PublicKey ephemeralServerKey;
    private BigInteger serverDH;
    private DHCrypt dh;
    private ECDHCrypt ecdh;
    private HandshakeMessage.CertificateRequest certRequest;
    private boolean serverKeyExchangeReceived;
    private ProtocolVersion maxProtocolVersion;

    ClientHandshaker(SSLSocketImpl socket, SSLContextImpl context, ProtocolList enabledProtocols) {
        super(socket, context, enabledProtocols, true, true);
    }

    ClientHandshaker(SSLEngineImpl engine, SSLContextImpl context, ProtocolList enabledProtocols) {
        super(engine, context, enabledProtocols, true, true);
    }

    void processMessage(byte type, int messageLen) throws IOException {
        if (this.state > type && type != 0 && this.state != 1) {
            throw new SSLProtocolException("Handshake message sequence violation, " + type);
        }
        block3 : switch (type) {
            case 0: {
                this.serverHelloRequest(new HandshakeMessage.HelloRequest(this.input));
                break;
            }
            case 2: {
                this.serverHello(new HandshakeMessage.ServerHello(this.input, messageLen));
                break;
            }
            case 11: {
                if (this.keyExchange == CipherSuite.KeyExchange.K_DH_ANON || this.keyExchange == CipherSuite.KeyExchange.K_ECDH_ANON || this.keyExchange == CipherSuite.KeyExchange.K_KRB5 || this.keyExchange == CipherSuite.KeyExchange.K_KRB5_EXPORT) {
                    this.fatalSE((byte)10, "unexpected server cert chain");
                }
                this.serverCertificate(new HandshakeMessage.CertificateMsg(this.input));
                this.serverKey = this.session.getPeerCertificates()[0].getPublicKey();
                break;
            }
            case 12: {
                this.serverKeyExchangeReceived = true;
                switch (this.keyExchange) {
                    case K_RSA: 
                    case K_RSA_EXPORT: {
                        try {
                            this.serverKeyExchange(new HandshakeMessage.RSA_ServerKeyExchange(this.input));
                        }
                        catch (GeneralSecurityException e) {
                            ClientHandshaker.throwSSLException("Server key", e);
                        }
                        break block3;
                    }
                    case K_DH_ANON: {
                        this.serverKeyExchange(new HandshakeMessage.DH_ServerKeyExchange(this.input));
                        break block3;
                    }
                    case K_DHE_DSS: 
                    case K_DHE_RSA: {
                        try {
                            this.serverKeyExchange(new HandshakeMessage.DH_ServerKeyExchange(this.input, this.serverKey, this.clnt_random.random_bytes, this.svr_random.random_bytes, messageLen));
                        }
                        catch (GeneralSecurityException e) {
                            ClientHandshaker.throwSSLException("Server key", e);
                        }
                        break block3;
                    }
                    case K_ECDHE_ECDSA: 
                    case K_ECDHE_RSA: 
                    case K_ECDH_ANON: {
                        try {
                            this.serverKeyExchange(new HandshakeMessage.ECDH_ServerKeyExchange(this.input, this.serverKey, this.clnt_random.random_bytes, this.svr_random.random_bytes));
                        }
                        catch (GeneralSecurityException e) {
                            ClientHandshaker.throwSSLException("Server key", e);
                        }
                        break block3;
                    }
                    case K_ECDH_ECDSA: 
                    case K_ECDH_RSA: {
                        throw new SSLProtocolException("Protocol violation: server sent a server key exchange message for key exchange " + (Object)((Object)this.keyExchange));
                    }
                    case K_KRB5: 
                    case K_KRB5_EXPORT: {
                        throw new SSLProtocolException("unexpected receipt of server key exchange algorithm");
                    }
                }
                throw new SSLProtocolException("unsupported key exchange algorithm = " + (Object)((Object)this.keyExchange));
            }
            case 13: {
                if (this.keyExchange == CipherSuite.KeyExchange.K_DH_ANON || this.keyExchange == CipherSuite.KeyExchange.K_ECDH_ANON) {
                    throw new SSLHandshakeException("Client authentication requested for anonymous cipher suite.");
                }
                if (this.keyExchange == CipherSuite.KeyExchange.K_KRB5 || this.keyExchange == CipherSuite.KeyExchange.K_KRB5_EXPORT) {
                    throw new SSLHandshakeException("Client certificate requested for kerberos cipher suite.");
                }
                this.certRequest = new HandshakeMessage.CertificateRequest(this.input);
                if (debug == null || !Debug.isOn("handshake")) break;
                this.certRequest.print(System.out);
                break;
            }
            case 14: {
                this.serverHelloDone(new HandshakeMessage.ServerHelloDone(this.input));
                break;
            }
            case 20: {
                this.serverFinished(new HandshakeMessage.Finished(this.protocolVersion, this.input));
                break;
            }
            default: {
                throw new SSLProtocolException("Illegal client handshake msg, " + type);
            }
        }
        if (this.state < type) {
            this.state = type;
        }
    }

    private void serverHelloRequest(HandshakeMessage.HelloRequest mesg) throws IOException {
        if (debug != null && Debug.isOn("handshake")) {
            mesg.print(System.out);
        }
        if (this.state < 1) {
            this.kickstart();
        }
    }

    private void serverHello(HandshakeMessage.ServerHello mesg) throws IOException {
        ProtocolVersion mesgVersion;
        this.serverKeyExchangeReceived = false;
        if (debug != null && Debug.isOn("handshake")) {
            mesg.print(System.out);
        }
        if (!this.enabledProtocols.contains(mesgVersion = mesg.protocolVersion)) {
            throw new SSLHandshakeException("Server chose unsupported or disabled protocol: " + mesgVersion);
        }
        this.setVersion(mesgVersion);
        this.svr_random = mesg.svr_random;
        if (!this.isEnabled(mesg.cipherSuite)) {
            this.fatalSE((byte)47, "Server selected disabled ciphersuite " + this.cipherSuite);
        }
        this.setCipherSuite(mesg.cipherSuite);
        if (mesg.compression_method != 0) {
            this.fatalSE((byte)47, "compression type not supported, " + mesg.compression_method);
        }
        if (this.session != null) {
            if (this.session.getSessionId().equals(mesg.sessionId)) {
                CipherSuite sessionSuite = this.session.getSuite();
                if (this.cipherSuite != sessionSuite) {
                    throw new SSLProtocolException("Server returned wrong cipher suite for session");
                }
                ProtocolVersion sessionVersion = this.session.getProtocolVersion();
                if (this.protocolVersion != sessionVersion) {
                    throw new SSLProtocolException("Server resumed session with wrong protocol version");
                }
                if (sessionSuite.keyExchange == CipherSuite.KeyExchange.K_KRB5 || sessionSuite.keyExchange == CipherSuite.KeyExchange.K_KRB5_EXPORT) {
                    Subject subject;
                    Principal localPrincipal;
                    block20: {
                        localPrincipal = this.session.getLocalPrincipal();
                        subject = null;
                        try {
                            subject = AccessController.doPrivileged(new PrivilegedExceptionAction<Subject>(){

                                @Override
                                public Subject run() throws Exception {
                                    return Krb5Util.getSubject((int)3, (AccessControlContext)ClientHandshaker.this.getAccSE());
                                }
                            });
                        }
                        catch (PrivilegedActionException e) {
                            subject = null;
                            if (debug == null || !Debug.isOn("session")) break block20;
                            System.out.println("Attempt to obtain subject failed!");
                        }
                    }
                    if (subject != null) {
                        Set<KerberosPrincipal> principals = subject.getPrincipals(KerberosPrincipal.class);
                        if (!principals.contains(localPrincipal)) {
                            throw new SSLProtocolException("Server resumed session with wrong subject identity");
                        }
                        if (debug != null && Debug.isOn("session")) {
                            System.out.println("Subject identity is same");
                        }
                    } else {
                        if (debug != null && Debug.isOn("session")) {
                            System.out.println("Kerberos credentials are not present in the current Subject; check if  javax.security.auth.useSubjectAsCreds system property has been set to false");
                        }
                        throw new SSLProtocolException("Server resumed session with no subject");
                    }
                }
                this.resumingSession = true;
                this.state = 19;
                this.calculateConnectionKeys(this.session.getMasterSecret());
                if (debug != null && Debug.isOn("session")) {
                    System.out.println("%% Server resumed " + this.session);
                }
                return;
            }
            this.session = null;
            if (!this.enableNewSession) {
                throw new SSLException("New session creation is disabled");
            }
        }
        for (HelloExtension ext : mesg.extensions.list()) {
            ExtensionType type = ext.type;
            if (type == ExtensionType.EXT_ELLIPTIC_CURVES || type == ExtensionType.EXT_EC_POINT_FORMATS) continue;
            this.fatalSE((byte)110, "Server sent an unsupported extension: " + type);
        }
        this.session = new SSLSessionImpl(this.protocolVersion, this.cipherSuite, mesg.sessionId, this.getHostSE(), this.getPortSE());
        if (debug != null && Debug.isOn("handshake")) {
            System.out.println("** " + this.cipherSuite);
        }
    }

    private void serverKeyExchange(HandshakeMessage.RSA_ServerKeyExchange mesg) throws IOException, GeneralSecurityException {
        if (debug != null && Debug.isOn("handshake")) {
            mesg.print(System.out);
        }
        if (!mesg.verify(this.serverKey, this.clnt_random, this.svr_random)) {
            this.fatalSE((byte)40, "server key exchange invalid");
        }
        this.ephemeralServerKey = mesg.getPublicKey();
    }

    private void serverKeyExchange(HandshakeMessage.DH_ServerKeyExchange mesg) throws IOException {
        if (debug != null && Debug.isOn("handshake")) {
            mesg.print(System.out);
        }
        this.dh = new DHCrypt(mesg.getModulus(), mesg.getBase(), this.sslContext.getSecureRandom());
        this.serverDH = mesg.getServerPublicKey();
    }

    private void serverKeyExchange(HandshakeMessage.ECDH_ServerKeyExchange mesg) throws IOException {
        if (debug != null && Debug.isOn("handshake")) {
            mesg.print(System.out);
        }
        ECPublicKey key = mesg.getPublicKey();
        this.ecdh = new ECDHCrypt(key.getParams(), this.sslContext.getSecureRandom());
        this.ephemeralServerKey = key;
    }

    private void serverHelloDone(HandshakeMessage.ServerHelloDone mesg) throws IOException {
        SecretKey preMasterSecret;
        HandshakeMessage m2;
        if (debug != null && Debug.isOn("handshake")) {
            mesg.print(System.out);
        }
        this.input.digestNow();
        PrivateKey signingKey = null;
        if (this.certRequest != null) {
            X509Certificate[] certs;
            X509ExtendedKeyManager km = this.sslContext.getX509KeyManager();
            ArrayList<String> keytypesTmp = new ArrayList<String>(4);
            for (int i = 0; i < this.certRequest.types.length; ++i) {
                String typeName;
                switch (this.certRequest.types[i]) {
                    case 1: {
                        typeName = "RSA";
                        break;
                    }
                    case 2: {
                        typeName = "DSA";
                        break;
                    }
                    case 64: {
                        typeName = JsseJce.isEcAvailable() ? "EC" : null;
                        break;
                    }
                    default: {
                        typeName = null;
                    }
                }
                if (typeName == null || keytypesTmp.contains(typeName)) continue;
                keytypesTmp.add(typeName);
            }
            String alias = null;
            int keytypesTmpSize = keytypesTmp.size();
            if (keytypesTmpSize != 0) {
                String[] keytypes = keytypesTmp.toArray(new String[keytypesTmpSize]);
                alias = this.conn != null ? km.chooseClientAlias(keytypes, this.certRequest.getAuthorities(), this.conn) : km.chooseEngineClientAlias(keytypes, this.certRequest.getAuthorities(), this.engine);
            }
            HandshakeMessage m1 = null;
            if (alias != null && (certs = km.getCertificateChain(alias)) != null && certs.length != 0) {
                ECParameterSpec params;
                int index;
                PublicKey publicKey = certs[0].getPublicKey();
                if (publicKey instanceof ECPublicKey && !SupportedEllipticCurvesExtension.isSupported(index = SupportedEllipticCurvesExtension.getCurveIndex(params = ((ECPublicKey)publicKey).getParams()))) {
                    publicKey = null;
                }
                if (publicKey != null) {
                    m1 = new HandshakeMessage.CertificateMsg(certs);
                    signingKey = km.getPrivateKey(alias);
                    this.session.setLocalPrivateKey(signingKey);
                    this.session.setLocalCertificates(certs);
                }
            }
            if (m1 == null) {
                if (this.protocolVersion.v >= ProtocolVersion.TLS10.v) {
                    m1 = new HandshakeMessage.CertificateMsg(new X509Certificate[0]);
                } else {
                    this.warningSE((byte)41);
                }
            }
            if (m1 != null) {
                if (debug != null && Debug.isOn("handshake")) {
                    ((HandshakeMessage.CertificateMsg)m1).print(System.out);
                }
                m1.write(this.output);
            }
        }
        switch (this.keyExchange) {
            case K_RSA: 
            case K_RSA_EXPORT: {
                PublicKey key = this.keyExchange == CipherSuite.KeyExchange.K_RSA ? this.serverKey : this.ephemeralServerKey;
                m2 = new RSAClientKeyExchange(this.protocolVersion, this.maxProtocolVersion, this.sslContext.getSecureRandom(), key);
                break;
            }
            case K_DH_RSA: 
            case K_DH_DSS: {
                m2 = new DHClientKeyExchange();
                break;
            }
            case K_DH_ANON: 
            case K_DHE_DSS: 
            case K_DHE_RSA: {
                if (this.dh == null) {
                    throw new SSLProtocolException("Server did not send a DH Server Key Exchange message");
                }
                m2 = new DHClientKeyExchange(this.dh.getPublicKey());
                break;
            }
            case K_ECDHE_ECDSA: 
            case K_ECDHE_RSA: 
            case K_ECDH_ANON: {
                if (this.ecdh == null) {
                    throw new SSLProtocolException("Server did not send a ECDH Server Key Exchange message");
                }
                m2 = new ECDHClientKeyExchange(this.ecdh.getPublicKey());
                break;
            }
            case K_ECDH_ECDSA: 
            case K_ECDH_RSA: {
                if (this.serverKey == null) {
                    throw new SSLProtocolException("Server did not send certificate message");
                }
                if (!(this.serverKey instanceof ECPublicKey)) {
                    throw new SSLProtocolException("Server certificate does not include an EC key");
                }
                ECParameterSpec params = ((ECPublicKey)this.serverKey).getParams();
                this.ecdh = new ECDHCrypt(params, this.sslContext.getSecureRandom());
                m2 = new ECDHClientKeyExchange(this.ecdh.getPublicKey());
                break;
            }
            case K_KRB5: 
            case K_KRB5_EXPORT: {
                String hostname = this.getHostSE();
                if (hostname == null) {
                    throw new IOException("Hostname is required to use Kerberos cipher suites");
                }
                KerberosClientKeyExchange kerberosMsg = new KerberosClientKeyExchange(hostname, this.isLoopbackSE(), this.getAccSE(), this.protocolVersion, this.sslContext.getSecureRandom());
                this.session.setPeerPrincipal(kerberosMsg.getPeerPrincipal());
                this.session.setLocalPrincipal(kerberosMsg.getLocalPrincipal());
                m2 = kerberosMsg;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported key exchange: " + (Object)((Object)this.keyExchange));
            }
        }
        if (debug != null && Debug.isOn("handshake")) {
            m2.print(System.out);
        }
        m2.write(this.output);
        this.output.doHashes();
        this.output.flush();
        switch (this.keyExchange) {
            case K_RSA: 
            case K_RSA_EXPORT: {
                preMasterSecret = ((RSAClientKeyExchange)m2).preMaster;
                break;
            }
            case K_KRB5: 
            case K_KRB5_EXPORT: {
                byte[] secretBytes = ((KerberosClientKeyExchange)m2).getPreMasterSecret().getUnencrypted();
                preMasterSecret = new SecretKeySpec(secretBytes, "TlsPremasterSecret");
                break;
            }
            case K_DH_ANON: 
            case K_DHE_DSS: 
            case K_DHE_RSA: {
                preMasterSecret = this.dh.getAgreedSecret(this.serverDH);
                break;
            }
            case K_ECDHE_ECDSA: 
            case K_ECDHE_RSA: 
            case K_ECDH_ANON: {
                preMasterSecret = this.ecdh.getAgreedSecret(this.ephemeralServerKey);
                break;
            }
            case K_ECDH_ECDSA: 
            case K_ECDH_RSA: {
                preMasterSecret = this.ecdh.getAgreedSecret(this.serverKey);
                break;
            }
            default: {
                throw new IOException("Internal error: unknown key exchange " + (Object)((Object)this.keyExchange));
            }
        }
        this.calculateKeys(preMasterSecret, null);
        if (signingKey != null) {
            HandshakeMessage.CertificateVerify m3;
            try {
                m3 = new HandshakeMessage.CertificateVerify(this.protocolVersion, this.handshakeHash, signingKey, this.session.getMasterSecret(), this.sslContext.getSecureRandom());
            }
            catch (GeneralSecurityException e) {
                this.fatalSE((byte)40, "Error signing certificate verify", e);
                m3 = null;
            }
            if (debug != null && Debug.isOn("handshake")) {
                m3.print(System.out);
            }
            m3.write(this.output);
            this.output.doHashes();
        }
        this.sendChangeCipherAndFinish(false);
    }

    private void serverFinished(HandshakeMessage.Finished mesg) throws IOException {
        boolean verified;
        if (debug != null && Debug.isOn("handshake")) {
            mesg.print(System.out);
        }
        if (!(verified = mesg.verify(this.protocolVersion, this.handshakeHash, 2, this.session.getMasterSecret()))) {
            this.fatalSE((byte)47, "server 'finished' message doesn't verify");
        }
        if (this.resumingSession) {
            this.input.digestNow();
            this.sendChangeCipherAndFinish(true);
        }
        this.session.setLastAccessedTime(System.currentTimeMillis());
        if (!this.resumingSession) {
            if (this.session.isRejoinable()) {
                ((SSLSessionContextImpl)this.sslContext.engineGetClientSessionContext()).put(this.session);
                if (debug != null && Debug.isOn("session")) {
                    System.out.println("%% Cached client session: " + this.session);
                }
            } else if (debug != null && Debug.isOn("session")) {
                System.out.println("%% Didn't cache non-resumable client session: " + this.session);
            }
        }
    }

    private void sendChangeCipherAndFinish(boolean finishedTag) throws IOException {
        HandshakeMessage.Finished mesg = new HandshakeMessage.Finished(this.protocolVersion, this.handshakeHash, 1, this.session.getMasterSecret());
        this.sendChangeCipherSpec(mesg, finishedTag);
        this.state = 19;
    }

    HandshakeMessage getKickstartMessage() throws SSLException {
        HandshakeMessage.ClientHello mesg = new HandshakeMessage.ClientHello(this.sslContext.getSecureRandom(), this.protocolVersion);
        this.maxProtocolVersion = this.protocolVersion;
        this.clnt_random = mesg.clnt_random;
        this.session = ((SSLSessionContextImpl)this.sslContext.engineGetClientSessionContext()).get(this.getHostSE(), this.getPortSE());
        if (debug != null && Debug.isOn("session")) {
            if (this.session != null) {
                System.out.println("%% Client cached " + this.session + (this.session.isRejoinable() ? "" : " (not rejoinable)"));
            } else {
                System.out.println("%% No cached client session");
            }
        }
        if (this.session != null && !this.session.isRejoinable()) {
            this.session = null;
        }
        if (this.session != null) {
            CipherSuite sessionSuite = this.session.getSuite();
            ProtocolVersion sessionVersion = this.session.getProtocolVersion();
            if (!this.isEnabled(sessionSuite)) {
                if (debug != null && Debug.isOn("session")) {
                    System.out.println("%% can't resume, cipher disabled");
                }
                this.session = null;
            }
            if (this.session != null && !this.enabledProtocols.contains(sessionVersion)) {
                if (debug != null && Debug.isOn("session")) {
                    System.out.println("%% can't resume, protocol disabled");
                }
                this.session = null;
            }
            if (this.session != null) {
                if (debug != null && (Debug.isOn("handshake") || Debug.isOn("session"))) {
                    System.out.println("%% Try resuming " + this.session + " from port " + this.getLocalPortSE());
                }
                mesg.sessionId = this.session.getSessionId();
                mesg.protocolVersion = sessionVersion;
                this.maxProtocolVersion = sessionVersion;
                this.setVersion(sessionVersion);
            }
            if (!this.enableNewSession) {
                if (this.session == null) {
                    throw new SSLException("Can't reuse existing SSL client session");
                }
                mesg.setCipherSuites(new CipherSuiteList(sessionSuite));
                return mesg;
            }
        }
        if (this.session == null) {
            if (this.enableNewSession) {
                mesg.sessionId = SSLSessionImpl.nullSession.getSessionId();
            } else {
                throw new SSLException("No existing session to resume.");
            }
        }
        mesg.setCipherSuites(this.enabledCipherSuites);
        return mesg;
    }

    void handshakeAlert(byte description) throws SSLProtocolException {
        String message = Alerts.alertDescription(description);
        if (debug != null && Debug.isOn("handshake")) {
            System.out.println("SSL - handshake alert: " + message);
        }
        throw new SSLProtocolException("handshake alert:  " + message);
    }

    private void serverCertificate(HandshakeMessage.CertificateMsg mesg) throws IOException {
        X509Certificate[] peerCerts;
        if (debug != null && Debug.isOn("handshake")) {
            mesg.print(System.out);
        }
        if ((peerCerts = mesg.getCertificateChain()).length == 0) {
            this.fatalSE((byte)42, "empty certificate chain");
        }
        X509TrustManager tm = this.sslContext.getX509TrustManager();
        try {
            String keyExchangeString = this.keyExchange == CipherSuite.KeyExchange.K_RSA_EXPORT && !this.serverKeyExchangeReceived ? CipherSuite.KeyExchange.K_RSA.name : this.keyExchange.name;
            String identificator = this.getHostnameVerificationSE();
            if (tm instanceof X509ExtendedTrustManager) {
                ((X509ExtendedTrustManager)tm).checkServerTrusted(peerCerts != null ? (X509Certificate[])peerCerts.clone() : null, keyExchangeString, this.getHostSE(), identificator);
            } else {
                if (identificator != null) {
                    throw new RuntimeException("trust manager does not support peer identification");
                }
                tm.checkServerTrusted(peerCerts != null ? (X509Certificate[])peerCerts.clone() : peerCerts, keyExchangeString);
            }
        }
        catch (CertificateException e) {
            this.fatalSE((byte)46, e);
        }
        this.session.setPeerCertificates(peerCerts);
    }
}

