/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.crypto;

import sun.security.krb5.Confounder;
import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.crypto.Des;
import sun.security.krb5.internal.crypto.EType;

abstract class DesCbcEType
extends EType {
    DesCbcEType() {
    }

    protected abstract byte[] calculateChecksum(byte[] var1, int var2) throws KrbCryptoException;

    public int blockSize() {
        return 8;
    }

    public int keyType() {
        return 1;
    }

    public int keySize() {
        return 8;
    }

    public byte[] encrypt(byte[] data, byte[] key, int usage) throws KrbCryptoException {
        byte[] ivec = new byte[this.keySize()];
        return this.encrypt(data, key, ivec, usage);
    }

    public byte[] encrypt(byte[] data, byte[] key, byte[] ivec, int usage) throws KrbCryptoException {
        int pad;
        byte[] new_data;
        if (key.length > 8) {
            throw new KrbCryptoException("Invalid DES Key!");
        }
        int new_size = data.length + this.confounderSize() + this.checksumSize();
        if (new_size % this.blockSize() == 0) {
            new_data = new byte[new_size + this.blockSize()];
            pad = 8;
        } else {
            new_data = new byte[new_size + this.blockSize() - new_size % this.blockSize()];
            pad = (byte)(this.blockSize() - new_size % this.blockSize());
        }
        for (int i = new_size; i < new_data.length; ++i) {
            new_data[i] = pad;
        }
        byte[] conf = Confounder.bytes(this.confounderSize());
        System.arraycopy(conf, 0, new_data, 0, this.confounderSize());
        System.arraycopy(data, 0, new_data, this.startOfData(), data.length);
        byte[] cksum = this.calculateChecksum(new_data, new_data.length);
        System.arraycopy(cksum, 0, new_data, this.startOfChecksum(), this.checksumSize());
        byte[] cipher = new byte[new_data.length];
        Des.cbc_encrypt(new_data, cipher, key, ivec, true);
        return cipher;
    }

    public byte[] decrypt(byte[] cipher, byte[] key, int usage) throws KrbApErrException, KrbCryptoException {
        byte[] ivec = new byte[this.keySize()];
        return this.decrypt(cipher, key, ivec, usage);
    }

    public byte[] decrypt(byte[] cipher, byte[] key, byte[] ivec, int usage) throws KrbApErrException, KrbCryptoException {
        if (key.length > 8) {
            throw new KrbCryptoException("Invalid DES Key!");
        }
        byte[] data = new byte[cipher.length];
        Des.cbc_encrypt(cipher, data, key, ivec, false);
        if (!this.isChecksumValid(data)) {
            throw new KrbApErrException(31);
        }
        return data;
    }

    private void copyChecksumField(byte[] data, byte[] cksum) {
        for (int i = 0; i < this.checksumSize(); ++i) {
            data[this.startOfChecksum() + i] = cksum[i];
        }
    }

    private byte[] checksumField(byte[] data) {
        byte[] result = new byte[this.checksumSize()];
        for (int i = 0; i < this.checksumSize(); ++i) {
            result[i] = data[this.startOfChecksum() + i];
        }
        return result;
    }

    private void resetChecksumField(byte[] data) {
        for (int i = this.startOfChecksum(); i < this.startOfChecksum() + this.checksumSize(); ++i) {
            data[i] = 0;
        }
    }

    private byte[] generateChecksum(byte[] data) throws KrbCryptoException {
        byte[] cksum1 = this.checksumField(data);
        this.resetChecksumField(data);
        byte[] cksum2 = this.calculateChecksum(data, data.length);
        this.copyChecksumField(data, cksum1);
        return cksum2;
    }

    private boolean isChecksumEqual(byte[] cksum1, byte[] cksum2) {
        if (cksum1 == cksum2) {
            return true;
        }
        if (cksum1 == null && cksum2 != null || cksum1 != null && cksum2 == null) {
            return false;
        }
        if (cksum1.length != cksum2.length) {
            return false;
        }
        for (int i = 0; i < cksum1.length; ++i) {
            if (cksum1[i] == cksum2[i]) continue;
            return false;
        }
        return true;
    }

    protected boolean isChecksumValid(byte[] data) throws KrbCryptoException {
        byte[] cksum1 = this.checksumField(data);
        byte[] cksum2 = this.generateChecksum(data);
        return this.isChecksumEqual(cksum1, cksum2);
    }
}

