/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Vector;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.KrbException;
import sun.security.krb5.internal.KDCReqBody;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.PAData;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class KDCReq {
    public KDCReqBody reqBody;
    private int pvno;
    private int msgType;
    private PAData[] pAData = null;

    public KDCReq(PAData[] new_pAData, KDCReqBody new_reqBody, int req_type) throws IOException {
        this.pvno = 5;
        this.msgType = req_type;
        if (new_pAData != null) {
            this.pAData = new PAData[new_pAData.length];
            for (int i = 0; i < new_pAData.length; ++i) {
                if (new_pAData[i] == null) {
                    throw new IOException("Cannot create a KDCRep");
                }
                this.pAData[i] = (PAData)new_pAData[i].clone();
            }
        }
        this.reqBody = new_reqBody;
    }

    public KDCReq() {
    }

    public KDCReq(byte[] data, int req_type) throws Asn1Exception, IOException, KrbException {
        this.init(new DerValue(data), req_type);
    }

    public KDCReq(DerValue der, int req_type) throws Asn1Exception, IOException, KrbException {
        this.init(der, req_type);
    }

    protected void init(DerValue encoding, int req_type) throws Asn1Exception, IOException, KrbException {
        DerValue subsubDer;
        BigInteger bint;
        if ((encoding.getTag() & 0x1F) != req_type) {
            throw new Asn1Exception(906);
        }
        DerValue der = encoding.getData().getDerValue();
        if (der.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue subDer = der.getData().getDerValue();
        if ((subDer.getTag() & 0x1F) == 1) {
            bint = subDer.getData().getBigInteger();
            this.pvno = bint.intValue();
            if (this.pvno != 5) {
                throw new KrbApErrException(39);
            }
        } else {
            throw new Asn1Exception(906);
        }
        subDer = der.getData().getDerValue();
        if ((subDer.getTag() & 0x1F) == 2) {
            bint = subDer.getData().getBigInteger();
            this.msgType = bint.intValue();
            if (this.msgType != req_type) {
                throw new KrbApErrException(40);
            }
        } else {
            throw new Asn1Exception(906);
        }
        subDer = der.getData().getDerValue();
        if ((subDer.getTag() & 0x1F) == 3) {
            subsubDer = subDer.getData().getDerValue();
            if (subsubDer.getTag() != 48) {
                throw new Asn1Exception(906);
            }
            Vector<PAData> v = new Vector<PAData>();
            while (subsubDer.getData().available() > 0) {
                v.addElement(new PAData(subsubDer.getData().getDerValue()));
            }
            if (v.size() > 0) {
                this.pAData = new PAData[v.size()];
                v.copyInto(this.pAData);
            }
        } else {
            this.pAData = null;
        }
        subDer = der.getData().getDerValue();
        if ((subDer.getTag() & 0x1F) != 4) {
            throw new Asn1Exception(906);
        }
        subsubDer = subDer.getData().getDerValue();
        this.reqBody = new KDCReqBody(subsubDer, this.msgType);
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream bytes;
        DerOutputStream temp = new DerOutputStream();
        temp.putInteger(BigInteger.valueOf(this.pvno));
        DerOutputStream out = new DerOutputStream();
        out.write(DerValue.createTag((byte)-128, true, (byte)1), temp);
        temp = new DerOutputStream();
        temp.putInteger(BigInteger.valueOf(this.msgType));
        out.write(DerValue.createTag((byte)-128, true, (byte)2), temp);
        if (this.pAData != null && this.pAData.length > 0) {
            temp = new DerOutputStream();
            for (int i = 0; i < this.pAData.length; ++i) {
                temp.write(this.pAData[i].asn1Encode());
            }
            bytes = new DerOutputStream();
            bytes.write((byte)48, temp);
            out.write(DerValue.createTag((byte)-128, true, (byte)3), bytes);
        }
        out.write(DerValue.createTag((byte)-128, true, (byte)4), this.reqBody.asn1Encode(this.msgType));
        bytes = new DerOutputStream();
        bytes.write((byte)48, out);
        out = new DerOutputStream();
        out.write(DerValue.createTag((byte)64, true, (byte)this.msgType), bytes);
        return out.toByteArray();
    }

    public byte[] asn1EncodeReqBody() throws Asn1Exception, IOException {
        return this.reqBody.asn1Encode(this.msgType);
    }
}

