/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.spnego;

import java.io.IOException;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSUtil;
import sun.security.jgss.spnego.SpNegoToken;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

public class NegTokenTarg
extends SpNegoToken {
    private int negResult = 0;
    private Oid supportedMech = null;
    private byte[] responseToken = null;
    private byte[] mechListMIC = null;

    NegTokenTarg(int result, Oid mech, byte[] token, byte[] mechListMIC) {
        super(1);
        this.negResult = result;
        this.supportedMech = mech;
        this.responseToken = token;
        this.mechListMIC = mechListMIC;
    }

    public NegTokenTarg(byte[] in) throws GSSException {
        super(1);
        this.parseToken(in);
    }

    final byte[] encode() throws GSSException {
        try {
            DerOutputStream rspToken;
            DerOutputStream targToken = new DerOutputStream();
            DerOutputStream result = new DerOutputStream();
            result.putEnumerated(this.negResult);
            targToken.write(DerValue.createTag((byte)-128, true, (byte)0), result);
            if (this.supportedMech != null) {
                DerOutputStream mech = new DerOutputStream();
                byte[] mechType = this.supportedMech.getDER();
                mech.write(mechType);
                targToken.write(DerValue.createTag((byte)-128, true, (byte)1), mech);
            }
            if (this.responseToken != null) {
                rspToken = new DerOutputStream();
                rspToken.putOctetString(this.responseToken);
                targToken.write(DerValue.createTag((byte)-128, true, (byte)2), rspToken);
            }
            if (this.mechListMIC != null) {
                if (DEBUG) {
                    System.out.println("SpNegoToken NegTokenTarg: sending MechListMIC");
                }
                DerOutputStream mic = new DerOutputStream();
                mic.putOctetString(this.mechListMIC);
                targToken.write(DerValue.createTag((byte)-128, true, (byte)3), mic);
            } else if (GSSUtil.useMSInterop() && this.responseToken != null) {
                if (DEBUG) {
                    System.out.println("SpNegoToken NegTokenTarg: sending additional token for MS Interop");
                }
                rspToken = new DerOutputStream();
                rspToken.putOctetString(this.responseToken);
                targToken.write(DerValue.createTag((byte)-128, true, (byte)3), rspToken);
            }
            DerOutputStream out = new DerOutputStream();
            out.write((byte)48, targToken);
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new GSSException(10, -1, "Invalid SPNEGO NegTokenTarg token : " + e.getMessage());
        }
    }

    private void parseToken(byte[] in) throws GSSException {
        try {
            DerValue der = new DerValue(in);
            if (!der.isContextSpecific((byte)1)) {
                throw new IOException("SPNEGO NegoTokenTarg : did not have the right token type");
            }
            DerValue tmp1 = der.data.getDerValue();
            if (tmp1.tag != 48) {
                throw new IOException("SPNEGO NegoTokenTarg : did not have the Sequence tag");
            }
            if (tmp1.data.available() > 0) {
                DerValue tmp2 = tmp1.data.getDerValue();
                if (!tmp2.isContextSpecific((byte)0)) {
                    throw new IOException("SPNEGO NegoTokenTarg : did not have the right context tag for negResult");
                }
                this.negResult = tmp2.data.getEnumerated();
                if (DEBUG) {
                    System.out.println("SpNegoToken NegTokenTarg: negotiated result = " + NegTokenTarg.getNegoResultString(this.negResult));
                }
            }
            if (tmp1.data.available() > 0) {
                DerValue tmp3 = tmp1.data.getDerValue();
                if (!tmp3.isContextSpecific((byte)1)) {
                    throw new IOException("SPNEGO NegoTokenTarg : did not have the right context tag for supportedMech");
                }
                ObjectIdentifier mech = tmp3.data.getOID();
                this.supportedMech = new Oid(mech.toString());
                if (DEBUG) {
                    System.out.println("SpNegoToken NegTokenTarg: supported mechanism = " + this.supportedMech);
                }
            }
            if (tmp1.data.available() > 0) {
                DerValue tmp4 = tmp1.data.getDerValue();
                if (!tmp4.isContextSpecific((byte)2)) {
                    throw new IOException("SPNEGO NegoTokenTarg : did not have the right context tag for response token");
                }
                this.responseToken = tmp4.data.getOctetString();
            }
            if (!GSSUtil.useMSInterop() && tmp1.data.available() > 0) {
                DerValue tmp5;
                if (DEBUG) {
                    System.out.println("SpNegoToken NegTokenTarg: receiving MechListMIC");
                }
                if (!(tmp5 = tmp1.data.getDerValue()).isContextSpecific((byte)3)) {
                    throw new IOException("SPNEGO NegoTokenTarg : did not have the right context tag for mechListMIC");
                }
                this.mechListMIC = tmp5.data.getOctetString();
                if (DEBUG) {
                    System.out.println("SpNegoToken NegTokenTarg: MechListMIC Token = " + NegTokenTarg.getHexBytes(this.mechListMIC));
                }
            } else if (DEBUG) {
                System.out.println("SpNegoToken NegTokenTarg : no MIC token included");
            }
        }
        catch (IOException e) {
            throw new GSSException(10, -1, "Invalid SPNEGO NegTokenTarg token : " + e.getMessage());
        }
    }

    int getNegotiatedResult() {
        return this.negResult;
    }

    public Oid getSupportedMech() {
        return this.supportedMech;
    }

    byte[] getResponseToken() {
        return this.responseToken;
    }

    byte[] getMechListMIC() {
        return this.mechListMIC;
    }
}

