/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.util.ArrayList;
import javax.print.attribute.EnumSyntax;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;

class CustomMediaSizeName
extends MediaSizeName {
    private static ArrayList customStringTable = new ArrayList();
    private static ArrayList customEnumTable = new ArrayList();
    private String choiceName;
    private MediaSizeName mediaName;
    private static final long serialVersionUID = 7412807582228043717L;

    private CustomMediaSizeName(int x) {
        super(x);
    }

    private static synchronized int nextValue(String name) {
        customStringTable.add(name);
        return customStringTable.size() - 1;
    }

    public CustomMediaSizeName(String name) {
        super(CustomMediaSizeName.nextValue(name));
        customEnumTable.add(this);
        this.choiceName = null;
        this.mediaName = null;
    }

    public CustomMediaSizeName(String name, String choice, float width, float length) {
        super(CustomMediaSizeName.nextValue(name));
        this.choiceName = choice;
        customEnumTable.add(this);
        this.mediaName = null;
        try {
            this.mediaName = MediaSize.findMedia(width, length, 25400);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
    }

    public String getChoiceName() {
        return this.choiceName;
    }

    public MediaSizeName getStandardMedia() {
        return this.mediaName;
    }

    public static MediaSizeName findMedia(Media[] media, float x, float y, int units) {
        if (x <= 0.0f || y <= 0.0f || units < 1) {
            throw new IllegalArgumentException("args must be +ve values");
        }
        if (media == null || media.length == 0) {
            throw new IllegalArgumentException("args must have valid array of media");
        }
        int size = 0;
        MediaSizeName[] msn = new MediaSizeName[media.length];
        for (int i = 0; i < media.length; ++i) {
            if (!(media[i] instanceof MediaSizeName)) continue;
            msn[size++] = (MediaSizeName)media[i];
        }
        if (size == 0) {
            return null;
        }
        int match = 0;
        double ls = x * x + y * y;
        float diffx = x;
        float diffy = y;
        for (int i = 0; i < size; ++i) {
            MediaSize mediaSize = MediaSize.getMediaSizeForName(msn[i]);
            if (mediaSize == null) continue;
            float[] dim = mediaSize.getSize(units);
            if (x == dim[0] && y == dim[1]) {
                match = i;
                break;
            }
            diffx = x - dim[0];
            diffy = y - dim[1];
            double tmp_ls = diffx * diffx + diffy * diffy;
            if (!(tmp_ls < ls)) continue;
            ls = tmp_ls;
            match = i;
        }
        return msn[match];
    }

    public Media[] getSuperEnumTable() {
        return (Media[])super.getEnumValueTable();
    }

    protected String[] getStringTable() {
        String[] nameTable = new String[customStringTable.size()];
        return customStringTable.toArray(nameTable);
    }

    protected EnumSyntax[] getEnumValueTable() {
        MediaSizeName[] enumTable = new MediaSizeName[customEnumTable.size()];
        return customEnumTable.toArray(enumTable);
    }
}

